/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.performance;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import net.sourceforge.jwebunit.html.Table;

public class VeryLargeCsvImporterTest
extends CrowdAcceptanceTestCase {
    private String userFileLocation = null;
    private String groupmembershipFileLocation = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreBaseSetup();
        this.gotoImporters();
        this.setRadioButton("importType", "CSV");
        this.submit();
    }

    public void testCsvImportVeryLargeDatasetOfUsers() throws IOException {
        this.testCsvImportUsers(100000);
    }

    public void testCsvImportVeryLargeDatasetOfUsersAndGroupMemberships() throws IOException {
        this.testCsvImportUsersAndGroupMappings(100000, 1000, 10);
    }

    private File createCsvUsersFile(int users) throws IOException {
        File file = new File("users.csv");
        BufferedWriter userWriter = new BufferedWriter(new FileWriter(file));
        userWriter.write("User Name, First Name, Last Name, Email Address, Password");
        userWriter.newLine();
        DecimalFormat df = new DecimalFormat("0000000");
        for (int j = 0; j < users; ++j) {
            String userNumber = df.format(j);
            userWriter.write("user" + userNumber);
            userWriter.write(", First" + userNumber);
            userWriter.write(", Last" + userNumber);
            userWriter.write(", user" + userNumber + "@example.com");
            userWriter.write(", secret" + userNumber);
            userWriter.newLine();
        }
        userWriter.close();
        return file;
    }

    private File createCsvMembershipsFile(int users, int groups, int membershipsPerUser) throws IOException {
        File file = new File("memberships.csv");
        BufferedWriter membershipWriter = new BufferedWriter(new FileWriter(file));
        membershipWriter.write("User,Group");
        membershipWriter.newLine();
        DecimalFormat df = new DecimalFormat("0000000");
        for (int j = 0; j < users; ++j) {
            String userNumber = df.format(j);
            for (int k = 0; k < membershipsPerUser; ++k) {
                membershipWriter.write("user" + userNumber);
                String groupNumber = df.format((k + j * groups / users) % groups);
                membershipWriter.write(", group" + groupNumber);
                membershipWriter.newLine();
            }
        }
        membershipWriter.close();
        return file;
    }

    private void testCsvImportUsers(int users) throws IOException {
        this.log("Running testCsvImportUsers(" + users + " users)");
        this.userFileLocation = this.createCsvUsersFile(users).getCanonicalPath();
        this.setWorkingForm("dataimport");
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.text");
        this.selectOptionByValue("user.0", "user.username");
        this.selectOptionByValue("user.1", "user.firstname");
        this.selectOptionByValue("user.2", "user.lastname");
        this.selectOptionByValue("user.3", "user.emailaddress");
        this.selectOptionByValue("user.4", "user.password");
        this.assertKeyNotPresent("dataimport.csv.configuration.groupmapping.label");
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.confirmation.text");
        this.assertKeyPresent("dataimport.csv.configuration.passwordencrypted.label", this.getMessage("yes.label"));
        this.assertKeyPresent("dataimport.csv.configuration.userfile.label", this.userFileLocation);
        this.assertKeyNotPresent("dataimport.csv.configuration.groupmembershipfile.label");
        Object[][] userMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User Name", this.getMessage("user.username")}, {"First Name", this.getMessage("user.firstname")}, {"Last Name", this.getMessage("user.lastname")}, {"Email Address", this.getMessage("user.emailaddress")}, {"Password", this.getMessage("user.password")}};
        this.assertTableEquals("usermappings", new Table(userMappingsTableData));
        this.assertKeyNotPresent("dataimport.csv.configuration.groupmapping.label");
        this.assertTableNotPresent("groupmappings");
        long startTime = System.currentTimeMillis();
        this.submit();
        long timeTaken = System.currentTimeMillis() - startTime;
        this.log("Import process took " + timeTaken + " ms");
        this.assertKeyPresent("dataimport.csv.result.text");
        this.assertTextInElement("users-imported", "" + users);
        this.assertTextInElement("groups-imported", "0");
        this.assertTextInElement("memberships-imported", "0");
        this.log("Finished importing " + users + " users");
    }

    public void testCsvImportUsersAndGroupMappings(int users, int groups, int membershipsPerUser) throws IOException {
        this.log("Running testCsvImportUsersAndGroupMappings(" + users + " users, " + groups + " groups, " + membershipsPerUser + " membershipsPerUser)");
        this.userFileLocation = this.createCsvUsersFile(users).getCanonicalPath();
        this.groupmembershipFileLocation = this.createCsvMembershipsFile(users, groups, membershipsPerUser).getCanonicalPath();
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.setTextField("groupMemberships", this.groupmembershipFileLocation);
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.text");
        this.selectOptionByValue("user.0", "user.username");
        this.selectOptionByValue("user.1", "user.firstname");
        this.selectOptionByValue("user.2", "user.lastname");
        this.selectOptionByValue("user.3", "user.emailaddress");
        this.selectOptionByValue("user.4", "user.password");
        this.selectOptionByValue("group.0", "group.username");
        this.selectOptionByValue("group.1", "group.name");
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.confirmation.text");
        this.assertKeyPresent("dataimport.csv.configuration.passwordencrypted.label", this.getMessage("yes.label"));
        this.assertKeyPresent("dataimport.csv.configuration.userfile.label", this.userFileLocation);
        this.assertKeyPresent("dataimport.csv.configuration.groupmembershipfile.label", this.groupmembershipFileLocation);
        Object[][] userMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User Name", this.getMessage("user.username")}, {"First Name", this.getMessage("user.firstname")}, {"Last Name", this.getMessage("user.lastname")}, {"Email Address", this.getMessage("user.emailaddress")}, {"Password", this.getMessage("user.password")}};
        this.assertTableEquals("usermappings", new Table(userMappingsTableData));
        Object[][] groupMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User", this.getMessage("group.username")}, {"Group", this.getMessage("group.name")}};
        this.assertTableEquals("groupmappings", new Table(groupMappingsTableData));
        long startTime = System.currentTimeMillis();
        this.submit();
        this.assertTextInElement("users-imported", "" + users);
        this.assertTextInElement("groups-imported", "" + groups);
        this.assertTextInElement("memberships-imported", "" + membershipsPerUser * users);
        long timeTaken = System.currentTimeMillis() - startTime;
        this.log("Import process took " + timeTaken + " ms");
        this.log("Finished importing " + users + " users, " + groups + " groups and " + membershipsPerUser * users + " memberships");
    }
}

