/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.BaseUrlFromProperties;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.Assert;
import org.junit.Test;

public class WebAppTest {
    @Test
    public void classpathResourceCannotBeFetched() throws IOException {
        String baseUrl = BaseUrlFromProperties.withLocalTestProperties().baseUrlFor("crowd");
        String resourceUrl = baseUrl + "/s///X/_/WEB-INF/web.xml";
        HttpURLConnection conn = (HttpURLConnection)new URL(resourceUrl).openConnection();
        Assert.assertEquals((long)404L, (long)conn.getResponseCode());
        String content = IOUtils.toString((InputStream)conn.getErrorStream(), (String)"utf-8");
        Assert.assertThat((Object)content, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"<web-app")));
    }

    @Test
    public void classpathResourceCannotBeFetchedWithParentTraversal() throws IOException {
        String baseUrl = BaseUrlFromProperties.withLocalTestProperties().baseUrlFor("crowd");
        String resourceUrl = baseUrl + "/s///X/_/download/../WEB-INF/web.xml";
        HttpURLConnection conn = (HttpURLConnection)new URL(resourceUrl).openConnection();
        Assert.assertEquals((long)404L, (long)conn.getResponseCode());
        String content = IOUtils.toString((InputStream)conn.getErrorStream(), (String)"utf-8");
        Assert.assertThat((Object)content, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"<web-app")));
    }

    @Test
    public void classpathResourceCannotBeFetchedWithPercentEncodedParentTraversal() throws IOException {
        String baseUrl = BaseUrlFromProperties.withLocalTestProperties().baseUrlFor("crowd");
        String resourceUrl = baseUrl + "/s///X/_/download/%2E./WEB-INF/web.xml";
        HttpURLConnection conn = (HttpURLConnection)new URL(resourceUrl).openConnection();
        Assert.assertEquals((long)404L, (long)conn.getResponseCode());
        String content = IOUtils.toString((InputStream)conn.getErrorStream(), (String)"utf-8");
        Assert.assertThat((Object)content, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"<web-app")));
    }

    @Test
    public void staticResourceCanBeFetchedAndHasExpirySet() throws IOException {
        String baseUrl = BaseUrlFromProperties.withLocalTestProperties().baseUrlFor("crowd");
        String resourceUrl = baseUrl + "/s///X/_/download/batch/com.atlassian.plugins.jquery:jquery/com.atlassian.plugins.jquery:jquery.js";
        HttpURLConnection conn = (HttpURLConnection)new URL(resourceUrl).openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertThat((Object)conn.getContentType(), (Matcher)Matchers.either((Matcher)Matchers.startsWith((String)"text/javascript")).or(Matchers.startsWith((String)"application/javascript")));
        long exp = conn.getExpiration();
        Assert.assertNotEquals((long)exp, (long)0L);
        Assert.assertThat((Object)new Date(exp), (Matcher)Matchers.greaterThan((Comparable)new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(30L))));
        String content = IOUtils.toString((InputStream)conn.getInputStream(), (String)"utf-8");
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"jquery"));
    }

    @Test
    public void tomcatJSessionIdIsHttpOnlyCookie() throws Exception {
        String baseUrl = BaseUrlFromProperties.withLocalTestProperties().baseUrlFor("crowd");
        HttpURLConnection conn = (HttpURLConnection)new URL(baseUrl + "/").openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.connect();
        Assert.assertEquals((String)"Should be redirected", (long)302L, (long)conn.getResponseCode());
        String setCookie = conn.getHeaderField("Set-Cookie");
        Assert.assertNotNull((String)"Should be provided with a session cookie", (Object)setCookie);
        try {
            Assert.assertEquals((Object)"JSESSIONID", (Object)HttpCookie.parse(setCookie).get(0).getName());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)(e.toString() + ": " + setCookie));
        }
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((char)';').trimResults().split((CharSequence)setCookie));
        Assert.assertThat((Object)parts, (Matcher)Matchers.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"HttpOnly")));
    }
}

