/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.util.Arrays;

public class ViewApplicationTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testUpdateApplicationDetails() {
        this.intendToModifyData();
        this.log("Running: testUpdateApplicationDetails");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.setWorkingForm("applicationDetails");
        this.setTextField("name", "demo-updated");
        this.setTextField("applicationDescription", "Crowd Demo Application Updated");
        this.uncheckCheckbox("active");
        this.submit();
        this.assertTextInElement("application-name", "demo");
        this.assertTextFieldEquals("name", "demo-updated");
        this.assertTextFieldEquals("applicationDescription", "Crowd Demo Application Updated");
        this.assertCheckboxNotSelected("active");
    }

    public void testUpdateDetailsForPermanentApplication() {
        this.intendToModifyData();
        this.log("Running: testUpdateDetailsForPermanentApplication");
        this.gotoViewApplication("crowd");
        this.assertTextInElement("application-name", "crowd");
        String disabled = this.tester.getElementAttributByXPath("//*[@id=\"name\"]", "disabled");
        ViewApplicationTest.assertEquals((String)"disabled", (String)disabled);
    }

    public void testUpdateApplicationWithMismatchedPassword() {
        this.log("Running: testUpdateApplicationWithMismatchedPassword");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.setWorkingForm("applicationDetails");
        this.setTextField("password", "value1");
        this.setTextField("passwordConfirm", "value2");
        this.submit();
        this.assertTextInElement("application-name", "demo");
        this.assertKeyPresent("invalid.passwordmismatch");
    }

    public void testUpdateApplicationWithExistingApplicationName() {
        this.log("Running: testUpdateApplicationWithExistingApplicationName");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.setWorkingForm("applicationDetails");
        this.setTextField("name", "crowd");
        this.submit();
        this.assertTextInElement("application-name", "demo");
        this.assertKeyPresent("invalid.namealreadyexist.application");
    }

    public void testUpdateApplicationWithNoName() {
        this.log("Running: testUpdateApplicationWithNoName");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.setWorkingForm("applicationDetails");
        this.setTextField("name", "");
        this.submit();
        this.assertTextInElement("application-name", "demo");
        this.assertKeyPresent("application.name.invalid");
    }

    public void testAddSecondDirectoryToApplication() {
        this.intendToModifyData();
        this.log("Running: testAddSecondDirectoryToApplication");
        this.restoreCrowdFromXML("viewapplication_addseconddirectory.xml");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-directories");
        this.clickButton("add-directory");
        this.assertTextInTable("directoriesTable", "Second Internal Directory");
    }

    public void testAddRemoteAddressToApplication() {
        this.intendToModifyData();
        this.log("Running: testAddRemoteAddressToApplication");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-remoteaddress");
        this.setTextField("address", "192.168.0.0");
        this.clickButton("add-address");
        this.assertTextInTable("addressesTable", "192.168.0.0");
    }

    public void testSearchUsersInApplication() {
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-users");
        this.setTextField("search", "min");
        this.submit();
        this.assertMatchInTable("user-details", "admin");
    }

    public void testUpdateDirectoryOrdering() {
        this.intendToModifyData();
        this.log("Running: testUpdateDirectoryOrdering");
        this.restoreCrowdFromXML("directoryordering.xml");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-directories");
        this.assertLinkPresent("down-16023553");
        this.assertLinkPresent("up-16023554");
        this.assertLinkPresent("down-16023554");
        this.assertLinkPresent("up-16023555");
        this.clickLink("down-16023553");
        this.clickLink("up-16023555");
        this.assertLinkPresent("down-16023554");
        this.assertLinkPresent("up-16023555");
        this.assertLinkPresent("down-16023555");
        this.assertLinkPresent("up-16023553");
    }

    public void testUpdateApplicationOptions() {
        this.intendToModifyData();
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-options");
        this.checkCheckbox("lowerCaseOutput");
        this.checkCheckbox("aliasingEnabled");
        this.submit();
        this.assertCheckboxSelected("lowerCaseOutput");
        this.assertCheckboxSelected("aliasingEnabled");
        this.uncheckCheckbox("lowerCaseOutput");
        this.uncheckCheckbox("aliasingEnabled");
        this.submit();
        this.assertCheckboxNotSelected("lowerCaseOutput");
        this.assertCheckboxNotSelected("aliasingEnabled");
    }

    public void testUpdateApplicationDirectoryPermissions() {
        this.intendToModifyData();
        this.log("Running: testUpdateApplicationDirectoryPermissions");
        this.restoreCrowdFromXML("directoryordering.xml");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-permissions");
        this.selectOptionByValue("directoryId", "16023553");
        this.assertCheckboxSelected("CREATE_GROUP");
        this.assertCheckboxSelected("CREATE_USER");
        this.assertCheckboxNotPresent("CREATE_ROLE");
        this.assertCheckboxSelected("UPDATE_GROUP");
        this.assertCheckboxSelected("UPDATE_USER");
        this.assertCheckboxNotPresent("UPDATE_ROLE");
        this.assertCheckboxSelected("DELETE_GROUP");
        this.assertCheckboxSelected("DELETE_USER");
        this.assertCheckboxNotPresent("DELETE_ROLE");
        this.uncheckCheckbox("CREATE_GROUP");
        this.uncheckCheckbox("CREATE_USER");
        this.uncheckCheckbox("UPDATE_GROUP");
        this.uncheckCheckbox("UPDATE_USER");
        this.uncheckCheckbox("DELETE_GROUP");
        this.uncheckCheckbox("DELETE_USER");
        this.submit();
        this.assertCheckboxNotSelected("CREATE_GROUP");
        this.assertCheckboxNotSelected("CREATE_USER");
        this.assertCheckboxNotPresent("CREATE_ROLE");
        this.assertCheckboxNotSelected("UPDATE_GROUP");
        this.assertCheckboxNotSelected("UPDATE_USER");
        this.assertCheckboxNotPresent("UPDATE_ROLE");
        this.assertCheckboxNotSelected("DELETE_GROUP");
        this.assertCheckboxNotSelected("DELETE_USER");
        this.assertCheckboxNotPresent("DELETE_ROLE");
        this.checkCheckbox("CREATE_GROUP");
        this.checkCheckbox("CREATE_USER");
        this.checkCheckbox("UPDATE_GROUP");
        this.checkCheckbox("UPDATE_USER");
        this.checkCheckbox("DELETE_GROUP");
        this.checkCheckbox("DELETE_USER");
        this.submit();
        this.assertCheckboxSelected("CREATE_GROUP");
        this.assertCheckboxSelected("CREATE_USER");
        this.assertCheckboxNotPresent("CREATE_ROLE");
        this.assertCheckboxSelected("UPDATE_GROUP");
        this.assertCheckboxSelected("UPDATE_USER");
        this.assertCheckboxNotPresent("UPDATE_ROLE");
        this.assertCheckboxSelected("DELETE_GROUP");
        this.assertCheckboxSelected("DELETE_USER");
        this.assertCheckboxNotPresent("DELETE_ROLE");
    }

    public void testRemoveLastDirectoryFromCrowdConsole() {
        this.intendToModifyData();
        this.log("Running: testRemoveLastDirectoryFromCrowdConsole");
        this.gotoViewApplication("crowd");
        this.assertTextInElement("application-name", "crowd");
        this.clickLink("application-directories");
        this.clickLinkWithExactText("Remove");
        this.assertKeyPresent("preventlockout.unassigndirectory.label", Arrays.asList("Test Internal Directory"));
        this.assertTextInTable("directoriesTable", "Test Internal Directory");
    }

    public void testRemoveLastDirectoryFromDemoApp() {
        this.intendToModifyData();
        this.log("Running: testRemoveLastDirectoryFromDemoApp");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-directories");
        this.clickLinkWithExactText("Remove");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("directoriesTable", "Test Internal Directory");
    }
}

