/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class ViewApplicationDirectoriesTest
extends CrowdAcceptanceTestCase {
    private static final String MEMBERSHIP_AGGREGATION_CHECKBOX = "membershipAggregationEnabled";

    public void testUpdateMembershipAggregation() {
        this.intendToModifyData();
        this.restoreCrowdFromXML("directoryordering.xml");
        this.gotoViewApplicationDirectories("crowd");
        this.assertTextInElement("application-name", "crowd");
        this.clickButton("add-directory");
        this.checkCheckbox(MEMBERSHIP_AGGREGATION_CHECKBOX);
        this.submit();
        this.assertCheckboxSelected(MEMBERSHIP_AGGREGATION_CHECKBOX);
        this.uncheckCheckbox(MEMBERSHIP_AGGREGATION_CHECKBOX);
        this.submit();
        this.assertCheckboxNotSelected(MEMBERSHIP_AGGREGATION_CHECKBOX);
    }

    public void testCheckboxIsDisabledForOneDirectory() {
        this.intendToModifyData();
        this.restoreCrowdFromXML("directoryordering.xml");
        this.gotoViewApplicationDirectories("crowd");
        this.assertTextInElement("application-name", "crowd");
        this.assertCheckboxNotSelected(MEMBERSHIP_AGGREGATION_CHECKBOX);
        ViewApplicationDirectoriesTest.assertEquals((String)"disabled", (String)this.getElementById(MEMBERSHIP_AGGREGATION_CHECKBOX).getAttribute("disabled"));
        this.checkCheckbox(MEMBERSHIP_AGGREGATION_CHECKBOX);
        this.submit();
        this.assertCheckboxNotSelected(MEMBERSHIP_AGGREGATION_CHECKBOX);
    }

    public void testCheckboxIsEnabledForMultipleDirectories() {
        this.intendToModifyData();
        this.restoreCrowdFromXML("directoryordering.xml");
        this.gotoViewApplicationDirectories("crowd");
        this.assertTextInElement("application-name", "crowd");
        this.clickButton("add-directory");
        this.assertCheckboxPresent(MEMBERSHIP_AGGREGATION_CHECKBOX);
        this.assertCheckboxNotSelected(MEMBERSHIP_AGGREGATION_CHECKBOX);
        ViewApplicationDirectoriesTest.assertNull((Object)this.getElementById(MEMBERSHIP_AGGREGATION_CHECKBOX).getAttribute("disabled"));
        this.checkCheckbox(MEMBERSHIP_AGGREGATION_CHECKBOX);
        this.assertCheckboxSelected(MEMBERSHIP_AGGREGATION_CHECKBOX);
    }
}

