/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.BaseUrlFromProperties;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class SynchroniseCrowdDirectoryFullSubsetTest
extends CrowdAcceptanceTestCase {
    protected static final String LOCAL_DIRECTORY_NAME = "Loop";
    protected static final int LOCAL_DIRECTORY_ID = 32770;
    private static final String APPLICATION_NAME = "loop";
    private static final String CUSTOM_ATTR_NAME = "is-bad-person";
    private static final String CUSTOM_ATTR_VALUE = "yep";
    private static final String CQL_USER_FILTER = "is-bad-person IS NULL";
    private static final String HOST2_PATH = new BaseUrlFromProperties(specProperties).baseUrlFor("crowd2");
    private static final long MAX_SYNC_WAIT_TIME_MS = TimeUnit.MINUTES.toMillis(1L);
    private DbCachingTestHelper dbCachingTestHelper;
    private static final Pattern USERNAME_FROM_DETAILS = Pattern.compile("Username: (\\S+)\\sEmail address: .+", 8);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.dbCachingTestHelper = new DbCachingTestHelper(this.tester);
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("crowdwithcrowd.xml");
        this.intendToModifyData();
        this.setLocalDirectoryAttribute("com.atlassian.crowd.sync.user.filter.cql", CQL_USER_FILTER);
        this.disableIncrementalSync();
        this.switchToCrowdAt(HOST2_PATH);
        this.intendToModifyData();
        this.restoreCrowdFromXML("crowdwithcrowdremote.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        this.dbCachingTestHelper = null;
        super.tearDown();
    }

    public void testSynchroniseShouldSynchroniseOnlyUsersWhoMatchCQLFilter() {
        List<String> usersInLoopApp = this.getUsersInRemoteApplication();
        Assert.assertThat((String)"Should have an admin user", usersInLoopApp, (Matcher)Matchers.hasItems((Object[])new String[]{"admin"}));
        Assert.assertThat((String)"Should have at least one other user", usersInLoopApp, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1))));
        this.addAttributeToRemoteUser("admin", "Test Internal Directory", CUSTOM_ATTR_NAME, CUSTOM_ATTR_VALUE);
        this.synchroniseDirectory();
        List<String> usersInLoopDirectory = this.getUsersInLocalDirectory();
        Assert.assertThat((String)"admin user should not have been sync'd due to presence of attribute", usersInLoopDirectory, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"admin"})));
        ImmutableList expectedUsersInLoopDirectory = ImmutableList.copyOf((Iterable)Iterables.filter(usersInLoopApp, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"admin"))));
        SynchroniseCrowdDirectoryFullSubsetTest.assertEquals((String)"the users other than admin from the loop app should have been sync'd to the loop directory", (Object)expectedUsersInLoopDirectory, usersInLoopDirectory);
    }

    public void testModificationToMakeUserMatchCQLFilterShouldMakeUserBeAddedToLocalDirectory() {
        this.addAttributeToRemoteUser("admin", "Test Internal Directory", CUSTOM_ATTR_NAME, CUSTOM_ATTR_VALUE);
        this.synchroniseDirectory();
        Assert.assertThat((String)"user called admin should not be in loop directory after first sync due to presence of attribute", this.getUsersInLocalDirectory(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"admin")));
        this.removeAttributeFromRemoteUser("admin", "Test Internal Directory", CUSTOM_ATTR_NAME);
        this.synchroniseDirectory();
        Assert.assertThat((String)"user called admin should be in loop directory after second sync due to absense of attribute", this.getUsersInLocalDirectory(), (Matcher)Matchers.hasItem((Object)"admin"));
    }

    public void testModificationToMakeUserNotMatchCQLFilterShouldMakeUserBeDeletedFromLocalDirectory() {
        this.synchroniseDirectory();
        Assert.assertThat((String)"user called existinguser1 should be in loop directory after first sync due to absence of attribute", this.getUsersInLocalDirectory(), (Matcher)Matchers.hasItem((Object)"existinguser1"));
        this.addAttributeToRemoteUser("existinguser1", "Test Internal Directory", CUSTOM_ATTR_NAME, CUSTOM_ATTR_VALUE);
        this.synchroniseDirectory();
        Assert.assertThat((String)"user called existinguser1 should not be in loop directory after second sync due to presence of attribute", this.getUsersInLocalDirectory(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"existinguser1")));
    }

    private void switchToCrowdAt(String hostPath) {
        this.getTestContext().setBaseUrl(hostPath);
        this.log("Switching to URL: " + hostPath);
        this._loginAdminUser();
    }

    private void disableIncrementalSync() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(LOCAL_DIRECTORY_NAME);
        this.clickLink("crowd-connectiondetails");
        this.setWorkingForm("crowddetails");
        this.uncheckCheckbox("incrementalSyncEnabled");
        this.submit();
    }

    private void setLocalDirectoryAttribute(String attributeName, String attributeValue) {
        this.switchToCrowdAt(HOST_PATH);
        this.gotoPage("/console/secure/directory/updatecustomattributes.action?ID=32770");
        this.setTextField("attribute", attributeName);
        this.setTextField("value", attributeValue);
        this.clickButton("add-attribute");
        this.clickButtonWithText("Update");
    }

    private List<String> getUsersInRemoteApplication() {
        this.switchToCrowdAt(HOST2_PATH);
        this.gotoBrowseApplications();
        this.clickLinkWithExactText(APPLICATION_NAME);
        this.clickLink("application-users");
        this.clickButton("submit-search");
        return this.getUsernamesFromTable("user-details");
    }

    private void addAttributeToRemoteUser(String username, String directoryName, String attributeName, String attributeValue) {
        this.switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal(username, directoryName);
        this.clickLinkWithKey("menu.attributes.label");
        this.setTextField("attribute", attributeName);
        this.setTextField("value", attributeValue);
        this.clickButton("add-attribute");
        this.clickButtonWithText("Update");
    }

    private void removeAttributeFromRemoteUser(String username, String directoryName, String attributeName) {
        this.switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal(username, directoryName);
        this.clickLinkWithKey("menu.attributes.label");
        this.assertTextInTable("attributesTable", attributeName);
        this.clickLink("remove-" + attributeName);
    }

    private List<String> getUsersInLocalDirectory() {
        this.switchToCrowdAt(HOST_PATH);
        this.gotoBrowsePrincipals();
        this.selectOption("directoryID", LOCAL_DIRECTORY_NAME);
        this.clickButtonWithText("Search");
        return this.getUsernamesFromTable("user-details");
    }

    private void synchroniseDirectory() {
        this.switchToCrowdAt(HOST_PATH);
        SynchronisationMode syncModeUsed = this.dbCachingTestHelper.synchroniseDirectory(LOCAL_DIRECTORY_NAME, MAX_SYNC_WAIT_TIME_MS).getMode();
        SynchroniseCrowdDirectoryFullSubsetTest.assertEquals((Object)SynchronisationMode.FULL, (Object)syncModeUsed);
    }

    private List<String> getUsernamesFromTable(String tableId) {
        return this.scrapeTable(tableId, (List<String>)this.getTextForList("principal.actualname.label", "principal.info.label"), new Function<List<String>, String>(){

            public String apply(List<String> input) {
                String userDetails = input.get(1);
                java.util.regex.Matcher matcher = USERNAME_FROM_DETAILS.matcher(userDetails);
                if (matcher.matches()) {
                    return matcher.group(1);
                }
                throw new RuntimeException("Unexpected format of table's user details: '" + userDetails + "'");
            }
        });
    }
}

