/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.service.client.CrowdClient;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;

public class RemoteDirectoryNestedGroupTest
extends CrowdAcceptanceTestCase {
    private static final String NESTED_APPLICATION_NAME = "nested-crowd";
    private static final String NESTED_APPLICATION_PASSWORD = "nested-crowd";
    private static final String NESTED_DIRECTORY_NAME = "nested-remote-directory";
    private static final String NON_NESTED_APPLICATION_NAME = "non-nested-crowd";
    private static final String NON_NESTED_APPLICATION_PASSWORD = "non-nested-crowd";
    private static final String NON_NESTED_DIRECTORY_NAME = "non-nested-remote-directory";
    private CrowdClient crowdClientWithNestedGroup;
    private CrowdClient crowdClientWithNoNestedGroup;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        RestCrowdClientFactory clientFactory = new RestCrowdClientFactory();
        this.crowdClientWithNestedGroup = clientFactory.newInstance(HOST_PATH, "nested-crowd", "nested-crowd");
        this.crowdClientWithNoNestedGroup = clientFactory.newInstance(HOST_PATH, "non-nested-crowd", "non-nested-crowd");
        this.restoreCrowdFromXML("remotedirectorynestedgrouptest.xml");
        DbCachingTestHelper dbCachingTestHelper = new DbCachingTestHelper(this.tester);
        dbCachingTestHelper.synchroniseDirectory(NESTED_DIRECTORY_NAME, 60000L);
        dbCachingTestHelper.synchroniseDirectory(NON_NESTED_DIRECTORY_NAME, 60000L);
    }

    public void testNestedGroupMembershipListing() throws Exception {
        this.log("Running testNestedGroupMembershipListing");
        ImmutableSet expectedGroupNames = ImmutableSet.of((Object)"dir3childgroup", (Object)"dir3parentgroup");
        HashSet groupNames = Sets.newHashSet((Iterable)this.crowdClientWithNestedGroup.getNamesOfGroupsForNestedUser("nesteduser", 0, -1));
        RemoteDirectoryNestedGroupTest.assertEquals((Object)expectedGroupNames, (Object)groupNames);
    }

    public void testNonNestedGroupMembershipListing() throws Exception {
        this.log("Running testNonNestedGroupMembershipListing");
        ImmutableSet expectedGroupNames = ImmutableSet.of((Object)"dir3childgroup");
        HashSet groupNames = Sets.newHashSet((Iterable)this.crowdClientWithNoNestedGroup.getNamesOfGroupsForNestedUser("nesteduser", 0, -1));
        RemoteDirectoryNestedGroupTest.assertEquals((Object)expectedGroupNames, (Object)groupNames);
    }

    public void testNestedGroupMembership() throws Exception {
        this.log("Running testNestedGroupMembership");
        RemoteDirectoryNestedGroupTest.assertTrue((boolean)this.crowdClientWithNestedGroup.isUserNestedGroupMember("nesteduser", "dir3childgroup"));
        RemoteDirectoryNestedGroupTest.assertTrue((String)"transitivity expected", (boolean)this.crowdClientWithNestedGroup.isUserNestedGroupMember("nesteduser", "dir3parentgroup"));
    }

    public void testNonNestedGroupMembership() throws Exception {
        this.log("Running testNonNestedGroupMembership");
        RemoteDirectoryNestedGroupTest.assertTrue((boolean)this.crowdClientWithNoNestedGroup.isUserNestedGroupMember("nesteduser", "dir3childgroup"));
        RemoteDirectoryNestedGroupTest.assertFalse((String)"no transitivity expected here", (boolean)this.crowdClientWithNoNestedGroup.isUserNestedGroupMember("nesteduser", "dir3parentgroup"));
    }
}

