/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.sourceforge.jwebunit.html.Table;

public class CsvImporterTest
extends CrowdAcceptanceTestCase {
    private static final String UNKNOWN_FILE_LOCATION = "unknownfilelocation";
    private String userFileLocation = null;
    private String groupmembershipFileLocation = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this._loginAdminUser();
        this.restoreBaseSetup();
        this.gotoImporters();
        this.setRadioButton("importType", "CSV");
        this.submit();
        this.userFileLocation = this.getCsvFileLocation("users.csv");
        this.groupmembershipFileLocation = this.getCsvFileLocation("groupmembers.csv");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testCsvConfigurationWithBlankForm() {
        this.log("Running testCsvConfigurationWithBlankForm");
        this.setTextField("delimiter", "");
        this.submit();
        this.assertKeyPresent("dataimport.csv.delimiter.error");
        this.assertKeyPresent("dataimport.csv.userfile.error");
    }

    public void testCsvConfigurationWithInvalidFile() {
        this.log("Running testCsvConfigurationWithInvlidFile");
        this.setTextField("delimiter", ",");
        this.setTextField("users", UNKNOWN_FILE_LOCATION);
        this.setTextField("groupMemberships", UNKNOWN_FILE_LOCATION);
        this.submit();
        this.assertKeyPresent("dataimport.csv.fileinvalid.error", UNKNOWN_FILE_LOCATION);
        this.assertKeyPresent("dataimport.csv.fileinvalid.error", UNKNOWN_FILE_LOCATION);
    }

    public void testCsvImportWithUserFileOnly() {
        this.intendToModifyData();
        this.log("Running testCsvImportWithUserFileOnly");
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.text");
        this.selectOptionByValue("user.0", "user.username");
        this.selectOptionByValue("user.1", "user.firstname");
        this.selectOptionByValue("user.2", "user.lastname");
        this.selectOptionByValue("user.3", "user.emailaddress");
        this.selectOptionByValue("user.4", "user.password");
        this.assertKeyNotPresent("dataimport.csv.configuration.groupmapping.label");
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.confirmation.text");
        this.assertKeyPresent("dataimport.csv.configuration.passwordencrypted.label", this.getMessage("yes.label"));
        this.assertKeyPresent("dataimport.csv.configuration.userfile.label", this.userFileLocation);
        this.assertKeyNotPresent("dataimport.csv.configuration.groupmembershipfile.label");
        Object[][] userMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User Name", this.getMessage("user.username")}, {"First Name", this.getMessage("user.firstname")}, {"Last Name", this.getMessage("user.lastname")}, {"Email Address", this.getMessage("user.emailaddress")}, {"Password", this.getMessage("user.password")}};
        this.assertTableEquals("usermappings", new Table(userMappingsTableData));
        this.assertKeyNotPresent("dataimport.csv.configuration.groupmapping.label");
        this.assertTableNotPresent("groupmappings");
        this.submit();
        this.assertKeyPresent("dataimport.csv.result.text");
        this.assertTextInElement("users-imported", "2");
        this.assertTextInElement("groups-imported", "0");
        this.assertTextInElement("memberships-imported", "0");
        this.gotoBrowsePrincipals();
        this.assertMatchInTable("user-details", new String[]{"admin", "admin@example.com"});
        this.assertMatchInTable("user-details", new String[]{"JoeSmith", "jsmith@atlassian.com"});
        this.assertMatchInTable("user-details", new String[]{"peterblogs", "pblogs@atlassian.com"});
    }

    public void testCsvImportMappingsWithNoMappings() {
        this.log("Running testCsvImportMappingsWithNoMappings");
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.setTextField("groupMemberships", this.groupmembershipFileLocation);
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.text");
        this.submit();
        this.assertKeyPresent("dataimport.csvmapping.missing.user.mapping.error", this.getMessage("user.firstname"));
        this.assertKeyPresent("dataimport.csvmapping.missing.user.mapping.error", this.getMessage("user.lastname"));
        this.assertKeyPresent("dataimport.csvmapping.missing.user.mapping.error", this.getMessage("user.emailaddress"));
        this.assertKeyPresent("dataimport.csvmapping.missing.user.mapping.error", this.getMessage("user.username"));
        this.assertKeyPresent("dataimport.csvmapping.missing.group.mapping.error", this.getMessage("group.name"));
        this.assertKeyPresent("dataimport.csvmapping.missing.group.mapping.error", this.getMessage("group.username"));
    }

    public void testCsvImportMappings() {
        this.intendToModifyData();
        this.log("Running testCsvImportMappings");
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.setTextField("groupMemberships", this.groupmembershipFileLocation);
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.text");
        this.selectOptionByValue("user.0", "user.username");
        this.selectOptionByValue("user.1", "user.firstname");
        this.selectOptionByValue("user.2", "user.lastname");
        this.selectOptionByValue("user.3", "user.emailaddress");
        this.selectOptionByValue("user.4", "user.password");
        this.selectOptionByValue("group.0", "group.username");
        this.selectOptionByValue("group.1", "group.name");
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.confirmation.text");
        this.assertKeyPresent("dataimport.csv.configuration.passwordencrypted.label", this.getMessage("yes.label"));
        this.assertKeyPresent("dataimport.csv.configuration.userfile.label", this.userFileLocation);
        this.assertKeyPresent("dataimport.csv.configuration.groupmembershipfile.label", this.groupmembershipFileLocation);
        Object[][] userMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User Name", this.getMessage("user.username")}, {"First Name", this.getMessage("user.firstname")}, {"Last Name", this.getMessage("user.lastname")}, {"Email Address", this.getMessage("user.emailaddress")}, {"Password", this.getMessage("user.password")}};
        this.assertTableEquals("usermappings", new Table(userMappingsTableData));
        Object[][] groupMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User", this.getMessage("group.username")}, {"Group", this.getMessage("group.name")}};
        this.assertTableEquals("groupmappings", new Table(groupMappingsTableData));
        this.submit();
        this.assertKeyPresent("dataimport.csv.result.text");
        this.assertTextInElement("users-imported", "2");
        this.assertTextInElement("groups-imported", "0");
        this.assertTextInElement("memberships-imported", "2");
        this.gotoBrowsePrincipals();
        this.assertMatchInTable("user-details", new String[]{"admin", "admin@example.com"});
        this.assertMatchInTable("user-details", new String[]{"JoeSmith", "jsmith@atlassian.com"});
        this.assertMatchInTable("user-details", new String[]{"peterblogs", "pblogs@atlassian.com"});
    }

    public void testCsvImportExistingUsersAndGroupMappings() throws IOException {
        this.intendToModifyData();
        this.log("Running testCsvImportExistingUsersAndGroupMappings");
        this.userFileLocation = this.getCsvFileLocation("userswithexisting.csv");
        this.groupmembershipFileLocation = this.getCsvFileLocation("groupmemberswithexisting.csv");
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.setTextField("groupMemberships", this.groupmembershipFileLocation);
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.text");
        this.selectOptionByValue("user.0", "user.username");
        this.selectOptionByValue("user.1", "user.firstname");
        this.selectOptionByValue("user.2", "user.lastname");
        this.selectOptionByValue("user.3", "user.emailaddress");
        this.selectOptionByValue("user.4", "user.password");
        this.selectOptionByValue("group.0", "group.username");
        this.selectOptionByValue("group.1", "group.name");
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.confirmation.text");
        this.assertKeyPresent("dataimport.csv.configuration.passwordencrypted.label", this.getMessage("yes.label"));
        this.assertKeyPresent("dataimport.csv.configuration.userfile.label", this.userFileLocation);
        this.assertKeyPresent("dataimport.csv.configuration.groupmembershipfile.label", this.groupmembershipFileLocation);
        Object[][] userMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User Name", this.getMessage("user.username")}, {"First Name", this.getMessage("user.firstname")}, {"Last Name", this.getMessage("user.lastname")}, {"Email Address", this.getMessage("user.emailaddress")}, {"Password", this.getMessage("user.password")}};
        this.assertTableEquals("usermappings", new Table(userMappingsTableData));
        Object[][] groupMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User", this.getMessage("group.username")}, {"Group", this.getMessage("group.name")}};
        this.assertTableEquals("groupmappings", new Table(groupMappingsTableData));
        this.submit();
        this.assertKeyPresent("dataimport.csv.result.text");
        this.assertTextInElement("users-imported", "2");
        this.assertTextInElement("groups-imported", "1");
        this.assertTextInElement("memberships-imported", "2");
        this.gotoBrowsePrincipals();
        this.assertUserInTable("admin", "Super User", "admin@example.com");
        this.assertUserInTable("JoeSmith", "Joe Smith", "jsmith@atlassian.com");
        this.assertUserInTable("peterblogs", "Peter Blogs", "pblogs@atlassian.com");
        this.gotoBrowseGroups();
        this.assertTextInTable("group-details", new String[]{"crowd-administrators", "true"});
        this.assertTextInTable("group-details", new String[]{"crowd-users", "true"});
        this.gotoViewGroup("crowd-users", "Test Internal Directory");
        this.clickLink("view-group-users");
        this.assertTextInTable("view-group-users", new String[]{"JoeSmith", "jsmith@atlassian.com", "true"});
        this.assertTextInTable("view-group-users", new String[]{"peterblogs", "pblogs@atlassian.com", "true"});
    }

    public void testCsvImportWithPipes() throws IOException {
        this.intendToModifyData();
        this.log("Running testCsvImportWithPipes");
        this.userFileLocation = this.getCsvFileLocation("userspipes.csv");
        this.groupmembershipFileLocation = this.getCsvFileLocation("groupmemberspipes.csv");
        this.setTextField("delimiter", "|");
        this.setTextField("users", this.userFileLocation);
        this.setTextField("groupMemberships", this.groupmembershipFileLocation);
        this.submit();
        this.validateSampleTableData();
    }

    private void validateSampleTableData() {
        this.assertKeyPresent("dataimport.csv.configuration.text");
        Object[][] principalMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.sampledata"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User Name", "peterblogs", this.getMessage("user.none")}, {"First Name", "Peter", this.getMessage("user.none")}, {"Last Name", "Blogs", this.getMessage("user.none")}, {"Email Address", "pblogs@atlassian.com", this.getMessage("user.none")}, {"Password", "secret", this.getMessage("user.none")}};
        this.assertTableEquals("principalsample", new Table(principalMappingsTableData));
        Object[][] groupMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.sampledata"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User", "peterblogs", this.getMessage("group.none")}, {"Group", "crowd-administrators", this.getMessage("group.none")}};
        this.assertTableEquals("groupsample", new Table(groupMappingsTableData));
    }

    public void testCsvImportWithComma() throws IOException {
        this.intendToModifyData();
        this.log("Running testCsvImportWithComma");
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.setTextField("groupMemberships", this.groupmembershipFileLocation);
        this.submit();
        this.validateSampleTableData();
    }

    public void testCsvImportInvalidDelimeter() throws IOException {
        this.log("Running testCsvImportInvalidDelimeter");
        this.userFileLocation = this.getCsvFileLocation("userspipes.csv");
        this.groupmembershipFileLocation = this.getCsvFileLocation("groupmemberspipes.csv");
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.setTextField("groupMemberships", this.groupmembershipFileLocation);
        this.submit();
        this.assertKeyPresent("dataimport.csv.delimiter.invalid.error", ",");
    }

    private String getCsvFileLocation(String fileName) throws IOException {
        File fileLocation = AcceptanceTestHelper.getResource("com/atlassian/crowd/acceptance/tests/applications/crowd/" + fileName);
        if (!fileLocation.exists()) {
            URL resource = ((Object)((Object)this)).getClass().getResource("/com/atlassian/crowd/acceptance/tests/applications/crowd/" + fileName);
            fileLocation = new File(resource.getFile());
        }
        if (!fileLocation.exists()) {
            throw new IllegalArgumentException("File: " + fileName + " does not exist in the resources directory, under the 'com/atlassian/crowd/acceptance/tests/console/' directory");
        }
        return fileLocation.getCanonicalPath();
    }
}

