/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import javax.mail.internet.MimeMessage;

public abstract class CrowdAcceptanceTestCaseWithEmailServer
extends CrowdAcceptanceTestCase {
    private static final String SMTP_FROM_ADDRESS = "crowd-tests@example.com";
    private static final String SMTP_SUBJECT_PREFIX = "[crowd-tests]";
    private GreenMail greenMail;
    private String smtpPort;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.smtpPort = System.getProperty("crowd.test.smtp.port", "3025");
        ServerSetup smtpServer = new ServerSetup(Integer.parseInt(this.smtpPort), null, "smtp");
        this.greenMail = new GreenMail(smtpServer);
        this.greenMail.start();
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.greenMail) {
            this.greenMail.stop();
        }
        super.tearDown();
    }

    protected void _configureMailServer() {
        this.gotoMailServer();
        this.setTextField("notificationEmail", SMTP_FROM_ADDRESS);
        this.setTextField("from", SMTP_FROM_ADDRESS);
        this.setTextField("prefix", SMTP_SUBJECT_PREFIX);
        this.setTextField("host", "localhost");
        this.setTextField("port", this.smtpPort);
        this.submit();
    }

    public String getEmailAddress() {
        return SMTP_FROM_ADDRESS;
    }

    protected MimeMessage waitForExactlyOneMessage() throws InterruptedException {
        CrowdAcceptanceTestCaseWithEmailServer.assertTrue((String)"A reset password email should have arrived", (boolean)this.greenMail.waitForIncomingEmail(5000L, 1));
        MimeMessage[] messages = this.greenMail.getReceivedMessages();
        CrowdAcceptanceTestCaseWithEmailServer.assertEquals((String)"Incorrect number of emails present", (int)1, (int)messages.length);
        return messages[0];
    }
}

