/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.google.common.base.Splitter;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class BrowseGroupsTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("searchdirectories.xml");
    }

    public void testNoDirectoryIsSelectedByDefault() {
        this.log("Running testNoDirectoryIsSelectedByDefault");
        this.gotoBrowseGroups();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
    }

    public void testDirectorySelectionIsSaved() {
        this.log("Running testDirectorySelectionIsSaved");
        this.gotoBrowseGroups();
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoBrowseGroups();
        this.assertSelectedOptionEquals("directoryID", "Second Directory");
    }

    public void testNonExistingDirectorySelection() {
        this.log("Running testNonExistingDirectorySelection");
        this.intendToModifyData();
        this.gotoBrowseGroups();
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoBrowseGroups();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
        this.assertWarningAndErrorNotPresent();
    }

    public void testOnlyDirectoryIsSelected() {
        this.log("Running testOnlyDirectoryIsSelected");
        this.intendToModifyData();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Apache DS 1.5.4");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoBrowseGroups();
        this.assertSelectedOptionEquals("directoryID", "Test Internal Directory");
    }

    public void testBrowseGroupsSearchIncludesMinimalParametersInRequestUrl() {
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", "Test Internal Directory");
        this.setTextField("name", "yyy");
        this.selectOption("active", "Active");
        this.selectOption("resultsPerPage", "50");
        this.submit();
        URL url = this.getTestingEngine().getPageURL();
        Assert.assertThat((Object)Splitter.on((String)"&").split((CharSequence)url.getQuery()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"name=yyy", "directoryID=3", "active=true", "resultsPerPage=50"}));
    }
}

