/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;

public class BrowseDirectoriesTest
extends CrowdAcceptanceTestCase {
    public static final String DIRECTORY_TABLE_ID = "directory-table";
    public static final ImmutableList<String> DIRECTORY_TABLE_HEADERS = ImmutableList.of((Object)"Name", (Object)"Active", (Object)"Type", (Object)"Action");
    public static final Function<List<String>, String> MAP_DIRECTORY_NAME = new Function<List<String>, String>(){

        public String apply(@Nullable List<String> input) {
            return input.get(0);
        }
    };

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("viewdirectory.xml");
    }

    public void testBrowseAllDirectories() {
        this.log("Running: testBrowseAllDirectories");
        this.gotoBrowseDirectories();
        List<String> directories = this.scrapeTable(DIRECTORY_TABLE_ID, (List<String>)DIRECTORY_TABLE_HEADERS, MAP_DIRECTORY_NAME);
        Assert.assertThat(directories, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ActiveDirectory", "ApacheDS Caching Directory", "ApacheDS Delegated Directory", "ApacheDS Directory", "Custom Directory", "Generic Delegated Directory", "GenericLDAP Directory", "Remote Crowd Directory", "Second Directory", "Test Internal Directory"}));
    }

    public void testFilterDirectoriesByName() {
        this.log("Running: testFilterDirectoriesByName");
        this.gotoBrowseDirectories();
        this.setTextField("name", "Delegated");
        this.submit();
        List<String> directories = this.scrapeTable(DIRECTORY_TABLE_ID, (List<String>)DIRECTORY_TABLE_HEADERS, MAP_DIRECTORY_NAME);
        Assert.assertThat(directories, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ApacheDS Delegated Directory", "Generic Delegated Directory"}));
    }
}

