/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.acceptance.tests.applications.crowd.UserMembershipEventMatcher;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.event.Events;
import com.atlassian.crowd.integration.rest.service.RestCrowdClient;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class AutoGroupAdderTest
extends CrowdAcceptanceTestCase {
    private static final String CROWD_DIRECTORY_NAME = "remotecrowd";
    private static final long MAX_WAIT_TIME_MS = 10000L;
    private static final String APPLICATION_NAME = "crowd";
    private static final String APPLICATION_PASSWORD = "OJHhmMvi";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("autogroupaddertest.xml");
    }

    private static void restoreLdif() throws IOException {
        InputStream in = AutoGroupAdderTest.class.getResourceAsStream("AutoGroupAdderTest-entries.ldif");
        AutoGroupAdderTest.assertNotNull((Object)in);
        new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).setLdif(in);
    }

    public void testAutoAddWithInternalDirectory() {
        this.intendToModifyData();
        this.log("Running testAutoAddWithInternalDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Crowd Local");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
    }

    public void testAutoAddWithDelegatedDirectory() throws IOException {
        this.intendToModifyData();
        this.log("Running testAutoAddWithDelegatedDirectory");
        AutoGroupAdderTest.restoreLdif();
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("delg");
        this.clickLink("delegated-options");
        this.assertTextPresent("test1");
        this.gotoAddPrincipal();
        this.setTextField("email", "jdoe@testingarea.org");
        this.setTextField("name", "jdoe");
        this.setTextField("password", "jdoe");
        this.setTextField("passwordConfirm", "jdoe");
        this.setTextField("firstname", "John");
        this.setTextField("lastname", "Doe");
        this.selectOption("directoryID", "delg");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("jdoe");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this.increaseDirectoryPriorityTo(APPLICATION_NAME, "delg", 2);
        this._loginAsUser("jdoe", "jdoe");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("test1");
    }

    public void testAutoAddWithLDAPDirectory() throws IOException {
        this.intendToModifyData();
        this.log("Running testAutoAddWithLDAPDirectory");
        AutoGroupAdderTest.restoreLdif();
        DbCachingTestHelper.synchroniseDirectory(this.tester, "ldap", 10000L);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("ldap");
        this.clickLink("connector-options");
        this.assertTextPresent("groupA");
        this.assertTextPresent("groupB");
        this.assertTextPresent("groupC");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "ldap");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this.increaseDirectoryPriorityTo(APPLICATION_NAME, "ldap", 2);
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("groupA");
        this.assertTextPresent("groupB");
        this.assertTextPresent("groupC");
        this._loginAdminUser();
        this.gotoViewPrincipal("testuser", "ldap");
        this.clickLink("remove-principal");
        this.submit();
        this.assertTextNotPresent("testuser");
    }

    public void testAutoAddWithRemoteCrowdDirectory() {
        this.intendToModifyData();
        this.log("Running testAutoAddWithRemoteCrowdDirectory");
        this.updateRemoteCrowdUrl(CROWD_DIRECTORY_NAME);
        DbCachingTestHelper.synchroniseDirectory(this.tester, CROWD_DIRECTORY_NAME, 10000L);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-options");
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", CROWD_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this.increaseDirectoryPriorityTo(APPLICATION_NAME, CROWD_DIRECTORY_NAME, 1);
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this._loginAdminUser();
        this.gotoViewPrincipal("testuser", CROWD_DIRECTORY_NAME);
        this.clickLink("remove-principal");
        this.submit();
        this.assertTextNotPresent("testuser");
    }

    public void testAutoAddWithRemoteCrowdDirectoryUsingDelegatedDirectory() throws IOException {
        this.intendToModifyData();
        this.log("Running testAutoAddWithRemoteCrowdDirectoryUsingDelegatedDirectory");
        AutoGroupAdderTest.restoreLdif();
        this.updateRemoteCrowdUrl("Remote Crowd Directory - Delegated");
        DbCachingTestHelper.synchroniseDirectory(this.tester, "Remote Crowd Directory - Delegated", 10000L);
        this.increaseDirectoryPriorityTo(APPLICATION_NAME, "Remote Crowd Directory - Delegated", 2);
        this._loginAsUser("jdoe", "jdoe");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("test1");
    }

    public void testAutoAddWithRemoteCrowdDirectoryUsingDelegatedDirectory_NoGroup() throws IOException {
        this.intendToModifyData();
        this.log("Running testAutoAddWithRemoteCrowdDirectoryUsingDelegatedDirectory_NoGroup");
        AutoGroupAdderTest.restoreLdif();
        this.updateRemoteCrowdUrl("Remote Crowd Directory - Delegated");
        this.increaseDirectoryPriorityTo(APPLICATION_NAME, "Remote Crowd Directory - Delegated", 2);
        this._loginAsUser("jdoe", "jdoe");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent("test1");
    }

    public void testAutoAddOnlyAddingGroupsOnce() throws Exception {
        this.intendToModifyData();
        this.log("Running testAutoAddOnlyAddingGroupsOnce");
        this.setScriptingEnabled(true);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.clickLinkWithText("remove", 2);
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextNotPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Crowd Local");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextNotPresent("group3");
        this._loginAdminUser();
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.clickButton("addGroups");
        this.waitForText(this.getText("picker.addgroups.generic.message"));
        this.setTextField("searchString", "group3");
        this.submit("searchButton");
        this.waitForText("Description");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this.assertTextPresent("group3");
        this.assertLinkPresentWithKey("directory.options.autogroupadd.remove.label");
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextNotPresent("group3");
        this.setScriptingEnabled(false);
    }

    private void increaseDirectoryPriorityTo(String application, String directoryName, int order) {
        this.gotoViewApplication(application);
        this.clickLink("application-directories");
        this.assertTextInTable("directoriesTable", directoryName);
        while (!this.tester.getTestingEngine().hasElementByXPath("id('directoriesTable')/tbody/tr[" + order + "][contains(.,'" + directoryName + "')]")) {
            this.clickElementByXPath("id('directoriesTable')/tbody/tr[contains(.,'" + directoryName + "')]/td/a[starts-with(@id, 'up-')]");
        }
    }

    private void updateRemoteCrowdUrl(String directoryName) {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(directoryName);
        this.assertKeyPresent("menu.viewdirectory.label", directoryName);
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl());
        this.submit();
    }

    public void testAutoAddWithInternalDirectoryIsTriggeredBySessionCreationWithoutPassword() throws Exception {
        this.intendToModifyData();
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Crowd Local");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext("testuser", null, new ValidationFactor[0], APPLICATION_NAME);
        this.createCrowdClient().authenticateSSOUserWithoutValidatingPassword(userAuthenticationContext);
        this.gotoViewPrincipal("testuser", "Crowd Local");
        this.clickLink("user-groups-tab");
        Assert.assertThat(AutoGroupAdderTest.namesOf(this.getGroupTableContents()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"group1", "group2", "group3"}));
    }

    public void testAutoAddGroupMembershipsAreSynchronizedAfterLogin() throws Exception {
        this.intendToModifyData();
        this.log("Running testAutoAddGroupMembershipsAreSynchronizedAfterLogin");
        CrowdClient crowdClient = this.createCrowdClient();
        String eventToken = crowdClient.getCurrentEventToken();
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Crowd Local");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        Events eventsAfterUserCreation = crowdClient.getNewEvents(eventToken);
        this._loginAsUser("testuser", "password");
        Events eventsAfterUserFirstLogin = crowdClient.getNewEvents(eventsAfterUserCreation.getNewEventToken());
        Assert.assertThat((Object)eventsAfterUserFirstLogin.getEvents(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{UserMembershipEventMatcher.userMembershipCreated("testuser", "group1"), UserMembershipEventMatcher.userMembershipCreated("testuser", "group2"), UserMembershipEventMatcher.userMembershipCreated("testuser", "group3")}));
    }

    public CrowdClient createCrowdClient() {
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH);
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", APPLICATION_PASSWORD);
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        return new RestCrowdClient((ClientProperties)clientProperties);
    }
}

