/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

abstract class AppImporterTestBase
extends CrowdAcceptanceTestCase {
    private String jdbcURL;

    AppImporterTestBase() {
    }

    abstract String getHsqlFileName();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
        String dbLocation = null;
        File fileSystemResource = AcceptanceTestHelper.getResource(this.getHsqlFileName() + ".properties");
        if (!fileSystemResource.exists()) {
            URL resource = ((Object)((Object)this)).getClass().getResource("/" + this.getHsqlFileName() + ".properties");
            dbLocation = StringUtils.removeEnd((String)resource.toExternalForm(), (String)".properties");
        } else {
            dbLocation = StringUtils.removeEnd((String)fileSystemResource.getCanonicalPath(), (String)".properties");
        }
        this.jdbcURL = "jdbc:hsqldb:" + dbLocation;
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    protected void runImportTest(String appName, int expectedUserCount, int expectedGroupCount, int expectedMembershipCount) {
        this.intendToModifyData();
        this.gotoImporters();
        this.setRadioButton("importType", "ATLASSIAN");
        this.submit();
        this.assertKeyPresent("dataimport.importatlassian.title");
        this.selectOption("configurationApplication", appName);
        this.selectOption("configurationDirectoryID", "Test Internal Directory");
        this.setTextField("configurationDatabaseURL", this.jdbcURL);
        this.setTextField("configurationDatabaseDriver", "org.hsqldb.jdbcDriver");
        this.setTextField("configurationUsername", "sa");
        this.checkCheckbox("configurationImportPasswords", "true");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        this.assertTextInElement("users-imported", Integer.toString(expectedUserCount));
        this.assertTextInElement("groups-imported", Integer.toString(expectedGroupCount));
        this.assertTextInElement("memberships-imported", Integer.toString(expectedMembershipCount));
    }
}

