/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class AddPrincipalTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("searchdirectories.xml");
    }

    public void testAddPrincipalWithNoDetails() {
        this.log("Running testAddPrincipalWithNoDetails");
        this.gotoAddPrincipal();
        this.setTextField("email", "");
        this.setTextField("name", "");
        this.setTextField("password", "");
        this.setTextField("passwordConfirm", "");
        this.setTextField("firstname", "");
        this.setTextField("lastname", "");
        this.selectOptionByValue("directoryID", "-1");
        this.submit();
        this.assertKeyPresent("principal.name.invalid");
        this.assertKeyPresent("principal.password.invalid");
        this.assertKeyPresent("principal.email.invalid");
        this.assertKeyPresent("principal.firstname.invalid");
        this.assertKeyPresent("principal.lastname.invalid");
        this.assertKeyPresent("principal.directory.invalid");
    }

    public void testInvalidEmailAddress() {
        this.log("Running testInvalidEmailAddress");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuserATtest.com");
        this.submit();
        this.assertKeyPresent("principal.email.invalid");
    }

    public void testPasswordsMatchError() {
        this.log("Running testPasswordsMatchError");
        this.gotoAddPrincipal();
        this.setTextField("password", "password1");
        this.setTextField("passwordConfirm", "password2");
        this.submit();
        this.assertKeyPresent("principal.passwordconfirm.nomatch");
    }

    public void testUserAlreadyExistsError() {
        this.log("Running testUserAlreadyExistsError");
        this.gotoAddPrincipal();
        this.setTextField("email", "admin@atlassian.com");
        this.setTextField("name", "admin");
        this.setTextField("password", "admin");
        this.setTextField("passwordConfirm", "admin");
        this.setTextField("firstname", "Super");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("invalid.namealreadyexist.user");
    }

    public void testUserWithTrailingWhitespaceFailsWithSpecificError() {
        this.gotoAddPrincipal();
        this.setTextField("email", "admin@atlassian.com");
        this.setTextField("name", "admin ");
        this.setTextField("password", "admin");
        this.setTextField("passwordConfirm", "admin");
        this.setTextField("firstname", "Super");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("invalid.whitespace");
    }

    public void testEmailAddressWithTrailingSpacesFailsWithSpecificError() {
        this.log("Running testEmailAddressWithTrailingSpacesFailsWithSpecificError");
        this.gotoAddPrincipal();
        this.setTextField("email", " john@example.test ");
        this.submit();
        this.assertKeyPresent("principal.email.whitespace");
    }

    public void testAddPrincipalToInternalDirectory() {
        this.intendToModifyData();
        this.log("Running testAddPrincipalToInternalDirectory");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
    }

    public void testPasswordDoesNotMatchInternalDirectoryComplexityRequirements() {
        this.intendToModifyData();
        this.log("Running testPasswordDoesNotMatchInternalDirectoryRequirements");
        this.updateDirectoryWithPasswordRegex("Test Internal Directory", "[a-z]", "Passwords <b>must</b> contain at least one lowercase character");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "ALL-UPPERCASE-PASSWORD");
        this.setTextField("passwordConfirm", "ALL-UPPERCASE-PASSWORD");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertTextPresent("Passwords <b>must</b> contain at least one lowercase character");
    }

    public void testAddModifyRemoveLDAPPrincipal() {
        this.intendToModifyData();
        this.intendToModifyLdapData();
        this.log("Running testAddModifyRemoveLDAPPrincipal");
        this.gotoAddPrincipal();
        String username = "testuser-LDAP";
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", username);
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Apache DS 1.5.4");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent(username);
        this.assertTextFieldEquals("email", "testuser@atlassian.com");
        this.assertTextFieldEquals("firstname", "Test");
        this.assertTextFieldEquals("lastname", "User");
        this.assertCheckboxSelected("active");
        this.setTextField("email", "changed@example.com");
        this.setTextField("firstname", "Changed");
        this.setTextField("lastname", "Changed Too");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextPresent(username);
        this.assertTextFieldEquals("email", "changed@example.com");
        this.assertTextFieldEquals("firstname", "Changed");
        this.assertTextFieldEquals("lastname", "Changed Too");
        this.clickLink("remove-principal");
        this.submit();
        this.assertTextNotPresent(username);
    }

    public void testAddPrincipalToInternalDirectoryWithMixedName() {
        this.intendToModifyData();
        this.log("Running testAddPrincipalToInternalDirectoryWithInvalidName");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "TestUser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("TestUser");
    }

    public void testKeyPresentOnce() {
        this.log("Running testKeyPresentOnce");
        this.gotoAddPrincipal();
        this.selectOptionByValue("directoryID", "-1");
        this.submit();
        this.assertKeyPresentOnce("principal.name.invalid");
        this.assertKeyPresentOnce("principal.password.invalid");
        this.assertKeyPresentOnce("principal.email.invalid");
        this.assertKeyPresentOnce("principal.firstname.invalid");
        this.assertKeyPresentOnce("principal.lastname.invalid");
        this.assertKeyPresentOnce("principal.directory.invalid");
    }

    public void testNoDirectoryIsSelectedByDefault() {
        this.gotoAddPrincipal();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
    }

    public void testDirectorySelectionIsSaved() {
        this.intendToModifyData();
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoAddPrincipal();
        this.assertSelectedOptionEquals("directoryID", "Second Directory");
        this.assertSelectOptionNotPresent("directoryID", this.getText("selectdirectory.label"));
    }

    public void testNonExistingDirectorySelection() {
        this.intendToModifyData();
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoAddPrincipal();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
        this.assertWarningAndErrorNotPresent();
    }

    public void testOnlyDirectoryIsSelected() {
        this.intendToModifyData();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Apache DS 1.5.4");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoAddPrincipal();
        this.assertSelectedOptionEquals("directoryID", "Test Internal Directory");
    }

    private void updateDirectoryWithPasswordRegex(String directoryName, String passwordRegex, String passwordComplexityMessage) {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(directoryName);
        this.clickLink("internal-configuration");
        this.setTextField("passwordRegex", passwordRegex);
        this.setTextField("passwordComplexityMessage", passwordComplexityMessage);
        this.submit();
        this.assertTextFieldEquals("passwordComplexityMessage", passwordComplexityMessage);
    }
}

