/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.administration;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BackupTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("remotecrowddirectory.xml");
    }

    public void testExportBackup() {
        this.gotoAdministrationPage();
        this.clickLink("backup-admin");
        this.submit("manualBackup");
        this.assertWarningAndErrorNotPresent();
        this.assertSuccessPresent();
        String message = this.getElementTextByXPath("//div[@class='aui-message success']");
        Pattern pattern = Pattern.compile("Crowd has successfully backed up to (.+\\.xml)\\. Time taken");
        Matcher matcher = pattern.matcher(message);
        BackupTest.assertTrue((String)"Message should match regex", (boolean)matcher.find());
        String filename = matcher.group(1);
        File xmlBackupFile = new File(filename);
        BackupTest.assertTrue((String)("XML backup file " + xmlBackupFile + " should exist"), (boolean)xmlBackupFile.exists());
        File directoriesPropertiesFile = new File(xmlBackupFile.getParentFile(), "directories.properties");
        BackupTest.assertTrue((String)("File " + directoriesPropertiesFile + " should exist"), (boolean)directoriesPropertiesFile.exists());
    }
}

