/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.jdbc.JdbcTestUtils;

public abstract class DirectoryTestHelper {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryTestHelper.class);
    public static final String[] TABLE_NAMES = new String[]{"cwd_membership", "cwd_user", "cwd_group", "cwd_directory_attribute", "cwd_directory_operation", "cwd_directory"};
    private static final String APACHEDS102_CONFIG_FILE = "localhost-apacheDS102.properties";
    private static final String APACHEDS154_CONFIG_FILE = "localhost-apacheDS154.properties";
    private static final String AD2K3_CONFIG_FILE = System.getProperty("tpm.ad2k3.filename", "crowd-ad1.properties");
    private static final String AD2K3_LOAD_TEST_10K_FILE = System.getProperty("tpm.ad2k3.filename", "crowd-ad1-loadtest10k.properties");

    public static String getApacheDS102ConfigFileName() {
        return APACHEDS102_CONFIG_FILE;
    }

    public static String getApacheDS154ConfigFileName() {
        return APACHEDS154_CONFIG_FILE;
    }

    public static String getAD2K3ConfigFileName() {
        return AD2K3_CONFIG_FILE;
    }

    public static String getAD2K3LoadTest10KFileName() {
        return AD2K3_LOAD_TEST_10K_FILE;
    }

    public static Properties getConfigProperties(String configFileName) {
        return AcceptanceTestHelper.loadProperties(configFileName);
    }

    public static DirectoryImpl createDirectoryTemplate(Properties directorySettings, LDAPPropertiesHelper ldapPropertiesHelper, boolean useExternalId) {
        String rolesDisabled;
        String pagedResultsSize;
        InternalEntityTemplate template = new InternalEntityTemplate(null, "Floating Directory", true, new Date(), new Date());
        DirectoryImpl directoryTemplate = new DirectoryImpl(template);
        directoryTemplate.setActive(true);
        directoryTemplate.setDescription("");
        directoryTemplate.setName(BaseTest.class.getName());
        directoryTemplate.setType(DirectoryType.CONNECTOR);
        String className = directorySettings.getProperty("test.directory.classname");
        directoryTemplate.setImplementationClass(className);
        directoryTemplate.setAttribute("ldap.url", directorySettings.getProperty("test.directory.url"));
        directoryTemplate.setAttribute("ldap.secure", directorySettings.getProperty("test.directory.secure"));
        directoryTemplate.setAttribute("ldap.referral", directorySettings.getProperty("test.directory.referral"));
        directoryTemplate.setAttribute("ldap.pagedresults", directorySettings.getProperty("test.directory.pagedresults.use"));
        String pooling = directorySettings.getProperty("test.directory.connectionpooling");
        if (pooling != null) {
            directoryTemplate.setAttribute("ldap.pooling", pooling);
        }
        if ((pagedResultsSize = directorySettings.getProperty("test.directory.pagedresults.size")) == null) {
            pagedResultsSize = new Integer(999).toString();
        }
        directoryTemplate.setAttribute("ldap.pagedresults.size", pagedResultsSize);
        directoryTemplate.setAttribute("ldap.basedn", directorySettings.getProperty("test.directory.basedn"));
        directoryTemplate.setAttribute("ldap.userdn", directorySettings.getProperty("test.directory.userdn"));
        directoryTemplate.setAttribute("ldap.password", directorySettings.getProperty("test.directory.password"));
        directoryTemplate.setAttribute("ldap.nestedgroups.disabled", directorySettings.getProperty("test.directory.nested.groups.disabled"));
        String encryption = directorySettings.getProperty("test.directory.encryption");
        if (encryption != null) {
            directoryTemplate.setAttribute("ldap.user.encryption", encryption);
        }
        if ((rolesDisabled = directorySettings.getProperty("ldap.roles.disabled")) != null) {
            directoryTemplate.setAttribute("ldap.roles.disabled", rolesDisabled);
        }
        Properties directorySchema = (Properties)ldapPropertiesHelper.getConfigurationDetails().get(className);
        directoryTemplate.setAttribute("ldap.group.description", (String)directorySchema.get("ldap.group.description"));
        directoryTemplate.setAttribute("ldap.group.name", (String)directorySchema.get("ldap.group.name"));
        directoryTemplate.setAttribute("ldap.group.objectclass", (String)directorySchema.get("ldap.group.objectclass"));
        directoryTemplate.setAttribute("ldap.group.filter", (String)directorySchema.get("ldap.group.filter"));
        directoryTemplate.setAttribute("ldap.group.usernames", (String)directorySchema.get("ldap.group.usernames"));
        directoryTemplate.setAttribute("ldap.role.description", (String)directorySchema.get("ldap.role.description"));
        directoryTemplate.setAttribute("ldap.role.name", (String)directorySchema.get("ldap.role.name"));
        directoryTemplate.setAttribute("ldap.role.objectclass", (String)directorySchema.get("ldap.role.objectclass"));
        directoryTemplate.setAttribute("ldap.role.filter", (String)directorySchema.get("ldap.role.filter"));
        directoryTemplate.setAttribute("ldap.role.usernames", (String)directorySchema.get("ldap.role.usernames"));
        directoryTemplate.setAttribute("ldap.user.email", (String)directorySchema.get("ldap.user.email"));
        directoryTemplate.setAttribute("ldap.user.firstname", (String)directorySchema.get("ldap.user.firstname"));
        directoryTemplate.setAttribute("ldap.user.group", (String)directorySchema.get("ldap.user.group"));
        directoryTemplate.setAttribute("ldap.user.lastname", (String)directorySchema.get("ldap.user.lastname"));
        directoryTemplate.setAttribute("ldap.user.displayname", (String)directorySchema.get("ldap.user.displayname"));
        directoryTemplate.setAttribute("ldap.user.objectclass", (String)directorySchema.get("ldap.user.objectclass"));
        directoryTemplate.setAttribute("ldap.user.filter", (String)directorySchema.get("ldap.user.filter"));
        directoryTemplate.setAttribute("ldap.user.username", (String)directorySchema.get("ldap.user.username"));
        directoryTemplate.setAttribute("ldap.user.username.rdn", (String)directorySchema.get("ldap.user.username.rdn"));
        directoryTemplate.setAttribute("ldap.user.password", (String)directorySchema.get("ldap.user.password"));
        if (useExternalId) {
            directoryTemplate.setAttribute("ldap.external.id", (String)directorySchema.get("ldap.external.id"));
        }
        directoryTemplate.setAllowedOperations((Set)Sets.newHashSet((Object[])new OperationType[]{OperationType.CREATE_GROUP, OperationType.CREATE_USER, OperationType.CREATE_ROLE, OperationType.UPDATE_GROUP, OperationType.UPDATE_USER, OperationType.UPDATE_ROLE, OperationType.DELETE_GROUP, OperationType.DELETE_USER, OperationType.DELETE_ROLE}));
        return directoryTemplate;
    }

    public static String getEncryptionType(Properties directorySettings) {
        return directorySettings.getProperty("test.directory.encryption");
    }

    public static void silentlyRemoveUser(String userName, RemoteDirectory remoteDirectory) {
        try {
            remoteDirectory.removeUser(userName);
        }
        catch (UserNotFoundException e) {
            logger.debug("While removing user", (Throwable)e);
        }
        catch (CrowdException e) {
            logger.warn("While removing user", (Throwable)e);
        }
    }

    public static void silentlyRemoveGroup(String groupName, RemoteDirectory remoteDirectory) {
        try {
            remoteDirectory.removeGroup(groupName);
        }
        catch (GroupNotFoundException e) {
            logger.debug("While removing group", (Throwable)e);
        }
        catch (CrowdException e) {
            logger.warn("While removing group", (Throwable)e);
        }
    }

    public static void silentlyRemoveUserFromGroup(String userName, String groupName, RemoteDirectory remoteDirectory) {
        try {
            remoteDirectory.removeUserFromGroup(userName, groupName);
        }
        catch (MembershipNotFoundException e) {
            logger.debug("While removing user membership from group", (Throwable)e);
        }
        catch (CrowdException e) {
            logger.warn("While removing user membership from group", (Throwable)e);
        }
    }

    public static void silentlyRemoveGroupFromGroup(String childGroup, String parentGroup, RemoteDirectory remoteDirectory) {
        try {
            remoteDirectory.removeGroupFromGroup(childGroup, parentGroup);
        }
        catch (MembershipNotFoundException e) {
            logger.debug("While removing group membership from group", (Throwable)e);
        }
        catch (CrowdException e) {
            logger.warn("While removing group membership from group", (Throwable)e);
        }
    }

    public static void deleteFromTables(String[] names, JdbcTemplate jdbcTemplate) {
        for (String table : names) {
            int rowCount = JdbcTestUtils.deleteFromTables((JdbcTemplate)jdbcTemplate, (String[])new String[]{table});
            if (!logger.isInfoEnabled()) continue;
            logger.info("Deleted {} rows from table {}", (Object)rowCount, (Object)table);
        }
    }

    public static UserTemplateWithAttributes buildUser(String userName, Long directoryId) {
        return DirectoryTestHelper.buildUser(userName, "test@example.com", "Test", "User", directoryId);
    }

    public static UserTemplateWithAttributes buildUser(String userName, String emailAddress, String firstName, String lastName, Long directoryId) {
        UserTemplateWithAttributes user = new UserTemplateWithAttributes(userName, directoryId.longValue());
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmailAddress(emailAddress);
        user.setDisplayName(firstName + " " + lastName);
        user.setActive(true);
        return user;
    }

    public static GroupTemplate buildGroup(String groupName, Long directoryId) {
        GroupTemplate group = new GroupTemplate(groupName, directoryId.longValue(), GroupType.GROUP);
        group.setActive(true);
        return group;
    }

    public static void addUser(UserTemplate user, PasswordCredential passwordCredential, RemoteDirectory remoteDirectory) throws InvalidCredentialException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        user.setDirectoryId(remoteDirectory.getDirectoryId());
        remoteDirectory.addUser(user, new PasswordCredential(passwordCredential));
    }

    public static void addUser(String userName, Long directoryId, String password, RemoteDirectory remoteDirectory) throws InvalidCredentialException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        UserTemplateWithAttributes user = DirectoryTestHelper.buildUser(userName, directoryId);
        remoteDirectory.addUser((UserTemplate)user, new PasswordCredential(password));
    }

    public static void addGroup(GroupTemplate group, RemoteDirectory remoteDirectory) throws InvalidGroupException, OperationFailedException {
        group.setDirectoryId(remoteDirectory.getDirectoryId());
        remoteDirectory.addGroup(group);
    }

    public static void addGroup(String groupName, Long directoryId, RemoteDirectory remoteDirectory) throws InvalidGroupException, OperationFailedException {
        GroupTemplate groupTemplate = DirectoryTestHelper.buildGroup(groupName, directoryId);
        Group addedGroup = remoteDirectory.addGroup(groupTemplate);
        Assert.assertEquals((String)"The added group must be exactly equal to the provided template", (Object)groupTemplate, (Object)new GroupTemplate(addedGroup));
    }
}

