/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.atlassian.crowd.manager.directory.SynchronisationMode;
import java.util.ResourceBundle;
import junit.framework.AssertionFailedError;
import net.sourceforge.jwebunit.junit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCachingTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCachingTestHelper.class);
    private static final String SYNC_DIRECTORY_BUTTON_ID = "synchroniseDirectoryButton";
    private static final String CURRENT_SYNC_INFO_ELEM_ID = "currentsyncinfo";
    protected static final String LAST_SYNC_INFO_ELEM_ID = "lastsyncinfo";
    private static final long ONE_SEC_IN_MILLIS = 1000L;
    public static final long DEFAULT_MAX_SYNC_WAIT_TIME_MS = 60000L;
    private final WebTester tester;
    private final ResourceBundle i18n;

    public DbCachingTestHelper(WebTester tester) {
        this.tester = tester;
        this.i18n = ResourceBundle.getBundle(tester.getTestContext().getResourceBundleName());
    }

    public SyncInfo synchroniseDirectory(String directoryName, long maxWaitTimeMs) {
        return this.synchroniseDirectory(directoryName, maxWaitTimeMs, null);
    }

    public SyncInfo synchroniseDirectory(String directoryName, long maxWaitTimeMs, String shortDescription) {
        this.gotoBrowseDirectories();
        this.tester.clickLinkWithExactText(directoryName);
        this.tester.assertKeyPresent("menu.viewdirectory.label", new Object[]{directoryName});
        this.syncAndWaitTillFinish(maxWaitTimeMs);
        String syncDuration = this.getElementTextById("duration");
        SynchronisationMode mode = null;
        String synchronisationStatus = this.tester.getElementById("status").getTextContent();
        if (synchronisationStatus.equals(this.getText("directory.caching.sync.completed.FULL"))) {
            mode = SynchronisationMode.FULL;
        } else if (synchronisationStatus.equals(this.getText("directory.caching.sync.completed.INCREMENTAL"))) {
            mode = SynchronisationMode.INCREMENTAL;
        } else {
            LOGGER.warn("Synchronisation was not completed: {}\n{}", (Object)synchronisationStatus, (Object)this.tester.getPageSource());
        }
        if (StringUtils.isNotBlank((CharSequence)shortDescription)) {
            LOGGER.info("Synchronisation took: {} ({})", (Object)syncDuration, (Object)shortDescription);
        } else {
            LOGGER.info("Synchronisation took: {}", (Object)syncDuration);
        }
        Assert.assertEquals((Object)"", (Object)this.tester.getElementAttributeByXPath("//input[@id='synchroniseDirectoryButton']", "disabled"));
        return new SyncInfo(directoryName, syncDuration, mode);
    }

    public static SyncInfo synchroniseDirectory(WebTester tester, String directoryName, long maxWaitTimeMs) {
        return new DbCachingTestHelper(tester).synchroniseDirectory(directoryName, maxWaitTimeMs);
    }

    public static SyncInfo synchroniseDirectory(WebTester tester, String directoryName, long maxWaitTimeMs, String shortDescription) {
        return new DbCachingTestHelper(tester).synchroniseDirectory(directoryName, maxWaitTimeMs, shortDescription);
    }

    public PartialSyncTask syncDirectoryTask(String directoryName) {
        Validate.notEmpty((CharSequence)directoryName);
        return new PartialSyncTask(directoryName);
    }

    private void syncAndWaitTillFinish(long maxWaitTimeMs) {
        this.tester.setScriptingEnabled(true);
        if (this.isSynchronising()) {
            Assert.fail((String)"Synchronisation has already been started.");
        }
        this.tester.clickButton(SYNC_DIRECTORY_BUTTON_ID);
        this.tester.gotoPage(this.tester.getTestingEngine().getPageURL().toString());
        long now = System.currentTimeMillis();
        long end = System.currentTimeMillis() + maxWaitTimeMs;
        while (now < end) {
            if (!this.isSynchronising()) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            now = System.currentTimeMillis();
        }
        Assert.fail((String)("Sync did not complete within the maximum wait time: " + DurationFormatUtils.formatDurationWords((long)maxWaitTimeMs, (boolean)true, (boolean)false)));
    }

    public boolean isSynchronising() {
        String style = this.tester.getElementById("lastSyncLabel").getAttribute("style");
        return style.equals("display: none");
    }

    private void gotoBrowseDirectories() {
        this.tester.gotoPage("/console/secure/directory/browse.action");
    }

    private String getElementTextById(String elementId) {
        try {
            return this.tester.getElementById(elementId).getTextContent();
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    private String getText(String key) {
        return this.i18n.getString(key);
    }

    public static class SyncInfo {
        private final String directoryName;
        private final String duration;
        private final SynchronisationMode mode;

        private SyncInfo(String directoryName, String duration, SynchronisationMode mode) {
            this.directoryName = directoryName;
            this.duration = duration;
            this.mode = mode;
        }

        public String getDirectoryName() {
            return this.directoryName;
        }

        public String getDuration() {
            return this.duration;
        }

        public SynchronisationMode getMode() {
            return this.mode;
        }
    }

    public class PartialSyncTask {
        private String directoryName;
        private long maxWaitMs;
        private String shortDescription;

        public PartialSyncTask(String directoryName) {
            this.directoryName = directoryName;
            this.maxWaitMs = 60000L;
            this.shortDescription = "";
        }

        public PartialSyncTask maxWaitMs(long maxWaitMs) {
            this.maxWaitMs = maxWaitMs;
            return this;
        }

        public PartialSyncTask shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public SyncInfo sync() {
            return DbCachingTestHelper.this.synchroniseDirectory(this.directoryName, this.maxWaitMs, this.shortDescription);
        }
    }
}

