/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import net.sourceforge.jwebunit.html.Cell;
import net.sourceforge.jwebunit.html.Row;
import net.sourceforge.jwebunit.junit.WebTestCase;
import net.sourceforge.jwebunit.junit.WebTester;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdWebTestCase
extends WebTestCase {
    private static final Logger logger = LoggerFactory.getLogger(CrowdWebTestCase.class);

    public void assertKeyPresent(String key) {
        try {
            super.assertKeyPresent(key);
        }
        catch (AssertionFailedError error) {
            System.err.println("Unable to find key " + key + "(text: \"" + this.getMessage(key) + "\") in page: ");
            System.err.print(this.getPageSource());
            throw error;
        }
    }

    public void assertKeyPresent(String key, List args) {
        try {
            this.assertKeyPresent(key, args.toArray());
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertKeyPresent(String key, String ... args) {
        try {
            super.assertKeyPresent(key, (Object[])args);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertTextPresent(String text, boolean suppressMessage) {
        try {
            this.assertTextPresent(text);
        }
        catch (AssertionFailedError error) {
            if (!suppressMessage) {
                System.err.println("Unable to find " + text + " in:");
                System.err.print(this.tester.getPageSource());
            }
            throw error;
        }
    }

    public void assertSuccessPresent() {
        this.assertElementPresentByXPath("//p[@class='success']");
    }

    public void assertWarningNotPresent() {
        if (this.getPageSource().indexOf("noteBox") > 0) {
            System.err.print(this.getPageSource());
            Assert.fail((String)"Warning present in page!");
        }
    }

    public void assertErrorNotPresent() {
        if (this.getPageSource().indexOf("warningBox") > 0 || this.getPageSource().indexOf("errorBox") > 0) {
            System.err.print(this.getPageSource());
            Assert.fail((String)"Error present in page!");
        }
    }

    public void assertWarningAndErrorNotPresent() {
        this.assertErrorNotPresent();
        this.assertWarningNotPresent();
    }

    public void assertErrorPresent() {
        if (this.getPageSource().indexOf("errorBox") < 0) {
            System.err.print(this.getPageSource());
            Assert.fail((String)"Error not present in page!");
        }
    }

    public void assertErrorPresentWithKey(String keyName) {
        this.assertErrorPresent();
        this.assertKeyPresent(keyName);
    }

    public void assertWarningPresent() {
        if (this.getPageSource().indexOf("warningBox") < 0) {
            System.err.print(this.getPageSource());
            Assert.fail((String)"Warning not present in page!");
        }
    }

    public void assertLinkPresentWithKey(String keyName) {
        this.assertLinkPresentWithText(this.getMessage(keyName));
    }

    public void assertKeyInElement(String elementID, String key) {
        this.assertTextInElement(elementID, this.getMessage(key));
    }

    public void setRadioButton(String radioButtonName, String value) {
        try {
            this.clickRadioOption(radioButtonName, value);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.getPageSource());
            throw e;
        }
    }

    public void clickLinkWithKey(String key) {
        this.clickLinkWithText(this.getMessage(key));
    }

    public String getElementTextById(String elementId) {
        try {
            return this.getElementById(elementId).getTextContent();
        }
        catch (AssertionFailedError e) {
            System.err.print(this.getPageSource());
            throw e;
        }
    }

    public void addRequestHeader(String header, String value) {
        this.getTestContext().addRequestHeader(header, value);
    }

    public void assertServerResponseContains(String string) {
        if (!this.getServerResponse().contains(string)) {
            System.err.print(this.getServerResponse());
            throw new AssertionError((Object)("Server response did not contain: " + string));
        }
    }

    public void assertServerResponseDoesNotContain(String string) {
        if (this.getServerResponse().contains(string)) {
            System.err.print(this.getServerResponse());
            throw new AssertionError((Object)("Server response contains: " + string));
        }
    }

    public void setTester(WebTester tester) {
        this.tester = tester;
    }

    protected void log(String message) {
        logger.info(message);
    }

    protected String getPageText() {
        return this.getTestingEngine().getPageText();
    }

    public void waitForText(String text, long interval, long maxInterval) throws Exception {
        maxInterval = maxInterval <= 0L ? Integer.MAX_VALUE : maxInterval;
        try {
            this.assertTextPresent(text, true);
            return;
        }
        catch (Throwable throwable) {
            long timeElapsed = TimeUnit.SECONDS.toMillis(10L);
            while (interval + timeElapsed <= maxInterval) {
                Thread.sleep(interval);
                try {
                    this.assertTextPresent(text, true);
                    return;
                }
                catch (Throwable throwable2) {
                    timeElapsed += interval;
                }
            }
            Assert.fail((String)("Unable to find text [" + text + "] on page within " + maxInterval + "ms. \n\nDumping page source: \n" + this.getPageSource()));
            return;
        }
    }

    public void waitForElementByXPath(final String xpath) throws Exception {
        Assert.assertTrue((String)("Unable to find element using xpath [" + xpath + "] on page within time limit. \n\nDumping page source: \n" + this.getPageSource()), (boolean)this.waitFor(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CrowdWebTestCase.this.getTestingEngine().hasElementByXPath(xpath);
            }
        }));
    }

    public void waitForElementById(final String id) throws Exception {
        Assert.assertTrue((String)("Unable to find element using id [" + id + "] on page within time limit. \n\nDumping page source: \n" + this.getPageSource()), (boolean)this.waitFor(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CrowdWebTestCase.this.getTestingEngine().hasElement(id);
            }
        }));
    }

    protected boolean waitFor(Callable<Boolean> isPresent) throws Exception {
        long interval = TimeUnit.SECONDS.toMillis(1L);
        long maxInterval = TimeUnit.SECONDS.toMillis(10L);
        int timeElapsed = 0;
        while ((long)timeElapsed < maxInterval) {
            if (isPresent.call().booleanValue()) {
                return true;
            }
            Thread.sleep(interval);
            timeElapsed = (int)((long)timeElapsed + interval);
        }
        return false;
    }

    public boolean isTextPresent(String text) {
        try {
            this.assertTextPresent(text, true);
            return true;
        }
        catch (AssertionFailedError e) {
            return false;
        }
    }

    public void waitForText(String text) throws Exception {
        this.waitForText(text, TimeUnit.SECONDS.toMillis(2L), TimeUnit.SECONDS.toMillis(120L));
    }

    public void assertKeyPresentOnce(String key) {
        String pageText = this.getPageText();
        this.assertKeyPresent(key);
        CrowdWebTestCase.assertEquals((String)("More than one occurrence of key: " + key), (int)pageText.indexOf(this.getMessage(key)), (int)pageText.lastIndexOf(this.getMessage(key)));
    }

    protected <T> List<T> scrapeTable(String id, Function<List<String>, T> mapper) {
        return this.scrapeTable(id, null, mapper);
    }

    protected <T> List<T> scrapeTable(String id, List<String> headings, Function<List<String>, T> mapper) {
        this.assertTablePresent(id);
        ArrayList<Object> results = new ArrayList<Object>();
        List rows = this.getTable(id).getRows();
        if (headings != null) {
            Row header = (Row)rows.get(0);
            CrowdWebTestCase.assertEquals((int)headings.size(), (int)header.getCells().size());
            for (int i = 0; i < headings.size(); ++i) {
                CrowdWebTestCase.assertEquals((String)headings.get(i), (String)((Cell)header.getCells().get(i)).getValue());
            }
            rows = rows.subList(1, rows.size());
        }
        for (Row r : rows) {
            ArrayList cells = r.getCells();
            ImmutableList.Builder b = ImmutableList.builder();
            if (headings != null) {
                CrowdWebTestCase.assertEquals((int)headings.size(), (int)cells.size());
            }
            for (Cell c : cells) {
                b.add((Object)c.getValue());
            }
            results.add(mapper.apply((Object)b.build()));
        }
        return results;
    }
}

