/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.atlassian.core.util.ClassLoaderUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptanceTestHelper {
    private static final Logger log = LoggerFactory.getLogger(AcceptanceTestHelper.class);
    private static final String IT_TEST_RESOURCES = "target/it-classes";

    protected static File loadFileFromClasspath(String source) throws Exception {
        File testFile = AcceptanceTestHelper.getResource(source);
        if (!testFile.exists()) {
            throw new Exception("Could not find an existing file on filesystem to match:" + source);
        }
        return testFile;
    }

    public static String getTestResourcesLocation() {
        return IT_TEST_RESOURCES;
    }

    public static InputStream getResourceAsStream(String fileName) throws Exception {
        File resource = new File(AcceptanceTestHelper.getTestResourcesLocation(), fileName);
        if (resource.exists()) {
            return new FileInputStream(resource);
        }
        URL classpathResource = ClassLoaderUtils.getResource((String)fileName, AcceptanceTestHelper.class);
        return classpathResource.openStream();
    }

    public static File getResource(String fileName) {
        File fileResource = new File(AcceptanceTestHelper.getTestResourcesLocation(), fileName);
        if (fileResource.exists()) {
            return fileResource;
        }
        URL classpathResource = ClassLoaderUtils.getResource((String)fileName, AcceptanceTestHelper.class);
        if (classpathResource != null) {
            try {
                return new File(classpathResource.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("File does not exist: " + fileName);
    }

    public static String getResourcePath(String fileName) {
        return AcceptanceTestHelper.getResource(fileName).getAbsolutePath();
    }

    public static Properties loadProperties(String fileName) {
        Preconditions.checkNotNull((Object)fileName);
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtils.getResourceAsStream((String)fileName, AcceptanceTestHelper.class);
            if (inputStream == null) {
                throw new RuntimeException("Unable to load properties file: " + fileName);
            }
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties file: " + fileName, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return props;
    }
}

