/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.RestServerImpl;
import com.atlassian.crowd.acceptance.tests.soap.InformationLeakingTestBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class RestXmlParsingTest
extends InformationLeakingTestBase {
    private static String crowdApplicationPassword;
    private final RestServer restServer;

    public RestXmlParsingTest() {
        this(RestServerImpl.INSTANCE);
    }

    public RestXmlParsingTest(RestServer restServer) {
        this.restServer = restServer;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restServer.before();
    }

    @Override
    public void tearDown() throws Exception {
        this.restServer.after();
        super.tearDown();
    }

    @Override
    public String getCrowdApplicationPassword() {
        return "qybhDMZh";
    }

    PostMethod postToRestEndpoint(String content) throws HttpException, UnsupportedEncodingException, IOException {
        StringRequestEntity re = new StringRequestEntity(content, "application/xml", "us-ascii");
        String endpoint = this.getBaseUrl() + "/rest/usermanagement/1/search?entity-type=user";
        HttpClient client = new HttpClient();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("crowd", this.getCrowdApplicationPassword());
        URI base = URI.create(HOST_PATH);
        client.getState().setCredentials(new AuthScope(base.getHost(), base.getPort(), AuthScope.ANY_REALM), (Credentials)creds);
        PostMethod m = new PostMethod(endpoint);
        m.setRequestHeader("Accept", "application/xml");
        m.setRequestEntity((RequestEntity)re);
        client.executeMethod((HttpMethod)m);
        return m;
    }

    public void testEntityExpansionDoesNotIncludeFileContents() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("RestXmlParsingTest-rest-include-external-entity.xml");
        RestXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        contents = contents.replace("/etc/passwd", this.createSecretFile().toURI().toString());
        PostMethod m = this.postToRestEndpoint(contents);
        String resp = IOUtils.toString((InputStream)m.getResponseBodyAsStream(), (String)"us-ascii");
        MediaType mt = MediaType.valueOf((String)m.getResponseHeader("content-type").getValue());
        RestXmlParsingTest.assertEquals((String)"The response should be XML", (String)"application/xml", (String)(mt.getType() + '/' + mt.getSubtype()));
        Assert.assertThat((Object)resp, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.secret)));
    }

    public void testValidEntitiesAreExpanded() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("RestXmlParsingTest-rest-with-amp-entity.xml");
        RestXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        PostMethod m = this.postToRestEndpoint(contents);
        String resp = IOUtils.toString((InputStream)m.getResponseBodyAsStream(), (String)"us-ascii");
        MediaType mt = MediaType.valueOf((String)m.getResponseHeader("content-type").getValue());
        RestXmlParsingTest.assertEquals((String)"The response should be XML", (String)"application/xml", (String)(mt.getType() + '/' + mt.getSubtype()));
        Assert.assertThat((Object)resp, (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"No enum const class com.atlassian.crowd.search.query.entity.restriction.MatchMode.&amp;"), (Matcher)CoreMatchers.containsString((String)"No enum constant com.atlassian.crowd.search.query.entity.restriction.MatchMode.&amp;")));
    }

    public void testEntityExpansionDoesNotCauseDenialOfService() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("RestXmlParsingTest-rest-billion-laughs.xml");
        RestXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        PostMethod m = this.postToRestEndpoint(contents);
        String resp = IOUtils.toString((InputStream)m.getResponseBodyAsStream(), (String)"us-ascii");
        Assert.assertThat((String)"The response should indicate a parsing error", (Object)resp, (Matcher)CoreMatchers.containsString((String)"The request sent by the client was syntactically incorrect"));
        Assert.assertThat((String)"The response should not indicate a server memory error", (Object)resp, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"java.lang.OutOfMemoryError")));
        MediaType mt = MediaType.valueOf((String)m.getResponseHeader("content-type").getValue());
    }
}

