/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest;

import com.atlassian.crowd.acceptance.page.RestorePage;
import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.TestDataState;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.sun.jersey.api.client.Client;
import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.jwebunit.junit.WebTester;

public enum RestServerImpl implements RestServer
{
    INSTANCE;

    private final WebTester webTester = new WebTester();

    public final URL getBaseUrl() {
        try {
            return new URL(CrowdAcceptanceTestCase.HOST_PATH);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void before() throws Exception {
        this.webTester.beginAt(this.getBaseUrl().toString());
        String xmlfilename = AcceptanceTestHelper.getResourcePath("xml/restsetup.xml");
        if (TestDataState.INSTANCE.isRestoredXml(this.getBaseUrl(), xmlfilename)) {
            return;
        }
        new RestorePage(this.webTester, this.getBaseUrl().toString(), "Super User", "admin", "admin").restore(xmlfilename);
        TestDataState.INSTANCE.setRestoredXml(this.getBaseUrl(), xmlfilename);
    }

    public void after() {
        this.webTester.closeBrowser();
    }

    public Client decorateClient(Client client) {
        return client;
    }
}

