/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.upgrade;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask623GenerateExternalId;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class UpgradeTask623GenerateExternalIdIntegrationTest {
    private static final long INTERNAL_DIRECTORY = 1L;
    private static final long NON_INTERNAL_DIRECTORY = 2L;
    private static final String INTERNAL_USER = "bob";
    private static final String NON_INTERNAL_USER = "jane";
    @Inject
    private DirectoryDao directoryDao;
    @Inject
    private UserDao userDao;
    @Inject
    private DataSource dataSource;

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Test
    public void testUpgrade() throws Exception {
        Assert.assertNull((String)"Should not have an externalId yet", (Object)this.userDao.findByName(1L, INTERNAL_USER).getExternalId());
        Assert.assertNull((String)"Should not have an externalId yet", (Object)this.userDao.findByName(2L, NON_INTERNAL_USER).getExternalId());
        UpgradeTask623GenerateExternalId task = new UpgradeTask623GenerateExternalId(this.directoryDao, this.userDao);
        task.doUpgrade();
        Assert.assertNotNull((String)"Should have a generated externalId for user in internal directory", (Object)this.userDao.findByName(1L, INTERNAL_USER).getExternalId());
        Assert.assertNull((String)"Should not update user in non-internal directory", (Object)this.userDao.findByName(2L, NON_INTERNAL_USER).getExternalId());
    }
}

