/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.migration;

import com.atlassian.crowd.acceptance.tests.directory.ImmutableUser;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.token.TokenDAOHibernate;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.persistence.hibernate.SchemaHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.test.jdbc.SimpleJdbcTestUtils;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-schemahelper-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
@TransactionConfiguration(defaultRollback=true)
public class SchemaHelperIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(SchemaHelperIntegrationTest.class);
    private static final String REFERENCE_DATABASE_SCRIPT = "database-crowd-2.1.sql";
    private static final long EXISTING_APPLICATION_ID = 163841L;
    private static final long EXISTING_DIRECTORY_ID = 2L;
    private static final String EXISTING_GROUP_NAME = "badgers";
    private static final String EXISTING_USER_NAME = "penny";
    @Inject
    private SchemaHelper schemaHelper;
    @Inject
    private DataSource dataSource;
    @Inject
    private TokenDAOHibernate tokenDao;
    @Inject
    private ApplicationDAO applicationDao;
    @Inject
    private UserDao userDao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private MembershipDao membershipDao;

    @BeforeTransaction
    public void restoreDatabaseAndUpgradeSchema() throws Exception {
        logger.info("Restoring database");
        Assert.assertNotNull((String)"Data source must have been injected", (Object)this.dataSource);
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(this.dataSource);
        ClassPathResource resource = new ClassPathResource(REFERENCE_DATABASE_SCRIPT);
        SimpleJdbcTestUtils.executeSqlScript((SimpleJdbcTemplate)template, (Resource)resource, (boolean)false);
        logger.info("Database restored");
        logger.info("Updating schema");
        this.schemaHelper.updateSchemaIfNeeded(true);
        logger.info("Schema updated");
    }

    @Test
    @Transactional
    public void testDaosAreFunctionalAfterUpgrade() throws Exception {
        this._testApplicationDao();
        this._testTokenDao();
        this._testUserDao();
        this._testGroupDao();
        this._testMembershipDao();
    }

    private void _testApplicationDao() throws Exception {
        RemoteAddress remoteAddress = new RemoteAddress("127.0.0.99");
        PasswordCredential passwordCredential = new PasswordCredential("password", true);
        EntityQuery allApplicationsQuery = QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).returningAtMost(-1);
        List applicationsBeforeInsertion = this.applicationDao.search(allApplicationsQuery);
        Assert.assertThat((Object)applicationsBeforeInsertion, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertNotNull((String)"There should exist a directory mapping for existing application", (Object)this.applicationDao.findById(163841L).getDirectoryMapping(1L));
        Assert.assertThat((Object)this.applicationDao.findById(163841L).getRemoteAddresses(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        ImmutableApplication newApplication = ImmutableApplication.builder((String)"new application", (ApplicationType)ApplicationType.GENERIC_APPLICATION).setDescription("new description").setPasswordCredential(passwordCredential).setAttributes((Map)ImmutableMap.of((Object)"name1", (Object)"value1")).setRemoteAddresses((Set)ImmutableSet.of((Object)remoteAddress)).build();
        newApplication = this.applicationDao.add((Application)newApplication, passwordCredential);
        List applicationsAfterInsertion = this.applicationDao.search(allApplicationsQuery);
        SchemaHelperIntegrationTest.assertContainsExistingPlusNewOne(applicationsAfterInsertion, applicationsBeforeInsertion, newApplication);
        this.applicationDao.addRemoteAddress(newApplication.getId().longValue(), remoteAddress);
        Assert.assertThat((Object)this.applicationDao.findById(newApplication.getId().longValue()).getRemoteAddresses(), (Matcher)IsCollectionContaining.hasItem((Object)remoteAddress));
        this.applicationDao.addDirectoryMapping(newApplication.getId().longValue(), 2L, false, new OperationType[]{OperationType.CREATE_USER});
        this.applicationDao.addGroupMapping(newApplication.getId().longValue(), 2L, "my group");
        Assert.assertThat((Object)this.applicationDao.findById(newApplication.getId().longValue()).getDirectoryMapping(2L).getAuthorisedGroups(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    private void _testTokenDao() throws Exception {
        long tokenRandomNumber = 12982189L;
        EntityQuery allTokensQuery = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(-1);
        List tokensBeforeInsertion = this.tokenDao.search(allTokensQuery);
        Assert.assertThat((Object)tokensBeforeInsertion, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Token newToken = this.tokenDao.add(new Token.Builder(2L, "tokenName", "tokenHash", tokenRandomNumber, "randomHash").create());
        List tokensAfterInsertion = this.tokenDao.search(allTokensQuery);
        SchemaHelperIntegrationTest.assertContainsExistingPlusNewOne(tokensAfterInsertion, tokensBeforeInsertion, newToken);
    }

    private void _testUserDao() throws Exception {
        EntityQuery allUsersQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
        List usersBeforeInsertion = this.userDao.search(2L, allUsersQuery);
        Assert.assertThat((Object)usersBeforeInsertion, (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)this.userDao.findByNameWithAttributes(2L, "eeeep").getKeys(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        PasswordCredential passwordCredential = new PasswordCredential("password", true);
        ImmutableUser newUser = new ImmutableUser(2L, "user name", "user 1st", "user last", "display name", "email");
        newUser = this.userDao.add((User)newUser, passwordCredential);
        List usersAfterInsertion = this.userDao.search(2L, allUsersQuery);
        SchemaHelperIntegrationTest.assertContainsExistingPlusNewOne(usersAfterInsertion, usersBeforeInsertion, newUser);
        this.userDao.storeAttributes((User)newUser, (Map)ImmutableMap.of((Object)"name1", (Object)ImmutableSet.of((Object)"value1")));
        Assert.assertThat((Object)this.userDao.findByNameWithAttributes(2L, "user name").getValue("name1"), (Matcher)Is.is((Object)"value1"));
    }

    private void _testGroupDao() throws Exception {
        EntityQuery allGroupsQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        List groupsBeforeInsertion = this.groupDao.search(2L, allGroupsQuery);
        Assert.assertThat((Object)groupsBeforeInsertion, (Matcher)IsCollectionWithSize.hasSize((int)4));
        GroupTemplate groupTemplate = new GroupTemplate("group name", 2L, GroupType.GROUP);
        Group newGroup = this.groupDao.add((Group)groupTemplate);
        List groupsAfterInsertion = this.groupDao.search(2L, allGroupsQuery);
        SchemaHelperIntegrationTest.assertContainsExistingPlusNewOne(groupsAfterInsertion, groupsBeforeInsertion, newGroup);
    }

    private void _testMembershipDao() throws Exception {
        MembershipQuery allMembershipsQuery = QueryBuilder.createMembershipQuery((int)1000, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), User.class, (EntityDescriptor)EntityDescriptor.group(), (String)EXISTING_GROUP_NAME);
        List membershipsBeforeInsertion = this.membershipDao.search(2L, allMembershipsQuery);
        Assert.assertThat((Object)membershipsBeforeInsertion, (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.membershipDao.addUserToGroup(2L, EXISTING_USER_NAME, EXISTING_GROUP_NAME);
        List membershipsAfterInsertion = this.membershipDao.search(2L, allMembershipsQuery);
        TimestampedUser newUser = this.userDao.findByName(2L, EXISTING_USER_NAME);
        SchemaHelperIntegrationTest.assertContainsExistingPlusNewOne(membershipsAfterInsertion, membershipsBeforeInsertion, newUser);
    }

    private static <T> void assertContainsExistingPlusNewOne(List<T> elementsAfterInsertion, List<T> elementsBeforeInsertion, T insertedElement) {
        ImmutableSet expectedElementsAfterInsertion = ImmutableSet.builder().addAll(elementsBeforeInsertion).add(insertedElement).build();
        Assert.assertEquals((String)"After insertion, the elements should contain the previous ones plus the new one", (Object)expectedElementsAfterInsertion, (Object)ImmutableSet.copyOf(elementsAfterInsertion));
    }
}

