/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.migration;

import com.atlassian.crowd.acceptance.tests.directory.ImmutableUser;
import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.dao.token.TokenDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;

public abstract class AbstractDaoIntegrationTest {
    private static final String NEW_GROUP_NAME = "new group";
    private static final String NEW_USER_NAME = "new user";
    private static final String NEW_DIRECTORY_NAME = "directory name";
    private Directory newDirectory;
    private Application newApplication;
    private User newUser;
    private Group newGroup;
    private Token newToken;

    public abstract TokenDAOHibernate getTokenDao();

    public abstract ApplicationDAO getApplicationDao();

    public abstract UserDao getUserDao();

    public abstract GroupDao getGroupDao();

    public abstract MembershipDao getMembershipDao();

    public abstract DirectoryDao getDirectoryDao();

    public abstract AliasDAO getAliasDao();

    public abstract PropertyDAO getPropertyDao();

    protected void _testDirectoryDaoCanInsert() throws Exception {
        this.newDirectory = new DirectoryImpl(NEW_DIRECTORY_NAME, DirectoryType.INTERNAL, "implementation.Class");
        this.newDirectory = this.getDirectoryDao().add(this.newDirectory);
        Assert.assertThat((Object)this.getDirectoryDao().findAll(), (Matcher)IsCollectionContaining.hasItem((Object)this.newDirectory));
    }

    protected void _testUserDaoCanInsert() throws Exception {
        Preconditions.checkNotNull((Object)this.newDirectory, (Object)"Create the directory before running this test");
        EntityQuery allUsersQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
        PasswordCredential passwordCredential = new PasswordCredential("password", true);
        this.newUser = new ImmutableUser(this.newDirectory.getId(), NEW_USER_NAME, "user 1st", "user last", "display name", "email");
        this.newUser = this.getUserDao().add(this.newUser, passwordCredential);
        List usersAfterInsertion = this.getUserDao().search(this.newDirectory.getId().longValue(), allUsersQuery);
        Assert.assertThat((Object)usersAfterInsertion, (Matcher)IsCollectionContaining.hasItem((Object)this.newUser));
        this.getUserDao().storeAttributes(this.newUser, (Map)ImmutableMap.of((Object)"name1", (Object)ImmutableSet.of((Object)"value1")));
        Assert.assertThat((Object)this.getUserDao().findByNameWithAttributes(this.newDirectory.getId().longValue(), NEW_USER_NAME).getValue("name1"), (Matcher)Is.is((Object)"value1"));
    }

    protected void _testGroupDaoCanInsert() throws Exception {
        Preconditions.checkNotNull((Object)this.newDirectory, (Object)"Create the directory before running this test");
        EntityQuery allGroupsQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        GroupTemplate groupTemplate = new GroupTemplate(NEW_GROUP_NAME, this.newDirectory.getId().longValue(), GroupType.GROUP);
        this.newGroup = this.getGroupDao().add((Group)groupTemplate);
        List groupsAfterInsertion = this.getGroupDao().search(this.newDirectory.getId().longValue(), allGroupsQuery);
        Assert.assertThat((Object)groupsAfterInsertion, (Matcher)IsCollectionContaining.hasItem((Object)this.newGroup));
    }

    protected void _testMembershipDaoCanInsert() throws Exception {
        Preconditions.checkNotNull((Object)this.newDirectory, (Object)"Create the directory before running this test");
        MembershipQuery allMembershipsQuery = QueryBuilder.createMembershipQuery((int)1000, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), User.class, (EntityDescriptor)EntityDescriptor.group(), (String)NEW_GROUP_NAME);
        this.getMembershipDao().addUserToGroup(this.newDirectory.getId().longValue(), NEW_USER_NAME, NEW_GROUP_NAME);
        List membershipsAfterInsertion = this.getMembershipDao().search(this.newDirectory.getId().longValue(), allMembershipsQuery);
        TimestampedUser newUser = this.getUserDao().findByName(this.newDirectory.getId().longValue(), NEW_USER_NAME);
        Assert.assertThat((Object)membershipsAfterInsertion, (Matcher)IsCollectionContaining.hasItem((Object)newUser));
    }

    protected void _testApplicationDaoCanInsert() throws Exception {
        Preconditions.checkNotNull((Object)this.newDirectory, (Object)"Create the directory before running this test");
        RemoteAddress remoteAddress = new RemoteAddress("127.0.0.99");
        PasswordCredential passwordCredential = new PasswordCredential("password", true);
        EntityQuery allApplicationsQuery = QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).returningAtMost(-1);
        this.newApplication = ImmutableApplication.builder((String)"new application", (ApplicationType)ApplicationType.GENERIC_APPLICATION).setDescription("new description").setPasswordCredential(passwordCredential).setAttributes((Map)ImmutableMap.of((Object)"name1", (Object)"value1")).setRemoteAddresses((Set)ImmutableSet.of((Object)remoteAddress)).build();
        this.newApplication = this.getApplicationDao().add(this.newApplication, passwordCredential);
        List applicationsAfterInsertion = this.getApplicationDao().search(allApplicationsQuery);
        Assert.assertThat((Object)applicationsAfterInsertion, (Matcher)IsCollectionContaining.hasItem((Object)this.newApplication));
        this.getApplicationDao().addRemoteAddress(this.newApplication.getId().longValue(), remoteAddress);
        Assert.assertThat((Object)this.getApplicationDao().findById(this.newApplication.getId().longValue()).getRemoteAddresses(), (Matcher)IsCollectionContaining.hasItem((Object)remoteAddress));
        this.getApplicationDao().addDirectoryMapping(this.newApplication.getId().longValue(), this.newDirectory.getId().longValue(), false, new OperationType[]{OperationType.CREATE_USER});
        this.getApplicationDao().addGroupMapping(this.newApplication.getId().longValue(), this.newDirectory.getId().longValue(), "my group");
        Assert.assertThat((Object)this.getApplicationDao().findById(this.newApplication.getId().longValue()).getDirectoryMapping(this.newDirectory.getId().longValue()).getAuthorisedGroups(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    protected void _testAliasDaoCanInsert() {
        this.getAliasDao().storeAlias(this.newApplication, NEW_USER_NAME, "new alias");
        Assert.assertEquals((Object)this.getAliasDao().findUsernameByAlias(this.newApplication, "new alias"), (Object)NEW_USER_NAME);
    }

    protected void _testTokenDaoCanInsert() throws Exception {
        Preconditions.checkNotNull((Object)this.newDirectory, (Object)"Create the directory before running this test");
        EntityQuery allTokensQuery = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(-1);
        long tokenRandomNumber = 123456789L;
        this.newToken = this.getTokenDao().add(new Token.Builder(this.newDirectory.getId().longValue(), NEW_USER_NAME, "tokenHash", tokenRandomNumber, "randomHash").create());
        List tokensAfterInsertion = this.getTokenDao().search(allTokensQuery);
        Assert.assertThat((Object)tokensAfterInsertion, (Matcher)IsCollectionContaining.hasItem((Object)this.newToken));
    }

    protected void _testPropertyDaoCanInsert() {
        Property newProperty = new Property("key", "name", "value");
        newProperty = this.getPropertyDao().add(newProperty);
        Assert.assertThat((Object)this.getPropertyDao().findAll(), (Matcher)IsCollectionContaining.hasItem((Object)newProperty));
    }
}

