/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.manager.application;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-CrowdManagers.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-internaldirectoryloader-config.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class ApplicationServiceIntegrationTest {
    @Inject
    private ApplicationService applicationService;
    @Inject
    private ApplicationManager applicationManager;
    @Inject
    private DirectoryManager directoryManager;
    @Inject
    private DataSource dataSource;
    private static final long DIRECTORY_1_ID = 32769L;
    private static final long DIRECTORY_2_ID = 32770L;

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("application-manager-test.xml", jdbcTemplate);
    }

    @Test
    public void testAddPrincipalOverMultipleInternalDirectories() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        List directoryMappings = application.getDirectoryMappings();
        UserTemplateWithAttributes testUser = UserTemplateWithAttributes.ofUserWithNoAttributes((User)new UserTemplate("testuser"));
        testUser.setFirstName("beep");
        testUser.setLastName("boop");
        testUser.setEmailAddress("testuser@example.com");
        testUser.setAttribute("phone", "9568-7856");
        testUser.setAttribute("sn", "User");
        testUser.setAttribute("givenName", "Test");
        this.applicationService.addUser(application, (UserTemplate)testUser, new PasswordCredential("secret"));
        this.applicationService.storeUserAttributes(application, testUser.getName(), testUser.getAttributes());
        Long directoryID = ((DirectoryMapping)directoryMappings.get(0)).getDirectory().getId();
        UserWithAttributes savedUser = this.directoryManager.findUserWithAttributesByName(directoryID.longValue(), "testuser");
        Assert.assertEquals((Object)testUser.getEmailAddress(), (Object)savedUser.getEmailAddress());
        Assert.assertEquals((Object)testUser.getName(), (Object)savedUser.getName());
        Assert.assertEquals((Object)testUser.getValue("sn"), (Object)savedUser.getValue("sn"));
        Assert.assertEquals((Object)testUser.getValue("phone"), (Object)savedUser.getValue("phone"));
        Assert.assertEquals((Object)testUser.getValue("givenName"), (Object)savedUser.getValue("givenName"));
        directoryID = ((DirectoryMapping)directoryMappings.get(1)).getDirectory().getId();
        try {
            this.directoryManager.findUserWithAttributesByName(directoryID.longValue(), "testuser");
            Assert.fail((String)"The user should not have been created in the second directory.");
        }
        catch (UserNotFoundException ex) {
            // empty catch block
        }
    }

    @Test
    public void testUpdatePrincipalOverMultipleInternalDirectories() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        UserWithAttributes user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        Assert.assertThat((Object)user1, ApplicationServiceIntegrationTest.userWithNameAndEmail("Super Man", "Admin@example.com"));
        UserWithAttributes user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        Assert.assertThat((Object)user2, ApplicationServiceIntegrationTest.userWithNameAndEmail("Super Man", "Admin@example.com"));
        UserTemplate updatedUser = new UserTemplate((User)user1);
        updatedUser.setDisplayName("Peter Griffin");
        updatedUser.setEmailAddress("peterg@example.com");
        this.applicationService.updateUser(application, updatedUser);
        user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        Assert.assertThat((Object)user1, ApplicationServiceIntegrationTest.userWithNameAndEmail("Peter Griffin", "peterg@example.com"));
        user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        Assert.assertThat((Object)user2, ApplicationServiceIntegrationTest.userWithNameAndEmail("Super Man", "Admin@example.com"));
    }

    @Test
    public void renamePrincipalOverMultipleInternalDirectoriesShouldOnlyRenameOneUser() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        UserWithAttributes user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        Assert.assertThat((Object)user1, ApplicationServiceIntegrationTest.userWithNameAndEmail("Super Man", "Admin@example.com"));
        UserWithAttributes user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        Assert.assertThat((Object)user2, ApplicationServiceIntegrationTest.userWithNameAndEmail("Super Man", "Admin@example.com"));
        this.applicationService.renameUser(application, "admin", "admin2");
        user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin2");
        Assert.assertThat((Object)user1, ApplicationServiceIntegrationTest.userWithNameAndEmail("Super Man", "Admin@example.com"));
        user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        Assert.assertThat((Object)user2, ApplicationServiceIntegrationTest.userWithNameAndEmail("Super Man", "Admin@example.com"));
    }

    @Test
    public void testAddPrincipalAttributeOverMultipleInternalDirectories() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        UserWithAttributes user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        Assert.assertEquals((long)0L, (long)user1.getValues("key").size());
        UserWithAttributes user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        Assert.assertEquals((long)0L, (long)user2.getValues("key").size());
        HashSet<String> testValues = new HashSet<String>();
        testValues.add("val1");
        testValues.add("val2");
        TreeMap<String, HashSet<String>> testAttributes = new TreeMap<String, HashSet<String>>();
        testAttributes.put("key", testValues);
        this.applicationService.storeUserAttributes(application, "admin", testAttributes);
        user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        Set savedValues = user1.getValues("key");
        Assert.assertEquals((long)2L, (long)savedValues.size());
        Assert.assertTrue((boolean)savedValues.contains("val1"));
        Assert.assertTrue((boolean)savedValues.contains("val2"));
        user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        Assert.assertEquals((long)0L, (long)user2.getValues("key").size());
    }

    @Test
    public void testAddGroupOverMultipleInternalDirectories() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        List directoryMappings = application.getDirectoryMappings();
        GroupTemplateWithAttributes testGroup = new GroupTemplateWithAttributes("testgroup", -1L, GroupType.GROUP);
        testGroup.setDescription("test description");
        testGroup.setActive(true);
        this.applicationService.addGroup(application, (GroupTemplate)testGroup);
        for (DirectoryMapping directoryMapping : directoryMappings) {
            GroupWithAttributes savedGroup = this.directoryManager.findGroupWithAttributesByName(directoryMapping.getDirectory().getId().longValue(), "testgroup");
            Assert.assertEquals((Object)testGroup.getName(), (Object)savedGroup.getName());
            Assert.assertEquals((Object)testGroup.getDescription(), (Object)savedGroup.getDescription());
            Assert.assertEquals((Object)testGroup.isActive(), (Object)savedGroup.isActive());
        }
    }

    @Test
    public void testStoreAndRemoveUserAttributes() throws Exception {
        Application application = this.applicationManager.findByName("demo");
        this.applicationService.storeUserAttributes(application, "testuser", Collections.singletonMap("testKey", Collections.singleton("testValue")));
        this.applicationService.removeUserAttributes(application, "testuser", "testKey");
    }

    @Test
    public void testStoreAndRemoveGroupAttributes() throws Exception {
        Application application = this.applicationManager.findByName("demo");
        this.applicationService.storeGroupAttributes(application, "testgroup", Collections.singletonMap("testKey", Collections.singleton("testValue")));
        this.applicationService.removeGroupAttributes(application, "testgroup", "testKey");
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private static Matcher<User> userWithNameAndEmail(String name, String email) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"displayName", (Matcher)Matchers.is((Object)name)), (Matcher)Matchers.hasProperty((String)"emailAddress", (Matcher)Matchers.is((Object)email)));
    }
}

