/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.webhook;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.webhook.WebhookDAO;
import com.atlassian.crowd.exception.WebhookNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.webhook.Webhook;
import com.atlassian.crowd.model.webhook.WebhookTemplate;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import java.util.Date;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.core.IsCollectionContaining;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class WebhookDaoCRUDTest {
    private static final long APPLICATION_ID = 3L;
    private static final String ENDPOINT_URL1 = "http://example.test/1";
    private static final String ENDPOINT_URL2 = "http://example.test/2";
    private static final String TOKEN1 = "secret1";
    private static final String TOKEN2 = "secret2";
    @Inject
    private WebhookDAO dao;
    @Inject
    private ApplicationDAO applicationDao;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    @Inject
    private SessionFactory sessionFactory;

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testAddShouldAssignAnId() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook createdWebhook = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, TOKEN1));
        Assert.assertNotNull((Object)createdWebhook.getId());
    }

    @Test
    public void testAddShouldAssignDifferentIdsToDifferentWebhooks() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook createdWebhook1 = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, TOKEN1));
        Webhook createdWebhook2 = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL2, TOKEN2));
        Assert.assertNotEquals((Object)createdWebhook1.getId(), (Object)createdWebhook2.getId());
    }

    @Test
    public void testAddShouldPersistTemplateFields() throws Exception {
        Application application = this.applicationDao.findById(3L);
        WebhookTemplate webhookTemplate = new WebhookTemplate(application, ENDPOINT_URL1, TOKEN1);
        webhookTemplate.setFailuresSinceLastSuccess(20L);
        webhookTemplate.setOldestFailureDate(new Date(30L));
        Webhook createdWebhook = this.dao.add((Webhook)webhookTemplate);
        Assert.assertSame((Object)application, (Object)createdWebhook.getApplication());
        Assert.assertEquals((Object)ENDPOINT_URL1, (Object)createdWebhook.getEndpointUrl());
        Assert.assertEquals((Object)TOKEN1, (Object)createdWebhook.getToken());
        Assert.assertEquals((long)20L, (long)createdWebhook.getFailuresSinceLastSuccess());
        Assert.assertEquals((Object)new Date(30L), (Object)createdWebhook.getOldestFailureDate());
    }

    @Test
    public void testFindByIdWebhookJustAdded() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook createdWebhook1 = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, TOKEN1));
        Webhook createdWebhook2 = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL2, TOKEN2));
        Webhook returnedWebhook1 = this.dao.findById(createdWebhook1.getId());
        Webhook returnedWebhook2 = this.dao.findById(createdWebhook2.getId());
        Assert.assertThat((Object)returnedWebhook1, (Matcher)Matchers.is((Object)createdWebhook1));
        Assert.assertSame((Object)application, (Object)returnedWebhook1.getApplication());
        Assert.assertEquals((Object)ENDPOINT_URL1, (Object)returnedWebhook1.getEndpointUrl());
        Assert.assertEquals((Object)TOKEN1, (Object)returnedWebhook1.getToken());
        Assert.assertThat((Object)returnedWebhook2, (Matcher)Matchers.is((Object)createdWebhook2));
        Assert.assertSame((Object)application, (Object)returnedWebhook2.getApplication());
        Assert.assertEquals((Object)ENDPOINT_URL2, (Object)returnedWebhook2.getEndpointUrl());
        Assert.assertEquals((Object)TOKEN2, (Object)returnedWebhook2.getToken());
    }

    @Test
    public void testFindAllWebhooksJustAdded() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook createdWebhook = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, TOKEN1));
        Assert.assertThat((Object)this.dao.findAll(), (Matcher)IsCollectionContaining.hasItem((Object)createdWebhook));
    }

    @Test(expected=WebhookNotFoundException.class)
    public void testFindByIdWebhookThatDoesNotExist() throws Exception {
        this.dao.findById(Long.valueOf(1L));
    }

    @Test
    public void testFindByIdWebhookJustRemoved() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook createdWebhook = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, null));
        this.dao.remove(createdWebhook);
        try {
            this.dao.findById(createdWebhook.getId());
            Assert.fail((String)"WebhookNotFoundException expected");
        }
        catch (WebhookNotFoundException webhookNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRemovingApplicationRemovesWebhooksInCascade() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook createdWebhook = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, null));
        this.sessionFactory.getCurrentSession().flush();
        this.applicationDao.remove(application);
        this.sessionFactory.getCurrentSession().flush();
        try {
            this.dao.findById(createdWebhook.getId());
            Assert.fail((String)"WebhookNotFoundException expected");
        }
        catch (WebhookNotFoundException webhookNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFindByApplicationAndEndpointUrl() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook createdWebhook = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, null));
        Webhook foundWebhook = this.dao.findByApplicationAndEndpointUrl(application, ENDPOINT_URL1);
        Assert.assertSame((Object)createdWebhook, (Object)foundWebhook);
    }

    @Test
    public void testFindByApplicationAndEndpointUrlWebhookThatDoesNotExist() throws Exception {
        Application application = this.applicationDao.findById(3L);
        try {
            this.dao.findByApplicationAndEndpointUrl(application, ENDPOINT_URL1);
            Assert.fail((String)"WebhookNotFoundException expected");
        }
        catch (WebhookNotFoundException webhookNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWebhook() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook createdWebhook = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, null));
        this.dao.remove(createdWebhook);
        Assert.assertThat((Object)this.dao.findAll(), (Matcher)IsEmptyIterable.emptyIterableOf(Webhook.class));
    }

    @Test(expected=WebhookNotFoundException.class)
    public void testRemoveNonExistingWebhook() throws Exception {
        Webhook webhook = (Webhook)Mockito.mock(Webhook.class);
        Mockito.when((Object)webhook.getId()).thenReturn((Object)1L);
        this.dao.remove(webhook);
    }

    @Test
    public void testUpdateExistingWebhook() throws Exception {
        Application application = this.applicationDao.findById(3L);
        Webhook initialWebhook = this.dao.add((Webhook)new WebhookTemplate(application, ENDPOINT_URL1, null));
        WebhookTemplate webhookTemplate = new WebhookTemplate(initialWebhook);
        webhookTemplate.setFailuresSinceLastSuccess(2L);
        webhookTemplate.setOldestFailureDate(new Date(3L));
        Webhook updatedWebhook = this.dao.update((Webhook)webhookTemplate);
        Assert.assertEquals((long)2L, (long)updatedWebhook.getFailuresSinceLastSuccess());
        Assert.assertEquals((Object)new Date(3L), (Object)updatedWebhook.getOldestFailureDate());
    }

    @Test(expected=WebhookNotFoundException.class)
    public void testUpdateNonExistingWebhook() throws Exception {
        Webhook webhook = (Webhook)Mockito.mock(Webhook.class);
        Mockito.when((Object)webhook.getId()).thenReturn((Object)1L);
        this.dao.update(webhook);
    }
}

