/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.user;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.model.user.Users;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class UserDaoCRUDTest {
    @Inject
    private UserDao userDAO;
    @Inject
    private MembershipDao membershipDAO;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private static final long DIRECTORY_ID = 1L;
    private static final String EXISTING_USER_1 = "admin";
    private static final String EXISTING_USER_2 = "bob";
    private static final String NON_EXISTING_USER = "newguy";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testFindByName() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        Assert.assertEquals((Object)EXISTING_USER_1, (Object)user.getName());
        Assert.assertTrue((boolean)user.isActive());
        Assert.assertEquals((Object)"Admin@example.com", (Object)user.getEmailAddress());
        Assert.assertEquals((Object)"Super", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Man", (Object)user.getLastName());
        Assert.assertEquals((Object)"Super Man", (Object)user.getDisplayName());
        Assert.assertEquals((Object)"external-id-2", (Object)user.getExternalId());
        Assert.assertTrue((boolean)user.getCreatedDate().before(new Date()));
        Assert.assertTrue((boolean)user.getUpdatedDate().before(new Date()));
        Assert.assertEquals((long)1L, (long)user.getDirectoryId());
    }

    @Test
    public void testFindByMixedCaseNameExactMatch() throws Exception {
        TimestampedUser user = this.userDAO.findByName(2L, "JohnSmith");
        Assert.assertEquals((Object)"JohnSmith", (Object)user.getName());
        Assert.assertTrue((boolean)user.isActive());
        Assert.assertEquals((Object)"johnsmith@smith.com", (Object)user.getEmailAddress());
        Assert.assertEquals((Object)"John", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Smith", (Object)user.getLastName());
        Assert.assertEquals((Object)"John Smith", (Object)user.getDisplayName());
        Assert.assertTrue((boolean)user.getCreatedDate().before(new Date()));
        Assert.assertTrue((boolean)user.getUpdatedDate().before(new Date()));
        Assert.assertEquals((long)2L, (long)user.getDirectoryId());
    }

    @Test
    public void testFindByMixedCaseNameCaseInsensitiveMatch() throws Exception {
        TimestampedUser user = this.userDAO.findByName(2L, "johnsmith");
        Assert.assertEquals((Object)"JohnSmith", (Object)user.getName());
        Assert.assertTrue((boolean)user.isActive());
        Assert.assertEquals((Object)"johnsmith@smith.com", (Object)user.getEmailAddress());
        Assert.assertEquals((Object)"John", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Smith", (Object)user.getLastName());
        Assert.assertEquals((Object)"John Smith", (Object)user.getDisplayName());
        Assert.assertTrue((boolean)user.getCreatedDate().before(new Date()));
        Assert.assertTrue((boolean)user.getUpdatedDate().before(new Date()));
        Assert.assertEquals((long)2L, (long)user.getDirectoryId());
    }

    @Test(expected=UserNotFoundException.class)
    public void testFindByNameWhereUserDoesNotExist() throws Exception {
        this.userDAO.findByName(1L, NON_EXISTING_USER);
    }

    @Test
    public void testFindByNameWithAttributes() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((Object)EXISTING_USER_1, (Object)user.getName());
        Assert.assertTrue((boolean)user.isActive());
        Assert.assertEquals((Object)"Admin@example.com", (Object)user.getEmailAddress());
        Assert.assertEquals((Object)"Super", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Man", (Object)user.getLastName());
        Assert.assertEquals((Object)"Super Man", (Object)user.getDisplayName());
        Assert.assertEquals((Object)"external-id-2", (Object)user.getExternalId());
        Assert.assertEquals((long)1L, (long)user.getDirectoryId());
        Assert.assertEquals((long)2L, (long)user.getKeys().size());
        Assert.assertTrue((boolean)user.getKeys().contains("color"));
        Assert.assertTrue((boolean)user.getKeys().contains("openid"));
        Assert.assertEquals((long)2L, (long)user.getValues("color").size());
        Assert.assertTrue((boolean)user.getValues("color").contains("black"));
        Assert.assertTrue((boolean)user.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)user.getValues("openid").size());
        Assert.assertEquals((Object)"http://my.openid.com/admin", (Object)user.getValue("openid"));
    }

    @Test(expected=UserNotFoundException.class)
    public void testFindByNameWithAttributesWhereUserDoesNotExist() throws Exception {
        this.userDAO.findByNameWithAttributes(1L, NON_EXISTING_USER);
    }

    @Test
    public void testGetCredential() throws UserNotFoundException {
        PasswordCredential credential = this.userDAO.getCredential(1L, EXISTING_USER_1);
        Assert.assertTrue((boolean)credential.isEncryptedCredential());
        Assert.assertEquals((Object)"5m0k350m3h4$h", (Object)credential.getCredential());
    }

    @Test(expected=UserNotFoundException.class)
    public void testGetCredentialWhereUserDoesNotExist() throws Exception {
        this.userDAO.getCredential(1L, NON_EXISTING_USER);
    }

    @Test
    public void testGetCredentialHistory() throws UserNotFoundException {
        List credentialHistory = this.userDAO.getCredentialHistory(1L, EXISTING_USER_1);
        Assert.assertThat((Object)credentialHistory, (Matcher)IsCollectionContaining.hasItems((Object[])new PasswordCredential[]{PasswordCredential.encrypted((String)"mysecret"), PasswordCredential.encrypted((String)"mysecret2")}));
    }

    @Test(expected=UserNotFoundException.class)
    public void testGetCredentialHistoryWhereUserDoesNotExist() throws Exception {
        this.userDAO.getCredentialHistory(1L, NON_EXISTING_USER);
    }

    @Test
    public void testAddMixedCaseName() throws Exception {
        User createdUser = this.createNewUser("NewUser");
        Assert.assertNotNull((Object)createdUser);
        Assert.assertTrue((((InternalUser)createdUser).getId() > 0L ? 1 : 0) != 0);
        TimestampedUser foundUser = this.userDAO.findByName(1L, "NewUser");
        Assert.assertTrue((boolean)foundUser.getName().equals("NewUser"));
        Assert.assertEquals((Object)true, (Object)foundUser.isActive());
        Assert.assertEquals((Object)"New", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"Guy", (Object)foundUser.getLastName());
        Assert.assertEquals((Object)"New Guy", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"nOOb@example.com", (Object)foundUser.getEmailAddress());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT lower_user_name, lower_first_name, lower_last_name, lower_display_name, lower_email_address FROM cwd_user WHERE user_name = 'NewUser'");
        Assert.assertTrue((boolean)sqlRowSet.next());
        Assert.assertEquals((Object)"new", (Object)sqlRowSet.getString("lower_first_name"));
        Assert.assertEquals((Object)"guy", (Object)sqlRowSet.getString("lower_last_name"));
        Assert.assertEquals((Object)"noob@example.com", (Object)sqlRowSet.getString("lower_email_address"));
        Assert.assertEquals((Object)"new guy", (Object)sqlRowSet.getString("lower_display_name"));
        Assert.assertEquals((Object)"newuser", (Object)sqlRowSet.getString("lower_user_name"));
    }

    @Test
    public void testAdd() throws Exception {
        User createdUser = this.createNewUser(NON_EXISTING_USER);
        Assert.assertNotNull((Object)createdUser);
        Assert.assertTrue((((InternalUser)createdUser).getId() > 0L ? 1 : 0) != 0);
        TimestampedUser foundUser = this.userDAO.findByName(1L, NON_EXISTING_USER);
        Assert.assertTrue((boolean)foundUser.getName().equals(NON_EXISTING_USER));
        Assert.assertEquals((Object)true, (Object)foundUser.isActive());
        Assert.assertEquals((Object)"New", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"Guy", (Object)foundUser.getLastName());
        Assert.assertEquals((Object)"New Guy", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"nOOb@example.com", (Object)foundUser.getEmailAddress());
        Assert.assertEquals((Object)"new-external-id", (Object)foundUser.getExternalId());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT lower_first_name, lower_last_name, lower_display_name, lower_email_address FROM cwd_user WHERE user_name = 'newguy'");
        Assert.assertTrue((boolean)sqlRowSet.next());
        Assert.assertEquals((Object)"new", (Object)sqlRowSet.getString("lower_first_name"));
        Assert.assertEquals((Object)"guy", (Object)sqlRowSet.getString("lower_last_name"));
        Assert.assertEquals((Object)"noob@example.com", (Object)sqlRowSet.getString("lower_email_address"));
        Assert.assertEquals((Object)"new guy", (Object)sqlRowSet.getString("lower_display_name"));
    }

    @Test
    public void testAddNull() throws Exception {
        UserTemplate user = new UserTemplate(NON_EXISTING_USER, 1L);
        this.userDAO.add((User)user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.userDAO.findByName(1L, NON_EXISTING_USER);
        Assert.assertEquals((Object)NON_EXISTING_USER, (Object)foundUser.getName());
        Assert.assertEquals((Object)false, (Object)foundUser.isActive());
        Assert.assertNull((Object)foundUser.getFirstName());
        Assert.assertNull((Object)foundUser.getLastName());
        Assert.assertNull((Object)foundUser.getDisplayName());
        Assert.assertNull((Object)foundUser.getEmailAddress());
        Assert.assertNull((Object)foundUser.getExternalId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddWithUnencryptedPassword() throws Exception {
        UserTemplate user = new UserTemplate(NON_EXISTING_USER, 1L);
        this.userDAO.add((User)user, PasswordCredential.unencrypted((String)"unencrypted secret"));
    }

    @Test(expected=UserAlreadyExistsException.class)
    public void testAddExistingUserWithSameCaseUsername() throws Exception {
        this.createNewUser(EXISTING_USER_2);
    }

    @Test(expected=UserAlreadyExistsException.class)
    public void testAddExistingUserWithDifferentCaseUsername() throws Exception {
        this.createNewUser(EXISTING_USER_1.toUpperCase());
    }

    @Test
    public void testUpdate() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        UserTemplate userTemplate = new UserTemplate((User)user);
        userTemplate.setFirstName("Someone");
        userTemplate.setLastName("Different");
        userTemplate.setActive(false);
        userTemplate.setDisplayName("A specific displayName");
        userTemplate.setEmailAddress("Someone@different.com");
        userTemplate.setExternalId("different-external-id");
        User returnedUser = this.userDAO.update((User)userTemplate);
        Assert.assertFalse((boolean)returnedUser.isActive());
        Assert.assertEquals((Object)"Someone", (Object)returnedUser.getFirstName());
        Assert.assertEquals((Object)"Different", (Object)returnedUser.getLastName());
        Assert.assertEquals((Object)"A specific displayName", (Object)returnedUser.getDisplayName());
        Assert.assertEquals((Object)"Someone@different.com", (Object)returnedUser.getEmailAddress());
        Assert.assertEquals((Object)"different-external-id", (Object)returnedUser.getExternalId());
        TimestampedUser foundUser = this.userDAO.findByName(1L, EXISTING_USER_1);
        Assert.assertFalse((boolean)foundUser.isActive());
        Assert.assertEquals((Object)"Someone", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"Different", (Object)foundUser.getLastName());
        Assert.assertEquals((Object)"A specific displayName", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"Someone@different.com", (Object)foundUser.getEmailAddress());
        Assert.assertEquals((Object)"different-external-id", (Object)foundUser.getExternalId());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT lower_first_name, lower_last_name, lower_display_name, lower_email_address FROM cwd_user WHERE user_name = 'admin'");
        Assert.assertTrue((boolean)sqlRowSet.next());
        Assert.assertEquals((Object)"someone", (Object)sqlRowSet.getString("lower_first_name"));
        Assert.assertEquals((Object)"different", (Object)sqlRowSet.getString("lower_last_name"));
        Assert.assertEquals((Object)"someone@different.com", (Object)sqlRowSet.getString("lower_email_address"));
        Assert.assertEquals((Object)"a specific displayname", (Object)sqlRowSet.getString("lower_display_name"));
    }

    @Test
    public void testUpdateShouldNotRenameUser() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_2);
        UserTemplate userTemplate = new UserTemplate((User)user);
        userTemplate.setName("Bob");
        userTemplate.setFirstName("Someone");
        User returnedUser = this.userDAO.update((User)userTemplate);
        Assert.assertEquals((String)"Username should be unaltered, update() should not rename", (Object)EXISTING_USER_2, (Object)returnedUser.getName());
        Assert.assertEquals((String)"Other attributes should be updated", (Object)"Someone", (Object)returnedUser.getFirstName());
        TimestampedUser foundUser = this.userDAO.findByName(1L, EXISTING_USER_2);
        Assert.assertEquals((String)"Username should be unaltered, update() should not rename", (Object)EXISTING_USER_2, (Object)foundUser.getName());
        Assert.assertEquals((String)"Other attributes should be updated", (Object)"Someone", (Object)foundUser.getFirstName());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT user_name, first_name, lower_first_name FROM cwd_user WHERE lower_user_name = 'bob'");
        Assert.assertTrue((boolean)sqlRowSet.next());
        Assert.assertEquals((Object)EXISTING_USER_2, (Object)sqlRowSet.getString("user_name"));
        Assert.assertEquals((Object)"Someone", (Object)sqlRowSet.getString("first_name"));
        Assert.assertEquals((Object)"someone", (Object)sqlRowSet.getString("lower_first_name"));
    }

    @Test
    public void testUpdateWhenUserDoesNotExist() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        this.userDAO.remove((User)user);
        try {
            this.userDAO.update((User)user);
            Assert.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateCredentialChangesCredential() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        PasswordCredential newPassword = PasswordCredential.encrypted((String)"password");
        this.userDAO.updateCredential((User)user, newPassword, 0);
        Assert.assertEquals((Object)newPassword, (Object)this.userDAO.getCredential(1L, EXISTING_USER_1));
    }

    @Test
    public void testUpdateCredentialAddsNewCredentialToCredentialHistory() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        Assert.assertThat((Object)this.userDAO.getCredentialHistory(1L, EXISTING_USER_1), (Matcher)IsCollectionContaining.hasItems((Object[])new PasswordCredential[]{PasswordCredential.encrypted((String)"mysecret"), PasswordCredential.encrypted((String)"mysecret2")}));
        PasswordCredential newPassword = PasswordCredential.encrypted((String)"password");
        this.userDAO.updateCredential((User)user, newPassword, 10);
        Assert.assertThat((Object)this.userDAO.getCredentialHistory(1L, EXISTING_USER_1), (Matcher)IsCollectionContaining.hasItems((Object[])new PasswordCredential[]{PasswordCredential.encrypted((String)"password"), PasswordCredential.encrypted((String)"mysecret"), PasswordCredential.encrypted((String)"mysecret2")}));
    }

    @Test
    public void testUpdateCredentialWhenCredentialHistoryIsFull() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        Assert.assertThat((Object)this.userDAO.getCredentialHistory(1L, EXISTING_USER_1), (Matcher)IsCollectionContaining.hasItems((Object[])new PasswordCredential[]{PasswordCredential.encrypted((String)"mysecret"), PasswordCredential.encrypted((String)"mysecret2")}));
        PasswordCredential newPassword = PasswordCredential.encrypted((String)"password");
        this.userDAO.updateCredential((User)user, newPassword, 2);
        Assert.assertThat((Object)this.userDAO.getCredentialHistory(1L, EXISTING_USER_1), (Matcher)IsCollectionContaining.hasItems((Object[])new PasswordCredential[]{PasswordCredential.encrypted((String)"password"), PasswordCredential.encrypted((String)"mysecret2")}));
        Assert.assertThat((Object)this.userDAO.getCredentialHistory(1L, EXISTING_USER_1), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)PasswordCredential.encrypted((String)"mysecret"))));
    }

    @Test
    public void testUpdateCredentialPreservesReferentialIntegrity() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        Assert.assertThat((Object)this.userDAO.getCredentialHistory(1L, EXISTING_USER_1), (Matcher)IsCollectionWithSize.hasSize((int)2));
        PasswordCredential newPassword = PasswordCredential.encrypted((String)"password");
        this.userDAO.updateCredential((User)user, newPassword, 2);
        this.userDAO.remove((User)user);
    }

    @Test
    public void testRenameToACompletelyDifferentName() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        User returnedUser = this.userDAO.rename((User)user, NON_EXISTING_USER);
        Assert.assertEquals((Object)NON_EXISTING_USER, (Object)returnedUser.getName());
        try {
            this.userDAO.findByName(1L, EXISTING_USER_1);
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        TimestampedUser renamedUser = this.userDAO.findByName(1L, NON_EXISTING_USER);
        Assert.assertEquals((Object)NON_EXISTING_USER, (Object)renamedUser.getName());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(EXISTING_USER_1).returningAtMost(10)).size());
        Assert.assertEquals((long)2L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(NON_EXISTING_USER).returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.user()).withName(NON_EXISTING_USER).returningAtMost(10)).size());
    }

    @Test
    public void testRenameWhenUsernameContainsMixedCase() throws Exception {
        TimestampedUser user = this.userDAO.findByName(2L, "JohnSmith");
        User returnedUser = this.userDAO.rename((User)user, "BobSmith");
        Assert.assertEquals((Object)"BobSmith", (Object)returnedUser.getName());
        try {
            this.userDAO.findByName(2L, "JohnSmith");
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        TimestampedUser renamedUser = this.userDAO.findByName(2L, "BobSmith");
        Assert.assertEquals((Object)"BobSmith", (Object)renamedUser.getName());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("johnsmith").returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("bobsmith").returningAtMost(10)).size());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("JohnSmith").returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("BobSmith").returningAtMost(10)).size());
    }

    @Test
    public void testRenameWhenUserDoesNotExist() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        this.userDAO.remove((User)user);
        try {
            this.userDAO.rename((User)user, "NewName");
            Assert.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameWhenThereIsANameClashWithAnotherUser() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        try {
            this.userDAO.rename((User)user, EXISTING_USER_2);
            Assert.fail((String)"UserAlreadyExistsException expected");
        }
        catch (UserAlreadyExistsException userAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameToExactlySameName() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        User returnedUser = this.userDAO.rename((User)user, EXISTING_USER_1);
        Assert.assertEquals((Object)EXISTING_USER_1, (Object)returnedUser.getName());
    }

    @Test
    public void testRenameWhenOnlyCaseChanges() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_2);
        User returnedUser = this.userDAO.rename((User)user, "Bob");
        Assert.assertEquals((Object)"Bob", (Object)returnedUser.getName());
        Assert.assertEquals((Object)"Bob", (Object)this.userDAO.findByName(1L, EXISTING_USER_2).getName());
        Assert.assertEquals((Object)"Bob", (Object)this.userDAO.findByName(1L, "Bob").getName());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(EXISTING_USER_2).returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("Bob").returningAtMost(10)).size());
    }

    @Test
    public void testRemove() throws Exception {
        TimestampedUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        long userId = user.getDirectoryId();
        this.userDAO.remove((User)user);
        try {
            this.userDAO.findByName(1L, EXISTING_USER_1);
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertThat((Object)jdbcTemplate.queryForObject("SELECT COUNT(*) FROM cwd_user_credential_record WHERE user_id = ?", Integer.class, new Object[]{userId}), (Matcher)Matchers.is((Object)0));
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(EXISTING_USER_1).returningAtMost(10)).size());
    }

    @Test
    public void testRemoveMixedCaseInsensitive() throws Exception {
        TimestampedUser user = this.userDAO.findByName(2L, "johnSmith");
        long userId = user.getDirectoryId();
        this.userDAO.remove((User)user);
        try {
            this.userDAO.findByName(1L, "johnSmith");
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertThat((Object)jdbcTemplate.queryForObject("SELECT COUNT(*) FROM cwd_user_credential_record WHERE user_id = ?", Integer.class, new Object[]{userId}), (Matcher)Matchers.is((Object)0));
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("JohnSmith").returningAtMost(10)).size());
    }

    @Test
    public void testStoreAttributesWithUpdateAndInsertForExistingUser() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)2L, (long)user.getKeys().size());
        Assert.assertEquals((long)2L, (long)user.getValues("color").size());
        Assert.assertTrue((boolean)user.getValues("color").contains("black"));
        Assert.assertTrue((boolean)user.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)user.getValues("openid").size());
        Assert.assertEquals((Object)"http://my.openid.com/admin", (Object)user.getValue("openid"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"blue", "green", "Red"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.userDAO.storeAttributes((User)user, attributes);
        UserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)3L, (long)returnedUser.getKeys().size());
        Assert.assertEquals((long)3L, (long)returnedUser.getValues("color").size());
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("blue"));
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("green"));
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("phone").size());
        Assert.assertTrue((boolean)returnedUser.getValues("phone").contains("131111"));
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("openid").size());
        Assert.assertEquals((Object)"http://my.openid.com/admin", (Object)returnedUser.getValue("openid"));
    }

    @Test
    public void testStoreAttributesForExistingMixedCaseUser() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(2L, "JohnSmith");
        Assert.assertEquals((long)1L, (long)user.getKeys().size());
        Assert.assertEquals((long)1L, (long)user.getValues("color").size());
        Assert.assertTrue((boolean)user.getValues("color").contains("violet"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"blue", "green", "Red"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.userDAO.storeAttributes((User)user, attributes);
        UserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(2L, "JohnSmith");
        Assert.assertEquals((long)2L, (long)returnedUser.getKeys().size());
        Assert.assertEquals((long)3L, (long)returnedUser.getValues("color").size());
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("blue"));
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("green"));
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("phone").size());
        Assert.assertTrue((boolean)returnedUser.getValues("phone").contains("131111"));
    }

    @Test
    public void testStoreAttributesWithUpdateAndDeleteForExistingUser() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)2L, (long)user.getKeys().size());
        Assert.assertEquals((long)2L, (long)user.getValues("color").size());
        Assert.assertTrue((boolean)user.getValues("color").contains("black"));
        Assert.assertTrue((boolean)user.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)user.getValues("openid").size());
        Assert.assertEquals((Object)"http://my.openid.com/admin", (Object)user.getValue("openid"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"Red"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.userDAO.storeAttributes((User)user, attributes);
        UserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)3L, (long)returnedUser.getKeys().size());
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("color").size());
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("phone").size());
        Assert.assertTrue((boolean)returnedUser.getValues("phone").contains("131111"));
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("openid").size());
        Assert.assertEquals((Object)"http://my.openid.com/admin", (Object)returnedUser.getValue("openid"));
    }

    @Test
    public void testStoreSingleAttributeWithUpdateForExistingUser() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)2L, (long)user.getKeys().size());
        Assert.assertEquals((long)2L, (long)user.getValues("color").size());
        Assert.assertTrue((boolean)user.getValues("color").contains("black"));
        Assert.assertTrue((boolean)user.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)user.getValues("openid").size());
        Assert.assertEquals((Object)"http://my.openid.com/admin", (Object)user.getValue("openid"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("openid", Sets.newHashSet((Object[])new String[]{"newval"}));
        this.userDAO.storeAttributes((User)user, attributes);
        UserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)2L, (long)returnedUser.getKeys().size());
        Assert.assertEquals((long)2L, (long)returnedUser.getValues("color").size());
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("black"));
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("openid").size());
        Assert.assertEquals((Object)"newval", (Object)returnedUser.getValue("openid"));
    }

    @Test
    public void testStoreAttributesWithUpdateForExistingUser() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)2L, (long)user.getKeys().size());
        Assert.assertEquals((long)2L, (long)user.getValues("color").size());
        Assert.assertTrue((boolean)user.getValues("color").contains("black"));
        Assert.assertTrue((boolean)user.getValues("color").contains("Red"));
        Assert.assertEquals((long)1L, (long)user.getValues("openid").size());
        Assert.assertEquals((Object)"http://my.openid.com/admin", (Object)user.getValue("openid"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"orange", "Pink"}));
        attributes.put("openid", Sets.newHashSet((Object[])new String[]{"new"}));
        this.userDAO.storeAttributes((User)user, attributes);
        UserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)2L, (long)returnedUser.getKeys().size());
        Assert.assertEquals((long)2L, (long)returnedUser.getValues("color").size());
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("orange"));
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("Pink"));
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("openid").size());
        Assert.assertEquals((Object)"new", (Object)returnedUser.getValue("openid"));
    }

    @Test
    public void testStoreAttributesWhenUserDoesNotExist() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        this.userDAO.remove((User)user);
        try {
            this.userDAO.storeAttributes((User)user, (Map)ImmutableMap.of());
            Assert.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAttribute() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)2L, (long)user.getKeys().size());
        this.userDAO.removeAttribute((User)user, "color");
        UserWithAttributes updatedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        Assert.assertEquals((long)1L, (long)updatedUser.getKeys().size());
        Assert.assertEquals((long)1L, (long)updatedUser.getValues("openid").size());
        Assert.assertEquals((Object)"http://my.openid.com/admin", (Object)updatedUser.getValue("openid"));
    }

    @Test
    public void testRemoveAttributeMixedCaseUser() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(2L, "joHnSmith");
        Assert.assertEquals((long)1L, (long)user.getKeys().size());
        this.userDAO.removeAttribute((User)user, "color");
        UserWithAttributes updatedUser = this.userDAO.findByNameWithAttributes(2L, "joHnSmith");
        Assert.assertEquals((long)0L, (long)updatedUser.getKeys().size());
    }

    @Test
    public void testRemoveAttributeWhenUserDoesNotExist() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        this.userDAO.remove((User)user);
        try {
            this.userDAO.removeAttribute((User)user, "some attribute");
            Assert.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAttributeWhenAttributesDoesNotExist() throws Exception {
        UserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        this.userDAO.removeAttribute((User)user, "non-existent attribute name");
    }

    @Test
    public void testAddAll() {
        HashSet<UserTemplateWithCredentialAndAttributes> users = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (int i = 0; i < 50; ++i) {
            UserTemplateWithCredentialAndAttributes user = new UserTemplateWithCredentialAndAttributes("User" + i, 1L, new PasswordCredential("secret", true));
            user.setEmailAddress("blah@example.com");
            user.setFirstName("Clone");
            user.setLastName("Drone");
            user.setDisplayName("Clone Drone");
            user.setAttribute("flavour", "chocolate");
            user.setAttribute("drink", "coke");
            users.add(user);
        }
        BatchResult result = this.userDAO.addAll(users);
        Assert.assertEquals((long)50L, (long)result.getTotalSuccessful());
        Assert.assertEquals((long)50L, (long)result.getTotalAttempted());
        Assert.assertTrue((boolean)result.getFailedEntities().isEmpty());
        Assert.assertEquals((long)50L, (long)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).startingWith((Object)"user")).returningAtMost(100)).size());
        Assert.assertEquals((long)50L, (long)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"flavour")).exactlyMatching((Object)"chocolate")).returningAtMost(100)).size());
        Assert.assertEquals((long)50L, (long)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"drink")).exactlyMatching((Object)"coke")).returningAtMost(100)).size());
    }

    @Test
    public void testAddAllWithErrorsAndDuplicates() throws Exception {
        int userCount = this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(100)).size();
        HashSet<UserTemplateWithCredentialAndAttributes> users = new HashSet<UserTemplateWithCredentialAndAttributes>();
        UserTemplateWithCredentialAndAttributes user = new UserTemplateWithCredentialAndAttributes("user", 1L, new PasswordCredential("secret", true));
        user.setEmailAddress("common@example.com");
        user.setFirstName("Clone");
        user.setLastName("Drone");
        user.setDisplayName("Clone Drone");
        user.setAttribute("flavour", "chocolate");
        user.setAttribute("drink", "coke");
        users.add(user);
        UserTemplateWithCredentialAndAttributes existingUser = new UserTemplateWithCredentialAndAttributes((User)this.userDAO.findByName(1L, EXISTING_USER_1), new PasswordCredential("secret", true));
        existingUser.setEmailAddress("common@example.com");
        users.add(existingUser);
        UserTemplateWithCredentialAndAttributes incompleteUser = new UserTemplateWithCredentialAndAttributes("user2", 1L, new PasswordCredential("secret", true));
        users.add(incompleteUser);
        UserTemplateWithCredentialAndAttributes differentDirectoryUser = new UserTemplateWithCredentialAndAttributes("user3", 2L, new PasswordCredential("secret", true));
        differentDirectoryUser.setEmailAddress("common@example.com");
        differentDirectoryUser.setFirstName("Clone");
        differentDirectoryUser.setLastName("Drone");
        differentDirectoryUser.setDisplayName("Clone Drone");
        differentDirectoryUser.setAttribute("flavour", "chocolate");
        differentDirectoryUser.setAttribute("drink", "coke");
        users.add(differentDirectoryUser);
        BatchResult result = this.userDAO.addAll(users);
        Assert.assertEquals((long)3L, (long)result.getTotalSuccessful());
        Assert.assertEquals((long)users.size(), (long)result.getTotalAttempted());
        Assert.assertThat((Object)Users.namesOf((Iterable)result.getFailedEntities()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_1}));
        Assert.assertEquals((long)(userCount + 2), (long)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(100)).size());
        Assert.assertEquals((long)1L, (long)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"flavour")).exactlyMatching((Object)"chocolate")).returningAtMost(100)).size());
        Assert.assertEquals((long)1L, (long)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"drink")).exactlyMatching((Object)"coke")).returningAtMost(100)).size());
    }

    private User createNewUser(String username) throws Exception {
        UserTemplate user = new UserTemplate(username, 1L);
        user.setActive(true);
        user.setFirstName("New");
        user.setLastName("Guy");
        user.setDisplayName("New Guy");
        user.setEmailAddress("nOOb@example.com");
        user.setExternalId("new-external-id");
        return this.userDAO.add((User)user, PasswordCredential.encrypted((String)"secret"));
    }
}

