/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.property;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.dao.property.PropertyDAOHibernate;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.util.persistence.PersistenceException;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import java.util.List;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class PropertyDAOHibernateTest {
    @Inject
    private PropertyDAOHibernate propertyDAO;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private static final String CROWD_KEY = "crowd";
    private static final String NAME = "name1";
    private static final String VALUE = "value1";
    private static final String NEW_NAME = "newName";
    private static final String NEW_VALUE = "newValue";
    private static final String JIRA_KEY = "jira";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testFindByName() throws Exception {
        Property property = this.propertyDAO.find(CROWD_KEY, NAME);
        Assert.assertEquals((Object)VALUE, (Object)property.getValue());
    }

    public void testAdd() throws Exception {
        Property property = new Property(CROWD_KEY, NEW_NAME, NEW_VALUE);
        this.propertyDAO.add(property);
        Assert.assertEquals((Object)NEW_VALUE, (Object)this.propertyDAO.find(CROWD_KEY, NEW_NAME).getValue());
    }

    @Test(expected=ConstraintViolationException.class)
    public void testAddDuplication() {
        Property property = new Property(CROWD_KEY, NAME, VALUE);
        this.propertyDAO.add(property);
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test
    public void testUpdate() throws Exception {
        Property property = this.propertyDAO.find(CROWD_KEY, NAME);
        property.setValue(NEW_VALUE);
        this.propertyDAO.update(property);
        Assert.assertEquals((Object)NEW_VALUE, (Object)this.propertyDAO.find(CROWD_KEY, NAME).getValue());
    }

    @Test
    public void testFindAllByKey() {
        List properties = this.propertyDAO.findAll(CROWD_KEY);
        Assert.assertEquals((long)2L, (long)properties.size());
        properties = this.propertyDAO.findAll(JIRA_KEY);
        Assert.assertEquals((long)1L, (long)properties.size());
        properties = this.propertyDAO.findAll("boguskey");
        Assert.assertEquals((long)0L, (long)properties.size());
    }

    @Test
    public void testFindAll() throws PersistenceException {
        List allProperties = this.propertyDAO.findAll();
        Assert.assertEquals((long)3L, (long)allProperties.size());
    }

    @Test
    public void testRemoveProperty() {
        this.propertyDAO.remove(CROWD_KEY, NAME);
        try {
            this.propertyDAO.find(CROWD_KEY, NAME);
            Assert.fail((String)"ObjectNotFoundException expected");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }
}

