/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.group;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.Groups;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class GroupDaoSearchTest {
    private static final long DIRECTORY_ID = 1L;
    private static final String EXISTING_GROUP_1 = "administratorS";
    private static final String EXISTING_GROUP_2 = "users";
    private static final String EXISTING_GROUP_3 = "developers";
    private static final String EXISTING_GROUP_4 = "Managers";
    private static final String COUNTRY_ATTRIBUTE = "country";
    private static final String CITY_ATTRIBUTE = "city";
    private static final String LANGUAGE_ATTRIBUTE = "language";
    private static final String COUNTRY_VALUE_NZ = "New Zealand";
    private static final String COUNTRY_VALUE_AU = "Australia";
    private static final String COUNTRY_VALUE_CN = "China";
    private static final String CITY_VALUE_SYD = "Sydney";
    @Inject
    private GroupDao groupDAO;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testSearchAllGroupNames() {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(10);
        List groups = this.groupDAO.search(1L, query);
        Assert.assertEquals(Arrays.asList(EXISTING_GROUP_1, EXISTING_GROUP_3, EXISTING_GROUP_4), (Object)groups);
    }

    @Test
    public void testSearchGroupNameStartsWith() {
        TermRestriction groupNameRestriction = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"a");
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_1}));
    }

    @Test
    public void testSearchGroupTypeRole() {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).returningAtMost(-1);
        List groups = this.groupDAO.search(1L, query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_2}));
    }

    @Test
    public void testSearchGroupTypeGroup() {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1);
        List groups = this.groupDAO.search(1L, query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_GROUP_1, EXISTING_GROUP_3, EXISTING_GROUP_4}));
    }

    @Test
    public void testSearchForActiveGroupsUsingBuilder() {
        PropertyRestriction booleanRestriction = Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)true);
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)booleanRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_1}));
    }

    @Test
    public void testSearchForInactiveGroupsUsingBuilder() {
        PropertyRestriction booleanRestriction = Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)false);
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)booleanRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_GROUP_3, EXISTING_GROUP_4}));
    }

    @Test
    public void testSearchCountryExact() {
        TermRestriction groupNameRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_AU);
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_1}));
    }

    @Test
    public void testSearchCountryNoResults() {
        TermRestriction groupNameRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)"canada");
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    @Test
    public void testSearchNullAttribute() {
        TermRestriction groupAttributeRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)LANGUAGE_ATTRIBUTE), MatchMode.NULL, null);
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupAttributeRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        Assert.assertEquals((long)2L, (long)groups.size());
    }

    @Test
    public void testSearchFirstClassDisjunction() {
        TermRestriction groupNameRestriction1 = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"a");
        TermRestriction groupNameRestriction2 = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"u");
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{groupNameRestriction1, groupNameRestriction2});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_1}));
    }

    @Test
    public void testSearchFirstClassConjunction() {
        TermRestriction groupNameRestriction = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"a");
        TermRestriction activeRestriction = new TermRestriction(GroupTermKeys.ACTIVE, (Object)true);
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{groupNameRestriction, activeRestriction});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_1}));
    }

    @Test
    public void testSearchSecondClassDisjunction() {
        TermRestriction countryRestriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_AU);
        TermRestriction countryRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)CITY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)CITY_VALUE_SYD);
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{countryRestriction1, countryRestriction2});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_GROUP_1, EXISTING_GROUP_3}));
    }

    @Test
    public void testSearchSecondClassConjunction() {
        TermRestriction countryRestriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_AU);
        TermRestriction countryRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_CN);
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{countryRestriction1, countryRestriction2});
        GroupQuery query = new GroupQuery(Group.class, GroupType.LEGACY_ROLE, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_2}));
    }

    @Test
    public void testSearchMixedClassDisjunction() {
        TermRestriction countryRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_AU);
        TermRestriction activeRestriction = new TermRestriction(GroupTermKeys.ACTIVE, (Object)false);
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{countryRestriction, activeRestriction});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_GROUP_1, EXISTING_GROUP_3, EXISTING_GROUP_4}));
    }

    @Test
    public void testSearchMixedClassConjunction() {
        TermRestriction cityRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)CITY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)CITY_VALUE_SYD);
        TermRestriction activeRestriction = new TermRestriction(GroupTermKeys.ACTIVE, (Object)true);
        BooleanRestrictionImpl groupNameConjuction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{cityRestriction, activeRestriction});
        GroupQuery query = new GroupQuery(Group.class, GroupType.LEGACY_ROLE, (SearchRestriction)groupNameConjuction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_2}));
    }

    @Test
    public void testSearchByDescription() {
        TermRestriction groupRestriction = new TermRestriction(GroupTermKeys.DESCRIPTION, MatchMode.EXACTLY_MATCHES, (Object)"The Crowd Crew");
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_3}));
    }

    @Test
    public void testSearchByDescriptionWithNoMatches() {
        TermRestriction groupRestriction = new TermRestriction(GroupTermKeys.DESCRIPTION, MatchMode.EXACTLY_MATCHES, (Object)"No group has this description");
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)groups, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testSearchNested() {
        TermRestriction cityRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)CITY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)CITY_VALUE_SYD);
        TermRestriction activeRestriction = new TermRestriction(GroupTermKeys.ACTIVE, (Object)true);
        BooleanRestrictionImpl conjunction1 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{cityRestriction, activeRestriction});
        TermRestriction countryRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_NZ);
        TermRestriction groupNameRestriction = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"a");
        BooleanRestrictionImpl conjunction2 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{countryRestriction, groupNameRestriction});
        BooleanRestrictionImpl nestedRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{conjunction1, conjunction2});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)nestedRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_GROUP_1}));
    }

    @Test
    public void testSearchByMixedName() {
        List results = this.groupDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"t")).returningAtMost(10));
        MatcherAssert.assertThat((Object)Groups.namesOf((Iterable)results), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"Testers"}));
    }

    @Test
    public void testSearchGroupsWithLocalTermDoesNotFail() {
        EntityQuery query = QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.LOCAL).exactlyMatching((Object)true)).returningAtMost(-1);
        List results = this.groupDAO.search(2L, query);
        Assert.assertEquals(Collections.emptyList(), (Object)results);
    }

    @Test
    public void testSearchGroupsWithLocalTermReturnsExpectedResults() throws Exception {
        this.groupDAO.addLocal((Group)new GroupTemplate("local-group", 1L));
        this.groupDAO.add((Group)new GroupTemplate("not-local-group", 1L));
        EntityQuery query = QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.LOCAL).exactlyMatching((Object)true)).returningAtMost(-1);
        List results = this.groupDAO.search(1L, query);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)((InternalGroup)results.get(0)).isLocal());
        Assert.assertEquals((Object)"local-group", (Object)((InternalGroup)results.get(0)).getName());
        query = QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.LOCAL).exactlyMatching((Object)false)).returningAtMost(-1);
        results = this.groupDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Matcher)new TypeSafeMatcher<InternalGroup>(){

            public void describeTo(Description description) {
                description.appendText("a non-local group called 'not-local-group'");
            }

            public boolean matchesSafely(InternalGroup item) {
                return !item.isLocal() && item.getName().equals("not-local-group");
            }
        }));
    }
}

