/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.group;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.Groups;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.test.matchers.CrowdMatchers;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.proxy.HibernateProxy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class GroupDAOHibernateTest {
    @Inject
    private GroupDAOHibernate groupDAO;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private static final long DIRECTORY_ID = 1L;
    private static final String EXISTING_GROUP_1 = "administratorS";
    private static final String EXISTING_ROLE_2 = "users";
    private static final String EXISTING_GROUP_3 = "developers";
    private static final String EXISTING_GROUP_4 = "Managers";
    private static final String NON_EXISTING_GROUP = "NewGroup";
    private static final String NON_EXISTING_GROUP_DESC = "New Group";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testFindByNameReturnsGroupWithLazyLoadedDirectory() throws Exception {
        InternalGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        Assert.assertTrue((boolean)((HibernateProxy)group.getDirectory()).getHibernateLazyInitializer().isUninitialized());
    }

    @Test
    public void testFindByNameMixedCase() throws Exception {
        InternalGroup group = this.groupDAO.findByName(2L, "teSterS");
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"Testers"), (Object)group.getLowerName());
    }

    @Test
    public void testFindByMixedCaseNameWithAttributes() throws Exception {
        InternalGroupWithAttributes group = this.groupDAO.findByNameWithAttributes(2L, "TestErs");
        Assert.assertEquals((Object)"testers", (Object)group.getInternalGroup().getLowerName());
    }

    @Test
    public void testAddAssignsAnId() throws Exception {
        InternalGroup createdGroup = this.createNewGroup(NON_EXISTING_GROUP);
        Assert.assertTrue((createdGroup.getId() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testAddLocalAssignsAnId() throws Exception {
        InternalGroup createdGroup = this.createNewLocalGroup(NON_EXISTING_GROUP);
        Assert.assertTrue((createdGroup.getId() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveAll() {
        this.groupDAO.removeAll(1L);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertTrue((boolean)this.groupDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(10)).isEmpty());
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_membership where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testRemoveAllGroups() {
        this.groupDAO.removeAllGroups(1L, (Set)ImmutableSet.of((Object)EXISTING_GROUP_1, (Object)EXISTING_GROUP_3));
        List groups = this.groupDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
        Assert.assertThat((Object)groups, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)CrowdMatchers.groupNamed((String)EXISTING_GROUP_1))));
        Assert.assertThat((Object)groups, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)CrowdMatchers.groupNamed((String)EXISTING_GROUP_3))));
        Assert.assertThat((Object)groups, (Matcher)Matchers.hasItem((Matcher)CrowdMatchers.groupNamed((String)EXISTING_GROUP_4)));
    }

    @Test
    public void testAddAllUsers() throws Exception {
        this.groupDAO.addAll((Set)ImmutableSet.of((Object)new GroupTemplate("new group 1", 1L, GroupType.GROUP), (Object)new GroupTemplate("new group 2", 1L, GroupType.GROUP)));
        List groups = this.groupDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
        Assert.assertThat((Object)groups, (Matcher)Matchers.hasItem((Matcher)CrowdMatchers.groupNamed((String)"new group 1")));
        Assert.assertThat((Object)groups, (Matcher)Matchers.hasItem((Matcher)CrowdMatchers.groupNamed((String)"new group 2")));
    }

    @Test
    public void testStoreAttributesWithInsertForNewGroup() throws Exception {
        InternalGroup createdGroup = this.createNewGroup(NON_EXISTING_GROUP);
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"Blue", "Green"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.groupDAO.storeAttributes((Group)createdGroup, attributes);
        InternalGroupWithAttributes returnedGroup = this.groupDAO.findByNameWithAttributes(1L, NON_EXISTING_GROUP.toUpperCase());
        Assert.assertEquals((long)2L, (long)returnedGroup.getKeys().size());
        Assert.assertEquals((long)2L, (long)returnedGroup.getValues("color").size());
        Assert.assertTrue((boolean)returnedGroup.getValues("color").contains("Blue"));
        Assert.assertTrue((boolean)returnedGroup.getValues("color").contains("Green"));
        Assert.assertEquals((long)1L, (long)returnedGroup.getValues("phone").size());
        Assert.assertTrue((boolean)returnedGroup.getValues("phone").contains("131111"));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("select attribute_lower_value from cwd_group_attribute where group_id = " + returnedGroup.getInternalGroup().getId());
        HashSet<String> lowerCaseAttributeValues = new HashSet<String>();
        while (sqlRowSet.next()) {
            lowerCaseAttributeValues.add(sqlRowSet.getString("attribute_lower_value"));
        }
        Assert.assertEquals((long)3L, (long)lowerCaseAttributeValues.size());
        Assert.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"Blue")));
        Assert.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"Green")));
        Assert.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"131111")));
    }

    @Test
    public void testFindByNames() {
        ArrayList groups = new ArrayList(this.groupDAO.findByNames(1L, Arrays.asList(EXISTING_GROUP_1, "bogus", EXISTING_GROUP_3)));
        Assert.assertThat((Object)Groups.namesOf(groups), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_GROUP_1, EXISTING_GROUP_3}));
    }

    private InternalGroup createNewGroup(String groupName) throws DirectoryNotFoundException, GroupNotFoundException, InvalidGroupException {
        GroupTemplate group = new GroupTemplate(groupName, 1L, GroupType.GROUP);
        group.setActive(true);
        group.setDescription(NON_EXISTING_GROUP_DESC);
        return this.groupDAO.add((Group)group);
    }

    private InternalGroup createNewLocalGroup(String groupName) throws DirectoryNotFoundException, GroupNotFoundException, InvalidGroupException {
        GroupTemplate group = new GroupTemplate(groupName, 1L, GroupType.GROUP);
        group.setActive(true);
        group.setDescription(NON_EXISTING_GROUP_DESC);
        return this.groupDAO.addLocal((Group)group);
    }
}

