/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.application;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.dao.application.ApplicationDAOHibernate;
import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.Applications;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.ApplicationTermKeys;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.SessionFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class ApplicationDAOHibernateTest {
    @Inject
    private ApplicationDAOHibernate applicationDAO;
    @Inject
    private DirectoryDAOHibernate directoryDAO;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private static final long APPLICATION_ID = 1L;
    private static final String APPLICATION_NAME_1 = "Crowd";
    private static final String APPLICATION_NAME_2 = "Application Too";
    private static final String APPLICATION_NAME_3 = "Third One";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testAddApplication() {
        Application application = ApplicationDAOHibernateTest.buildBambooApplication();
        ApplicationImpl returnedApplication = this.applicationDAO.add(application, new PasswordCredential("hello", true));
        this.sessionFactory.getCurrentSession().flush();
        Assert.assertNotNull((Object)returnedApplication);
        Assert.assertNotNull((Object)returnedApplication.getId());
        Assert.assertTrue((boolean)returnedApplication.isActive());
        Assert.assertEquals((Object)ApplicationType.BAMBOO, (Object)returnedApplication.getType());
        Assert.assertEquals((Object)"Bamboo App", (Object)returnedApplication.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"Bamboo App"), (Object)returnedApplication.getLowerName());
        Assert.assertNotNull((Object)returnedApplication.getCreatedDate());
        Assert.assertNotNull((Object)returnedApplication.getUpdatedDate());
        Assert.assertNull((Object)returnedApplication.getDescription());
        Assert.assertEquals((long)1L, (long)returnedApplication.getAttributes().size());
        Assert.assertTrue((boolean)returnedApplication.getDirectoryMappings().isEmpty());
        Assert.assertTrue((boolean)returnedApplication.getRemoteAddresses().isEmpty());
    }

    @Test(expected=ConstraintViolationException.class)
    public void testAddApplicationDuplicate() {
        ApplicationImpl application = ApplicationImpl.newInstance((String)APPLICATION_NAME_1, (ApplicationType)ApplicationType.CROWD);
        application.setActive(false);
        this.applicationDAO.add((Application)application, PasswordCredential.encrypted((String)"hello"));
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test(expected=NullPointerException.class)
    public void testAddApplicationIncomplete() {
        ApplicationImpl application = ApplicationImpl.newInstance((String)"some name", (ApplicationType)ApplicationType.GENERIC_APPLICATION);
        this.applicationDAO.add((Application)application, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddApplicationIncorrectPassword() {
        Application application = ApplicationDAOHibernateTest.buildBambooApplication();
        this.applicationDAO.add(application, new PasswordCredential("hello", false));
    }

    @Test
    public void testUpdateApplicationCredential() throws Exception {
        this.applicationDAO.updateCredential((Application)this.applicationDAO.findById(1L), PasswordCredential.encrypted((String)"encrypted-string"));
        ApplicationImpl updatedApplication = this.applicationDAO.findById(1L);
        Assert.assertEquals((Object)"encrypted-string", (Object)updatedApplication.getCredential().getCredential());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUpdateApplicationWithUnEncryptedCredential() throws Exception {
        this.applicationDAO.updateCredential((Application)this.applicationDAO.findById(1L), PasswordCredential.unencrypted((String)"encrypted-string"));
    }

    @Test(expected=NullPointerException.class)
    public void testAddApplicationWithNoPassword() {
        Application application = ApplicationDAOHibernateTest.buildBambooApplication();
        this.applicationDAO.add(application, null);
    }

    @Test
    public void testFindById() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertNotNull((Object)application.getId());
        Assert.assertEquals((Object)APPLICATION_NAME_1, (Object)application.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)APPLICATION_NAME_1), (Object)application.getLowerName());
        Assert.assertEquals((Object)"Crowd Security Server and Console", (Object)application.getDescription());
        Assert.assertEquals((Object)ApplicationType.CROWD, (Object)application.getType());
        Assert.assertTrue((boolean)application.isActive());
        Assert.assertEquals((Object)"h4$|-|3dp455w0r|)", (Object)application.getCredential().getCredential());
        Assert.assertEquals((Object)"Ten", (Object)application.getValue("Number"));
        Assert.assertEquals((Object)"Red", (Object)application.getValue("color"));
        Assert.assertEquals((long)2L, (long)application.getKeys().size());
        Assert.assertEquals((long)2L, (long)application.getDirectoryMappings().size());
        for (DirectoryMapping mapping : application.getDirectoryMappings()) {
            if (mapping.getDirectory().getId() == 1L) {
                Assert.assertEquals((long)3L, (long)mapping.getAuthorisedGroups().size());
                for (GroupMapping groupMapping : mapping.getAuthorisedGroups()) {
                    Assert.assertEquals((Object)application, (Object)groupMapping.getApplication());
                    Assert.assertEquals((Object)new Long(1L), (Object)groupMapping.getDirectory().getId());
                    Assert.assertTrue((boolean)Arrays.asList("administrators", "developers", "users").contains(groupMapping.getGroupName()));
                }
                Assert.assertEquals((long)2L, (long)mapping.getAllowedOperations().size());
                Assert.assertTrue((boolean)mapping.getAllowedOperations().contains(OperationType.CREATE_GROUP));
                Assert.assertTrue((boolean)mapping.getAllowedOperations().contains(OperationType.CREATE_USER));
                continue;
            }
            if (mapping.getDirectory().getId() == 2L) {
                Assert.assertEquals((long)1L, (long)mapping.getAuthorisedGroups().size());
                Assert.assertEquals((long)0L, (long)mapping.getAllowedOperations().size());
                continue;
            }
            Assert.fail((String)"Directory mapping not found");
        }
        Assert.assertEquals((long)3L, (long)application.getRemoteAddresses().size());
        for (RemoteAddress remoteAddress : application.getRemoteAddresses()) {
            Assert.assertTrue((boolean)Arrays.asList("127.0.0.1", "127.0.0.2", "127.0.0.3").contains(remoteAddress.getAddress()));
        }
    }

    @Test(expected=ApplicationNotFoundException.class)
    public void testFindByIdNotFound() throws Exception {
        this.applicationDAO.findById(-1L);
    }

    @Test
    public void testFindByName() throws Exception {
        ApplicationImpl application = this.applicationDAO.findByName(APPLICATION_NAME_2.toUpperCase());
        Assert.assertNotNull((Object)application.getId());
        Assert.assertEquals((Object)APPLICATION_NAME_2, (Object)application.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)APPLICATION_NAME_2), (Object)application.getLowerName());
        Assert.assertEquals((Object)"Another Simple Application", (Object)application.getDescription());
        Assert.assertEquals((Object)"hashmash", (Object)application.getCredential().getCredential());
        Assert.assertEquals((Object)ApplicationType.BAMBOO, (Object)application.getType());
        Assert.assertFalse((boolean)application.isActive());
        Assert.assertTrue((boolean)application.getAttributes().isEmpty());
        Assert.assertEquals((long)1L, (long)application.getDirectoryMappings().size());
        Assert.assertTrue((boolean)application.getRemoteAddresses().isEmpty());
    }

    @Test(expected=ApplicationNotFoundException.class)
    public void testFindByNameNotFound() throws Exception {
        this.applicationDAO.findByName("bogus");
    }

    @Test
    public void testUpdateApplicationByModifyingThePersistentInstance() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        application.setActive(false);
        application.setName("New Application");
        application.setCredential(new PasswordCredential("hashed-password", true));
        application.setType(ApplicationType.FISHEYE);
        application.setDescription(null);
        this.applicationDAO.update((Application)application);
        this.sessionFactory.getCurrentSession().flush();
        ApplicationImpl updatedApplication = this.applicationDAO.findById(1L);
        Assert.assertEquals((Object)"New Application", (Object)updatedApplication.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"New Application"), (Object)updatedApplication.getLowerName());
        Assert.assertNull((Object)updatedApplication.getDescription());
        Assert.assertEquals((Object)ApplicationType.FISHEYE, (Object)updatedApplication.getType());
        Assert.assertFalse((boolean)updatedApplication.isActive());
        Assert.assertEquals((Object)"Ten", (Object)updatedApplication.getValue("Number"));
        Assert.assertEquals((Object)"Red", (Object)updatedApplication.getValue("color"));
        Assert.assertEquals((long)2L, (long)updatedApplication.getKeys().size());
        Assert.assertEquals((long)2L, (long)updatedApplication.getDirectoryMappings().size());
        Assert.assertEquals((long)3L, (long)updatedApplication.getRemoteAddresses().size());
        Assert.assertEquals((Object)new PasswordCredential("hashed-password", true), (Object)updatedApplication.getCredential());
    }

    @Test
    public void testUpdateApplicationByUsingATransientTemplate() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        PasswordCredential originalCredential = application.getCredential();
        Assert.assertEquals((Object)new PasswordCredential("h4$|-|3dp455w0r|)", true), (Object)originalCredential);
        ApplicationImpl applicationImpl = ApplicationImpl.newInstance((Application)application);
        applicationImpl.setActive(false);
        applicationImpl.setName("New Application");
        applicationImpl.setCredential(new PasswordCredential("different-hashed-password", true));
        applicationImpl.setType(ApplicationType.FISHEYE);
        applicationImpl.setDescription(null);
        this.applicationDAO.update((Application)applicationImpl);
        this.sessionFactory.getCurrentSession().flush();
        ApplicationImpl updatedApplication = this.applicationDAO.findById(1L);
        Assert.assertEquals((Object)"New Application", (Object)updatedApplication.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"New Application"), (Object)updatedApplication.getLowerName());
        Assert.assertNull((Object)updatedApplication.getDescription());
        Assert.assertEquals((Object)ApplicationType.FISHEYE, (Object)updatedApplication.getType());
        Assert.assertFalse((boolean)updatedApplication.isActive());
        Assert.assertEquals((Object)"Ten", (Object)updatedApplication.getValue("Number"));
        Assert.assertEquals((Object)"Red", (Object)updatedApplication.getValue("color"));
        Assert.assertEquals((long)2L, (long)updatedApplication.getKeys().size());
        Assert.assertEquals((long)2L, (long)updatedApplication.getDirectoryMappings().size());
        Assert.assertEquals((long)3L, (long)updatedApplication.getRemoteAddresses().size());
        Assert.assertEquals((Object)originalCredential, (Object)updatedApplication.getCredential());
    }

    private DirectoryImpl loadDirectory(Long id) throws DirectoryNotFoundException {
        return this.directoryDAO.findById(id.longValue());
    }

    @Test
    public void testUpdateApplicationWithBellsAndWhistles() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        application.setActive(false);
        application.setName("New Application");
        application.setType(ApplicationType.BAMBOO);
        application.setDescription(null);
        application.setAttribute("Number", "one");
        DirectoryImpl dir = this.loadDirectory(3L);
        application.getDirectoryMappings().add(new DirectoryMapping((Application)application, (Directory)dir, true));
        application.getDirectoryMapping(1L).getAuthorisedGroups().clear();
        application.getDirectoryMapping(1L).getAllowedOperations().add(OperationType.DELETE_USER);
        application.addRemoteAddress("10.0.0.1");
        this.applicationDAO.update((Application)application);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        ApplicationImpl updatedApplication = this.applicationDAO.findById(1L);
        Assert.assertEquals((Object)"New Application", (Object)updatedApplication.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"New Application"), (Object)updatedApplication.getLowerName());
        Assert.assertNull((Object)updatedApplication.getDescription());
        Assert.assertEquals((Object)ApplicationType.BAMBOO, (Object)updatedApplication.getType());
        Assert.assertFalse((boolean)updatedApplication.isActive());
        Assert.assertEquals((Object)"one", (Object)updatedApplication.getValue("Number"));
        Assert.assertEquals((Object)"Red", (Object)updatedApplication.getValue("color"));
        Assert.assertEquals((long)2L, (long)updatedApplication.getKeys().size());
        Assert.assertEquals((long)3L, (long)updatedApplication.getDirectoryMappings().size());
        Assert.assertEquals((long)0L, (long)updatedApplication.getDirectoryMapping(1L).getAuthorisedGroups().size());
        Assert.assertEquals((long)3L, (long)updatedApplication.getDirectoryMapping(1L).getAllowedOperations().size());
        Assert.assertEquals((long)4L, (long)updatedApplication.getRemoteAddresses().size());
    }

    @Test
    public void testRemove() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        this.applicationDAO.remove((Application)application);
        this.sessionFactory.getCurrentSession().flush();
        try {
            this.applicationDAO.findById(1L);
            Assert.fail((String)"ApplicationNotFoundException expected");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAddDirectoryMapping() throws Exception {
        this.applicationDAO.addDirectoryMapping(1L, 3L, true, new OperationType[]{OperationType.CREATE_GROUP, OperationType.CREATE_USER, OperationType.CREATE_ROLE});
        this.sessionFactory.getCurrentSession().flush();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(3L);
        Assert.assertNotNull((Object)directoryMapping);
        Assert.assertNotNull((Object)directoryMapping.getId());
        Assert.assertEquals((Object)new Long(3L), (Object)directoryMapping.getDirectory().getId());
        Assert.assertTrue((boolean)directoryMapping.isAllowAllToAuthenticate());
        Assert.assertEquals((long)3L, (long)directoryMapping.getAllowedOperations().size());
        Assert.assertThat((Object)directoryMapping.getAllowedOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new OperationType[]{OperationType.CREATE_GROUP, OperationType.CREATE_USER, OperationType.CREATE_ROLE}));
    }

    @Test
    public void testAddGroupMapping() throws Exception {
        this.applicationDAO.addGroupMapping(1L, 2L, "testers");
        this.sessionFactory.getCurrentSession().flush();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(2L);
        Set authorisedGroups = directoryMapping.getAuthorisedGroups();
        Assert.assertEquals((long)2L, (long)authorisedGroups.size());
        Collection groupNames = Collections2.transform((Collection)authorisedGroups, (Function)new Function<GroupMapping, String>(){

            public String apply(GroupMapping groupMapping) {
                Assert.assertNotNull((Object)groupMapping.getId());
                return groupMapping.getGroupName();
            }
        });
        Assert.assertTrue((boolean)groupNames.containsAll(Sets.newHashSet((Object[])new String[]{"testers", "developers"})));
    }

    @Test
    public void testRemoveDirectoryMappingFromApplication() throws Exception {
        this.applicationDAO.removeDirectoryMapping(1L, 2L);
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertEquals((long)1L, (long)application.getDirectoryMappings().size());
    }

    @Test
    public void testRemoveDirectoryMappingFromApplicationMultipleApplications() throws Exception {
        this.applicationDAO.removeDirectoryMappings(2L);
        ApplicationImpl application1 = this.applicationDAO.findById(1L);
        Assert.assertEquals((long)1L, (long)application1.getDirectoryMappings().size());
        ApplicationImpl application2 = this.applicationDAO.findById(2L);
        Assert.assertEquals((long)0L, (long)application2.getDirectoryMappings().size());
    }

    @Test
    public void testRemoveGroupMapping() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertEquals((long)3L, (long)application.getDirectoryMapping(1L).getAuthorisedGroups().size());
        this.applicationDAO.removeGroupMapping(1L, 1L, "users");
        Assert.assertEquals((long)2L, (long)application.getDirectoryMapping(1L).getAuthorisedGroups().size());
        Assert.assertFalse((boolean)application.getDirectoryMapping(1L).isAuthorised("users"));
        Assert.assertTrue((boolean)application.getDirectoryMapping(1L).isAuthorised("developers"));
        Assert.assertTrue((boolean)application.getDirectoryMapping(1L).isAuthorised("administrators"));
    }

    @Test
    public void testAddAndThenRemoveAGroupMapping() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        this.applicationDAO.addGroupMapping(1L, 1L, "new-group");
        Assert.assertEquals((long)4L, (long)application.getDirectoryMapping(1L).getAuthorisedGroups().size());
        Assert.assertTrue((boolean)application.getDirectoryMapping(1L).isAuthorised("new-group"));
        this.applicationDAO.removeGroupMapping(1L, 1L, "new-group");
        Assert.assertEquals((long)3L, (long)application.getDirectoryMapping(1L).getAuthorisedGroups().size());
        Assert.assertFalse((boolean)application.getDirectoryMapping(1L).isAuthorised("new-group"));
    }

    @Test
    public void testRemoveAndThenAddAgainGroupMapping() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertEquals((long)3L, (long)application.getDirectoryMapping(1L).getAuthorisedGroups().size());
        this.applicationDAO.removeGroupMapping(1L, 1L, "users");
        Assert.assertEquals((long)2L, (long)application.getDirectoryMapping(1L).getAuthorisedGroups().size());
        Assert.assertFalse((boolean)application.getDirectoryMapping(1L).isAuthorised("users"));
        this.applicationDAO.addGroupMapping(1L, 1L, "users");
        Assert.assertTrue((boolean)application.getDirectoryMapping(1L).isAuthorised("users"));
        Assert.assertTrue((boolean)application.getDirectoryMapping(1L).isAuthorised("developers"));
        Assert.assertTrue((boolean)application.getDirectoryMapping(1L).isAuthorised("administrators"));
    }

    @Test
    public void testRemoveAllGroupMappingsForAGroup() throws Exception {
        this.applicationDAO.removeGroupMappings(2L, "developers");
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertFalse((boolean)application.getDirectoryMapping(2L).isAuthorised("developers"));
        ApplicationImpl application2 = this.applicationDAO.findById(2L);
        Assert.assertFalse((boolean)application2.getDirectoryMapping(2L).isAuthorised("developers"));
    }

    @Test
    public void testAddRemoteAddress() throws Exception {
        RemoteAddress remoteAddress = new RemoteAddress("192.168.1.1");
        this.applicationDAO.addRemoteAddress(1L, remoteAddress);
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertTrue((boolean)application.getRemoteAddresses().contains(remoteAddress));
    }

    @Test
    public void testRemoveRemoteAddress() throws Exception {
        RemoteAddress remoteAddress = new RemoteAddress("127.0.0.1");
        this.applicationDAO.removeRemoteAddress(1L, remoteAddress);
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertFalse((boolean)application.getRemoteAddresses().contains(remoteAddress));
    }

    @Test
    public void testUpdateDirectoryMappingPosition() throws Exception {
        this.applicationDAO.updateDirectoryMapping(1L, 2L, 0);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertEquals((long)2L, (long)((DirectoryMapping)application.getDirectoryMappings().get(0)).getDirectory().getId());
        Assert.assertEquals((long)1L, (long)((DirectoryMapping)application.getDirectoryMappings().get(1)).getDirectory().getId());
    }

    @Test
    public void testUpdateDirectoryMappingPositionWithNegativePosition() throws Exception {
        this.applicationDAO.updateDirectoryMapping(1L, 2L, -1);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertEquals((long)1L, (long)((DirectoryMapping)application.getDirectoryMappings().get(0)).getDirectory().getId());
        Assert.assertEquals((long)2L, (long)((DirectoryMapping)application.getDirectoryMappings().get(1)).getDirectory().getId());
    }

    @Test
    public void testUpdateDirectoryMappingPositionWithUnboundedPosition() throws Exception {
        this.applicationDAO.updateDirectoryMapping(1L, 1L, 3);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        Assert.assertEquals((long)1L, (long)((DirectoryMapping)application.getDirectoryMappings().get(0)).getDirectory().getId());
        Assert.assertEquals((long)2L, (long)((DirectoryMapping)application.getDirectoryMappings().get(1)).getDirectory().getId());
    }

    @Test
    public void testFindAuthorisedApplicationsMatchByGroup() {
        Long directoryId = 1L;
        List applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("users"));
        Assert.assertEquals((long)1L, (long)applications.size());
        Assert.assertEquals((Object)"crowd", (Object)((ApplicationImpl)applications.get(0)).getLowerName());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("administrators"));
        Assert.assertEquals((long)1L, (long)applications.size());
        Assert.assertEquals((Object)"crowd", (Object)((ApplicationImpl)applications.get(0)).getLowerName());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("developers"));
        Assert.assertEquals((long)1L, (long)applications.size());
        Assert.assertEquals((Object)"crowd", (Object)((ApplicationImpl)applications.get(0)).getLowerName());
    }

    @Test
    public void testFindAuthorisedApplicationsNoMatchByGroup() {
        Long directoryId = 1L;
        List applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("bogus"));
        Assert.assertEquals((long)0L, (long)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), new ArrayList());
        Assert.assertEquals((long)0L, (long)applications.size());
    }

    @Test
    public void testFindAuthorisedApplicationsMatchByDirectoryAllowAll() {
        Long directoryId = 2L;
        List applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("bogus"));
        Assert.assertEquals((long)1L, (long)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("administrators"));
        Assert.assertEquals((long)1L, (long)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), new ArrayList());
        Assert.assertEquals((long)1L, (long)applications.size());
    }

    @Test
    public void testFindAuthorisedApplicationsNoMatchByDirectoryAllowAll() {
        Long directoryId = 3L;
        List applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("bogus"));
        Assert.assertEquals((long)0L, (long)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("administrators"));
        Assert.assertEquals((long)0L, (long)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), new ArrayList());
        Assert.assertEquals((long)0L, (long)applications.size());
    }

    @Test
    public void testSearchAll() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).returningAtMost(10));
        Assert.assertThat((Object)Applications.namesOf((Iterable)applications), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{APPLICATION_NAME_1, APPLICATION_NAME_2, APPLICATION_NAME_3}));
    }

    @Test
    public void testSearchByNameStartingWith() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Restriction.on((Property)ApplicationTermKeys.NAME).startingWith((Object)"application")).returningAtMost(10));
        Assert.assertThat((Object)Applications.namesOf((Iterable)applications), (Matcher)Matchers.contains((Object[])new String[]{APPLICATION_NAME_2}));
    }

    @Test
    public void testSearchByNameContaining() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Restriction.on((Property)ApplicationTermKeys.NAME).containing((Object)"d")).returningAtMost(10));
        Assert.assertThat((Object)Applications.namesOf((Iterable)applications), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{APPLICATION_NAME_1, APPLICATION_NAME_3}));
    }

    @Test
    public void testSearchByActive() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Restriction.on((Property)ApplicationTermKeys.ACTIVE).exactlyMatching((Object)true)).returningAtMost(10));
        Assert.assertThat((Object)Applications.namesOf((Iterable)applications), (Matcher)Matchers.contains((Object[])new String[]{APPLICATION_NAME_1}));
    }

    @Test
    public void testSearchByType() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Restriction.on((Property)ApplicationTermKeys.TYPE).exactlyMatching((Object)ApplicationType.BAMBOO)).returningAtMost(10));
        Assert.assertThat((Object)Applications.namesOf((Iterable)applications), (Matcher)Matchers.contains((Object[])new String[]{APPLICATION_NAME_2}));
    }

    @Test
    public void testSearchNestedQuery() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)ApplicationTermKeys.NAME).startingWith((Object)"CR"), Restriction.on((Property)ApplicationTermKeys.ACTIVE).exactlyMatching((Object)true)}), Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)ApplicationTermKeys.ACTIVE).exactlyMatching((Object)false), Restriction.on((Property)ApplicationTermKeys.TYPE).exactlyMatching((Object)ApplicationType.BAMBOO)})})).returningAtMost(10));
        Assert.assertThat((Object)Applications.namesOf((Iterable)applications), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{APPLICATION_NAME_1, APPLICATION_NAME_2}));
    }

    private static Application buildBambooApplication() {
        return ApplicationImpl.newInstance((String)"Bamboo App", (ApplicationType)ApplicationType.BAMBOO);
    }
}

