/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.alias;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.dao.alias.AliasDAOHibernate;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.AliasTermKeys;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import java.util.List;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class AliasDAOHibernateTest {
    private static final Long APPLICATION1_ID = 1L;
    private static final Long APPLICATION2_ID = 2L;
    private static final String USER1 = "Robert";
    private static final String USER2 = "William";
    private static final String USER1_ALIAS1 = "bob";
    private static final String USER1_ALIAS2 = "Robbie";
    private static final String USER2_ALIAS = "BiLL";
    @Inject
    private AliasDAOHibernate aliasDAO;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private Application application1;
    private Application application2;

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Before
    public void createApplications() {
        InternalEntityTemplate template1 = new InternalEntityTemplate();
        template1.setId(APPLICATION1_ID);
        template1.setName("");
        InternalEntityTemplate template2 = new InternalEntityTemplate();
        template2.setId(APPLICATION2_ID);
        template2.setName("");
        this.application1 = new ApplicationImpl(template1);
        this.application2 = new ApplicationImpl(template2);
    }

    @Test
    public void testFindAliasByUsername() {
        String alias = this.aliasDAO.findAliasByUsername(this.application1, USER1);
        Assert.assertEquals((Object)USER1_ALIAS1, (Object)alias);
        alias = this.aliasDAO.findAliasByUsername(this.application2, USER1.toUpperCase());
        Assert.assertEquals((Object)USER1_ALIAS2, (Object)alias);
        alias = this.aliasDAO.findAliasByUsername(this.application1, USER2);
        Assert.assertEquals((Object)USER2_ALIAS, (Object)alias);
    }

    @Test
    public void testFindAliasByUsernameNotFound() {
        String alias = this.aliasDAO.findAliasByUsername(this.application1, "bleh");
        Assert.assertNull((Object)alias);
        alias = this.aliasDAO.findAliasByUsername(this.application2, USER2);
        Assert.assertNull((Object)alias);
    }

    @Test
    public void testFindUsernameByAlias() {
        String username = this.aliasDAO.findUsernameByAlias(this.application1, USER1_ALIAS1);
        Assert.assertEquals((Object)USER1, (Object)username);
        username = this.aliasDAO.findUsernameByAlias(this.application2, USER1_ALIAS2.toUpperCase());
        Assert.assertEquals((Object)USER1, (Object)username);
        username = this.aliasDAO.findUsernameByAlias(this.application1, USER2_ALIAS);
        Assert.assertEquals((Object)USER2, (Object)username);
    }

    @Test
    public void testFindUsernameByAliasNotFound() {
        String username = this.aliasDAO.findUsernameByAlias(this.application1, "bleh");
        Assert.assertNull((Object)username);
        username = this.aliasDAO.findUsernameByAlias(this.application2, USER2_ALIAS);
        Assert.assertNull((Object)username);
    }

    @Test
    public void testStoreAliasNew() {
        String username = "Yahya";
        String alias = "John";
        Assert.assertNull((Object)this.aliasDAO.findAliasByUsername(this.application1, username));
        Assert.assertNull((Object)this.aliasDAO.findUsernameByAlias(this.application1, alias));
        this.aliasDAO.storeAlias(this.application1, username, alias);
        Assert.assertEquals((Object)alias, (Object)this.aliasDAO.findAliasByUsername(this.application1, username.toUpperCase()));
        Assert.assertEquals((Object)username, (Object)this.aliasDAO.findUsernameByAlias(this.application1, alias.toUpperCase()));
    }

    @Test
    public void testStoreAliasUpdate() {
        String username = USER1;
        String oldAlias = USER1_ALIAS1;
        String newAlias = "aWesome";
        Assert.assertEquals((Object)oldAlias, (Object)this.aliasDAO.findAliasByUsername(this.application1, username.toUpperCase()));
        Assert.assertEquals((Object)username, (Object)this.aliasDAO.findUsernameByAlias(this.application1, oldAlias.toUpperCase()));
        Assert.assertNull((Object)this.aliasDAO.findUsernameByAlias(this.application1, newAlias.toUpperCase()));
        this.aliasDAO.storeAlias(this.application1, username, newAlias);
        Assert.assertEquals((Object)newAlias, (Object)this.aliasDAO.findAliasByUsername(this.application1, username.toUpperCase()));
        Assert.assertEquals((Object)username, (Object)this.aliasDAO.findUsernameByAlias(this.application1, newAlias.toUpperCase()));
        Assert.assertNull((Object)this.aliasDAO.findUsernameByAlias(this.application1, oldAlias.toUpperCase()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreAliasInvalid() {
        this.aliasDAO.storeAlias(this.application1, USER1, "");
    }

    @Test
    public void testRemoveAlias() {
        Assert.assertEquals((Object)USER1_ALIAS1, (Object)this.aliasDAO.findAliasByUsername(this.application1, USER1));
        Assert.assertEquals((Object)USER1, (Object)this.aliasDAO.findUsernameByAlias(this.application1, USER1_ALIAS1));
        this.aliasDAO.removeAlias(this.application1, USER1);
        Assert.assertNull((Object)this.aliasDAO.findAliasByUsername(this.application1, USER1));
        Assert.assertNull((Object)this.aliasDAO.findUsernameByAlias(this.application1, USER1_ALIAS1));
    }

    @Test
    public void testRemoveAliasSilentlySucceed() {
        String username = "user3";
        Assert.assertNull((Object)this.aliasDAO.findAliasByUsername(this.application1, username));
        this.aliasDAO.removeAlias(this.application1, username);
        Assert.assertNull((Object)this.aliasDAO.findAliasByUsername(this.application1, username));
    }

    @Test
    public void testRemoveAliases() {
        String countAliasQuery = "select count(*) from cwd_application_alias where application_id = ?";
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_application_alias where application_id = ?", Integer.class, new Object[]{APPLICATION1_ID}), (Matcher)Matchers.is((Object)2));
        this.aliasDAO.removeAliases(this.application1);
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_application_alias where application_id = ?", Integer.class, new Object[]{APPLICATION1_ID}), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_application_alias where application_id = ?", Integer.class, new Object[]{APPLICATION2_ID}), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testFindAll() {
        List aliases = this.aliasDAO.findAll();
        Assert.assertEquals((long)3L, (long)aliases.size());
    }

    @Test
    public void testSearchByNameContainingWithMixedCase() {
        List matchingUsernames = this.aliasDAO.search(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.alias()).with((SearchRestriction)Restriction.on((Property)AliasTermKeys.ALIAS).containing((Object)"IL")).returningAtMost(10));
        Assert.assertThat((Object)matchingUsernames, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{USER2}));
    }

    @Test
    public void testSearchByNameContainingAndApplication() {
        List matchingUsernames = this.aliasDAO.search(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.alias()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)AliasTermKeys.ALIAS).containing((Object)"ob"), Restriction.on((Property)AliasTermKeys.APPLICATION_ID).exactlyMatching((Object)1L)})).returningAtMost(10));
        Assert.assertThat((Object)matchingUsernames, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{USER1}));
    }
}

