/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory.suite;

import com.atlassian.crowd.acceptance.harness.CrowdDirectoryTestHarness;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.BasicTest;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RFC2307Directory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public abstract class Rfc2307Test
extends BaseTest {
    public static final String CONFIG_FILE = "localhost-apacheDS-rfc2307.properties";

    public static Test suite() {
        TestSuite suite = new TestSuite();
        InputStream in = CrowdDirectoryTestHarness.class.getResourceAsStream("/com/atlassian/crowd/acceptance/tests/rfc2307-entries.ldif");
        Rfc2307Test.assertNotNull((Object)in);
        suite.addTest(new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).createRestoreTest(in));
        suite.addTestSuite(Rfc2307SynchronisationTest.class);
        suite.addTestSuite(Rfc2307QueryForNamesTest.class);
        return suite;
    }

    public Rfc2307Test() {
        this.setDirectoryConfigFile(CONFIG_FILE);
    }

    @Override
    protected void loadTestData() throws Exception {
    }

    @Override
    protected void removeTestData() throws DirectoryInstantiationException {
        DirectoryTestHelper.silentlyRemoveUser("root", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveGroup("wheel", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveGroup("users", this.getRemoteDirectory());
    }

    public static class Rfc2307QueryForNamesTest
    extends Rfc2307Test {
        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", "false");
        }

        private RFC2307Directory getImplementation() throws DirectoryInstantiationException {
            return (RFC2307Directory)BasicTest.getImplementation((Directory)this.directory);
        }

        public void testGettingGroupMembershipsForUserByName() throws Exception {
            List rootGroups = this.getImplementation().searchGroupRelationships(QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.user(), (String)"root"));
            Assert.assertThat((Object)rootGroups, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"wheel", "users"}));
            List userGroups = this.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("user").returningAtMost(10));
            Rfc2307QueryForNamesTest.assertEquals((Object)ImmutableList.of((Object)"users"), (Object)userGroups);
        }

        public void testGettingGroupMembershipsForUnknownUserGivesEmptyIterable() throws Exception {
            MembershipQuery query = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.user(), (String)"no-such-user");
            List groups = this.getImplementation().searchGroupRelationships(query);
            Assert.assertThat((Object)groups, (Matcher)Matchers.emptyIterable());
        }

        public void testGettingGroupMembershipsForGroupGivesEmptyIterableBecauseNoNestedGroups() throws Exception {
            MembershipQuery query = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)"users");
            List groups = this.getImplementation().searchGroupRelationships(query);
            Assert.assertThat((Object)groups, (Matcher)Matchers.emptyIterable());
        }

        public void testGettingMembersOfGroupReturnsResults() throws Exception {
            MembershipQuery queryMembersOfUsersGroup = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)"users");
            List usersUsers = this.getImplementation().searchGroupRelationships(queryMembersOfUsersGroup);
            Assert.assertThat((Object)usersUsers, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"user", "root"}));
            MembershipQuery queryMembersOfWheelGroup = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)"wheel");
            List wheelUsers = this.getImplementation().searchGroupRelationships(queryMembersOfWheelGroup);
            Assert.assertThat((Object)wheelUsers, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"root"}));
        }
    }

    public static class Rfc2307SynchronisationTest
    extends Rfc2307Test {
        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
        }

        public void testSynchroniseUsersAndGroups() throws Exception {
            DbCachingRemoteDirectory internalDirectory = (DbCachingRemoteDirectory)BasicTest.getImplementation((Directory)this.directory);
            internalDirectory.synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
            User root = internalDirectory.findUserByName("root");
            Rfc2307SynchronisationTest.assertEquals((String)"Root User", (String)root.getDisplayName());
            User user = internalDirectory.findUserByName("user");
            Rfc2307SynchronisationTest.assertEquals((String)"Regular User", (String)user.getDisplayName());
            Rfc2307SynchronisationTest.assertNotNull((Object)internalDirectory.findGroupByName("wheel"));
            Rfc2307SynchronisationTest.assertNotNull((Object)internalDirectory.findGroupByName("users"));
            List groups = internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("root").returningAtMost(10));
            Assert.assertThat((Object)groups, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"wheel", "users"}));
            groups = internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("user").returningAtMost(10));
            Rfc2307SynchronisationTest.assertEquals((Object)ImmutableList.of((Object)"users"), (Object)groups);
        }
    }
}

