/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory.suite;

import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.BasicTest;
import com.atlassian.crowd.acceptance.tests.directory.GroupRoleTest;
import com.atlassian.crowd.acceptance.tests.directory.LocalAttributesTest;
import com.atlassian.crowd.acceptance.tests.directory.LocalGroupsTest;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.acceptance.tests.directory.NestedGroupsTest;
import com.atlassian.crowd.acceptance.tests.directory.PageAndRangeTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ApacheDS154Test
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(LdifLoaderForTesting.createRestoreTest(ApacheDS154Test.class, "/com/atlassian/crowd/acceptance/tests/default-entries.ldif"));
        suite.addTestSuite(ApacheDS154BasicTest.class);
        suite.addTestSuite(ApacheDS154GroupRoleTest.class);
        suite.addTestSuite(ApacheDS154LocalAttributesTest.class);
        suite.addTestSuite(ApacheDS154LocalGroupsTest.class);
        suite.addTest(LdifLoaderForTesting.createRestoreTest(ApacheDS154Test.class, "ApacheDS154Test-non-cn-name-entries.ldif"));
        suite.addTestSuite(SynchroniseMembershipsWithNonCnAttributeForGroupNames.class);
        return suite;
    }

    public static class SynchroniseMembershipsWithNonCnAttributeForGroupNames
    extends BaseTest {
        public SynchroniseMembershipsWithNonCnAttributeForGroupNames() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }

        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
            this.directory.setAttribute("ldap.group.name", "ou");
        }

        @Override
        protected void loadTestData() throws Exception {
        }

        @Override
        protected void removeTestData() {
        }

        public void testSynchroniseUsersAndGroups() throws Exception {
            DbCachingRemoteDirectory internalDirectory = (DbCachingRemoteDirectory)BasicTest.getImplementation((Directory)this.directory);
            internalDirectory.synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
            User user1 = internalDirectory.findUserByName("user1");
            SynchroniseMembershipsWithNonCnAttributeForGroupNames.assertNotNull((Object)user1);
            SynchroniseMembershipsWithNonCnAttributeForGroupNames.assertNotNull((Object)internalDirectory.findGroupByName("group-full-name"));
            List groups = internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("user1").returningAtMost(10));
            SynchroniseMembershipsWithNonCnAttributeForGroupNames.assertEquals((Object)ImmutableSet.of((Object)"group-full-name"), (Object)ImmutableSet.copyOf((Collection)groups));
        }
    }

    public static class ApacheDS154LocalGroupsTest
    extends LocalGroupsTest {
        public ApacheDS154LocalGroupsTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }
    }

    public static class ApacheDS154LocalAttributesTest
    extends LocalAttributesTest {
        public ApacheDS154LocalAttributesTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }
    }

    public static class ApacheDS154GroupRoleTest
    extends GroupRoleTest {
        public ApacheDS154GroupRoleTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }
    }

    public static class ApacheDS154PageAndRangeTest
    extends PageAndRangeTest {
        public ApacheDS154PageAndRangeTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }
    }

    public static class ApacheDS154NestedGroupsTest
    extends NestedGroupsTest {
        public ApacheDS154NestedGroupsTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }

        @Override
        protected int getInitialGroupMemberCount() {
            return 0;
        }
    }

    public static class ApacheDS154BasicTest
    extends BasicTest {
        public ApacheDS154BasicTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }

        @Override
        public void testAuthenticateAfterPasswordUpdate() {
            ApacheDS154BasicTest.assertTrue((boolean)true);
        }
    }
}

