/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.service.client.AbstractClientProperties;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.factory.CrowdClientFactory;
import com.atlassian.crowd.util.PasswordHelper;
import com.atlassian.crowd.util.PasswordHelperImpl;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;

public class RemoteCrowdDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String APPLICATION_NAME = "crowd";
    private static final String APPLICATION_PASSWORD = "qybhDMZh";
    private static final String DEFAULT_USERNAME = "admin";
    private static final String USERNAME1 = "admin";
    private static final String USERNAME2 = "eeeep";
    private static final String MR_TRAILING_SPACES = "mr trailing spaces    ";
    private static final String GROUP1 = "badgers";
    private static final String GROUP2 = "crowd-administrators";
    private static final String GROUP3 = "crowd-testers";
    private static final String GROUP4 = "crowd-users";
    private static final String TEST_USERNAME = "eeeep";
    private static final String TEST_USER_PASSWORD = "abc123";
    private static final String BAD_USER_PASSWORD = "badpassword";
    private static final String TEST_GROUP = "badgers";
    private static final String NON_EXISTENT_USERNAME = "errorName";
    private static final String NON_EXISTENT_GROUP = "errorGroup";
    private static final String NEW_PASSWORD = "newpassword";
    private static final String NEW_DISPLAY_NAME = "New Display Name";
    private static final String NEW_FIRST_NAME = "New First Name";
    private static final String NEW_LAST_NAME = "New Last Name";
    private static final String NEW_EMAIL = "newemail@example.com";
    private static final String NEW_GROUP = "newgroup";
    private static final String NEW_GROUP_DESCRIPTION = "New group description";
    private static final List<String> ALL_USER_NAMES = Arrays.asList("admin", "eeeep", "penny", "regularuser", "secondadmin", "mr trailing spaces    ");
    private static final List<String> ALL_GROUP_NAMES = Arrays.asList("animals", "badgers", "birds", "cats", "crowd-administrators", "crowd-testers", "crowd-users", "dogs");
    private Map<String, String> attributes;
    private RemoteCrowdDirectory remoteDirectory;
    private CrowdClientFactory restClientFactory;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("remotecrowddirectory.xml");
        this.restClientFactory = new RestCrowdClientFactory();
        this.remoteDirectory = this.newRemoteCrowdDirectoryForTest(this.restClientFactory);
        this.remoteDirectory.setDirectoryId(1L);
        this.attributes = new HashMap<String, String>();
        this.attributes.put("crowd.server.url", HOST_PATH);
        this.attributes.put("application.name", APPLICATION_NAME);
        this.attributes.put("application.password", APPLICATION_PASSWORD);
        this.remoteDirectory.setAttributes(this.attributes);
    }

    RemoteCrowdDirectory newRemoteCrowdDirectoryForTest(CrowdClientFactory restClientFactory) {
        return new RemoteCrowdDirectory(restClientFactory, (PasswordHelper)new PasswordHelperImpl()){

            protected ClientProperties getClientProperties() {
                return new FixedClientProperties(this.getValue("crowd.server.url"), this.getValue("application.name"), this.getValue("application.password"), this.getValue("crowd.server.http.timeout"), this.getValue("crowd.server.http.max.connections"), this.getValue("crowd.server.http.proxy.host"), this.getValue("crowd.server.http.proxy.port"), this.getValue("crowd.server.http.proxy.username"), this.getValue("crowd.server.http.proxy.password"));
            }
        };
    }

    public void testBadClientParameters() throws UserNotFoundException, GroupNotFoundException {
        RemoteCrowdDirectory badRemoteDir = this.newRemoteCrowdDirectoryForTest(this.restClientFactory);
        badRemoteDir.setAttributes((Map)ImmutableMap.of());
        try {
            badRemoteDir.findUserByName("blah");
            RemoteCrowdDirectoryTest.fail((String)"OperationFailedException expected");
        }
        catch (OperationFailedException e) {
            // empty catch block
        }
        try {
            badRemoteDir.findGroupByName("hoho");
            RemoteCrowdDirectoryTest.fail((String)"OperationFailedException expected");
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    public void testConnection() throws OperationFailedException {
        this.remoteDirectory.testConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidConnections() throws OperationFailedException {
        RemoteCrowdDirectory badDirectory = this.newRemoteCrowdDirectoryForTest(this.restClientFactory);
        badDirectory.setDirectoryId(1L);
        this.attributes = new HashMap<String, String>();
        this.attributes.put("crowd.server.url", "http://badhost.priv:2388/crowd");
        this.attributes.put("application.name", APPLICATION_NAME);
        this.attributes.put("application.password", APPLICATION_PASSWORD);
        badDirectory.setAttributes(this.attributes);
        try {
            badDirectory.testConnection();
            RemoteCrowdDirectoryTest.fail((String)"Should not get a good test of 'badhost.priv'");
        }
        catch (OperationFailedException e) {}
        badDirectory = this.newRemoteCrowdDirectoryForTest(this.restClientFactory);
        badDirectory.setDirectoryId(1L);
        this.attributes = new HashMap<String, String>();
        this.attributes.put("crowd.server.url", HOST_PATH);
        this.attributes.put("application.name", "badapplication");
        this.attributes.put("application.password", APPLICATION_PASSWORD);
        badDirectory.setAttributes(this.attributes);
        try {
            badDirectory.testConnection();
            RemoteCrowdDirectoryTest.fail((String)"Should not get a good test using 'badapplication'");
        }
        catch (OperationFailedException e) {
            // empty catch block
        }
        badDirectory = this.newRemoteCrowdDirectoryForTest(this.restClientFactory);
        badDirectory.setDirectoryId(1L);
        this.attributes = new HashMap<String, String>();
        this.attributes.put("crowd.server.url", HOST_PATH);
        this.attributes.put("application.name", APPLICATION_NAME);
        this.attributes.put("application.password", "badpass");
        badDirectory.setAttributes(this.attributes);
        try {
            badDirectory.testConnection();
            RemoteCrowdDirectoryTest.fail((String)"Should not get a good test using 'badpass'");
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    public void testFindUserByName() throws Exception {
        User user = this.remoteDirectory.findUserByName("admin");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"admin", (String)user.getName());
    }

    public void testFindUserWithSpacesInName() throws Exception {
        UserWithAttributes user = this.remoteDirectory.findUserWithAttributesByName(MR_TRAILING_SPACES);
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)MR_TRAILING_SPACES, (String)user.getName());
        RemoteCrowdDirectoryTest.assertEquals((String)"user should have an attribute", (String)"false", (String)user.getValue("requiresPasswordChange"));
    }

    public void testFindUserByNameNotFound() throws OperationFailedException {
        try {
            this.remoteDirectory.findUserByName(NON_EXISTENT_USERNAME);
            RemoteCrowdDirectoryTest.fail((String)"User 'errorName' does not exist, but we found him anyway. That's bad");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testFindUserWithAttributesByName() throws Exception {
        UserWithAttributes user = this.remoteDirectory.findUserWithAttributesByName("admin");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"admin", (String)user.getName());
        RemoteCrowdDirectoryTest.assertNotNull((Object)user.getValue("requiresPasswordChange"));
        RemoteCrowdDirectoryTest.assertEquals((String)"false", (String)user.getValue("requiresPasswordChange"));
    }

    public void testFindUserWithAttributesByNameNotFound() throws OperationFailedException {
        try {
            this.remoteDirectory.findUserWithAttributesByName(NON_EXISTENT_USERNAME);
            RemoteCrowdDirectoryTest.fail((String)"User 'errorName' does not exist, but we found him anyway. That's bad");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testAddActiveUser() throws Exception {
        this.intendToModifyData();
        UserTemplate userTemplate = new UserTemplate("newuser", 1L);
        userTemplate.setActive(true);
        userTemplate.setDisplayName("New User via REST");
        userTemplate.setFirstName("New");
        userTemplate.setLastName("User");
        userTemplate.setEmailAddress("newuser@example.com");
        User user = this.remoteDirectory.addUser(userTemplate, new PasswordCredential("password"));
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"newuser", (String)user.getName());
        UserWithAttributes addedUser = this.remoteDirectory.findUserWithAttributesByName("newuser");
        RemoteCrowdDirectoryTest.assertNotNull((Object)addedUser);
        RemoteCrowdDirectoryTest.assertEquals((String)"newuser", (String)addedUser.getName());
        RemoteCrowdDirectoryTest.assertTrue((boolean)addedUser.isActive());
        RemoteCrowdDirectoryTest.assertEquals((String)"New User via REST", (String)addedUser.getDisplayName());
        RemoteCrowdDirectoryTest.assertEquals((String)"New", (String)addedUser.getFirstName());
        RemoteCrowdDirectoryTest.assertEquals((String)"User", (String)addedUser.getLastName());
        RemoteCrowdDirectoryTest.assertEquals((String)"newuser@example.com", (String)addedUser.getEmailAddress());
    }

    public void testAddInactiveUser() throws Exception {
        this.intendToModifyData();
        UserTemplate userTemplate = new UserTemplate("newuser", 1L);
        userTemplate.setActive(false);
        userTemplate.setDisplayName("New User via REST");
        userTemplate.setFirstName("New");
        userTemplate.setLastName("User");
        userTemplate.setEmailAddress("newuser@example.com");
        User user = this.remoteDirectory.addUser(userTemplate, new PasswordCredential("password"));
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"newuser", (String)user.getName());
        UserWithAttributes addedUser = this.remoteDirectory.findUserWithAttributesByName("newuser");
        RemoteCrowdDirectoryTest.assertNotNull((Object)addedUser);
        RemoteCrowdDirectoryTest.assertEquals((String)"newuser", (String)addedUser.getName());
        RemoteCrowdDirectoryTest.assertFalse((boolean)addedUser.isActive());
        RemoteCrowdDirectoryTest.assertEquals((String)"New User via REST", (String)addedUser.getDisplayName());
        RemoteCrowdDirectoryTest.assertEquals((String)"New", (String)addedUser.getFirstName());
        RemoteCrowdDirectoryTest.assertEquals((String)"User", (String)addedUser.getLastName());
        RemoteCrowdDirectoryTest.assertEquals((String)"newuser@example.com", (String)addedUser.getEmailAddress());
    }

    public void testAddUserNoPassword() throws Exception {
        UserTemplate userTemplate = new UserTemplate("newuser", 1L);
        userTemplate.setActive(true);
        userTemplate.setDisplayName("New User via REST");
        userTemplate.setFirstName("New");
        userTemplate.setLastName("User");
        userTemplate.setEmailAddress("newuser@example.com");
        try {
            this.remoteDirectory.addUser(userTemplate, new PasswordCredential(""));
            RemoteCrowdDirectoryTest.fail((String)"Should not be able to create a user with an empty password");
        }
        catch (InvalidCredentialException invalidCredentialException) {
            // empty catch block
        }
    }

    public void testAddUserDuplicate() throws Exception {
        this.intendToModifyData();
        UserTemplate userTemplate = new UserTemplate("newuser", 1L);
        userTemplate.setActive(true);
        userTemplate.setDisplayName("New User via REST");
        userTemplate.setFirstName("New");
        userTemplate.setLastName("User");
        userTemplate.setEmailAddress("newuser@example.com");
        User user = this.remoteDirectory.addUser(userTemplate, new PasswordCredential("password"));
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"newuser", (String)user.getName());
        try {
            user = this.remoteDirectory.addUser(userTemplate, new PasswordCredential("password"));
            RemoteCrowdDirectoryTest.fail((String)"Should not be able to create a user with the same name as one that already exists");
        }
        catch (InvalidUserException invalidUserException) {
            // empty catch block
        }
    }

    public void testUpdateUser() throws Exception {
        this.intendToModifyData();
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertTrue((boolean)user.isActive());
        RemoteCrowdDirectoryTest.assertEquals((String)"eeeep", (String)user.getName());
        UserTemplate userTemplate = new UserTemplate(user);
        userTemplate.setActive(false);
        userTemplate.setDisplayName(NEW_DISPLAY_NAME);
        userTemplate.setFirstName(NEW_FIRST_NAME);
        userTemplate.setLastName(NEW_LAST_NAME);
        userTemplate.setEmailAddress(NEW_EMAIL);
        User updatedUser = this.remoteDirectory.updateUser(userTemplate);
        updatedUser = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertFalse((boolean)updatedUser.isActive());
        RemoteCrowdDirectoryTest.assertEquals((String)"eeeep", (String)updatedUser.getName());
        RemoteCrowdDirectoryTest.assertEquals((String)NEW_DISPLAY_NAME, (String)updatedUser.getDisplayName());
        RemoteCrowdDirectoryTest.assertEquals((String)NEW_FIRST_NAME, (String)updatedUser.getFirstName());
        RemoteCrowdDirectoryTest.assertEquals((String)NEW_LAST_NAME, (String)updatedUser.getLastName());
        RemoteCrowdDirectoryTest.assertEquals((String)NEW_EMAIL, (String)updatedUser.getEmailAddress());
    }

    public void testUpdateUserNotFound() throws Exception {
        UserTemplate userTemplate = new UserTemplate(NON_EXISTENT_USERNAME, 1L);
        userTemplate.setActive(true);
        userTemplate.setDisplayName(NEW_DISPLAY_NAME);
        userTemplate.setFirstName(NEW_FIRST_NAME);
        userTemplate.setLastName(NEW_LAST_NAME);
        userTemplate.setEmailAddress(NEW_EMAIL);
        try {
            this.remoteDirectory.updateUser(userTemplate);
            RemoteCrowdDirectoryTest.fail((String)"User 'errorName' does not exist, but we found him anyway. That's bad");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUser() throws Exception {
        this.intendToModifyData();
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        this.remoteDirectory.removeUser("eeeep");
        try {
            this.remoteDirectory.findUserWithAttributesByName("eeeep");
            RemoteCrowdDirectoryTest.fail((String)"User 'eeeep' was removed, but we found him anyway. That's bad");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUserBadUser() throws Exception {
        try {
            this.remoteDirectory.removeUser(NON_EXISTENT_USERNAME);
            RemoteCrowdDirectoryTest.fail((String)"User 'errorName' does not exist, but we found him anyway. That's bad");
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        UserWithAttributes userWithAttributes = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertEquals((String)"eeeep", (String)userWithAttributes.getName());
    }

    public void testAuthenticate() throws Exception {
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"eeeep", (String)user.getName());
        User authUser = this.remoteDirectory.authenticate(user.getName(), PasswordCredential.unencrypted((String)TEST_USER_PASSWORD));
        RemoteCrowdDirectoryTest.assertEquals((Object)user, (Object)authUser);
    }

    public void testAuthenticateBadPassword() throws Exception {
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"eeeep", (String)user.getName());
        try {
            this.remoteDirectory.authenticate(user.getName(), PasswordCredential.unencrypted((String)BAD_USER_PASSWORD));
            RemoteCrowdDirectoryTest.fail((String)"Should not have authenticated user with a wrong password");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticateNoUser() throws Exception {
        try {
            this.remoteDirectory.authenticate(NON_EXISTENT_USERNAME, PasswordCredential.unencrypted((String)TEST_USER_PASSWORD));
            RemoteCrowdDirectoryTest.fail((String)"Authenticating non-existent user should have resulted in an UserNotFoundException being thrown");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testUpdateUserPassword() throws Exception {
        this.intendToModifyData();
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"eeeep", (String)user.getName());
        this.remoteDirectory.updateUserCredential(user.getName(), PasswordCredential.unencrypted((String)NEW_PASSWORD));
        this.remoteDirectory.authenticate(user.getName(), PasswordCredential.unencrypted((String)NEW_PASSWORD));
        try {
            this.remoteDirectory.authenticate(user.getName(), PasswordCredential.unencrypted((String)TEST_USER_PASSWORD));
            RemoteCrowdDirectoryTest.fail((String)"Should not be able to authenticate user with old password");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testStoreUserAttributes() throws Exception {
        this.intendToModifyData();
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        RemoteCrowdDirectoryTest.assertEquals((String)"eeeep", (String)user.getName());
        HashMap<String, HashSet> userAttributes = new HashMap<String, HashSet>();
        userAttributes.put("colour", Sets.newHashSet((Object[])new String[]{"blue"}));
        userAttributes.put("phone-number", Sets.newHashSet((Object[])new String[]{"555-555-555"}));
        userAttributes.put("preferred-beers", Sets.newHashSet((Object[])new String[]{"vb", "xxxx", "crown"}));
        this.remoteDirectory.storeUserAttributes(user.getName(), userAttributes);
        UserWithAttributes userWithAttributes = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertEquals((String)"blue", (String)userWithAttributes.getValue("colour"));
        RemoteCrowdDirectoryTest.assertEquals((String)"555-555-555", (String)userWithAttributes.getValue("phone-number"));
        Set beers = userWithAttributes.getValues("preferred-beers");
        RemoteCrowdDirectoryTest.assertEquals((int)3, (int)beers.size());
        RemoteCrowdDirectoryTest.assertTrue((boolean)beers.contains("vb"));
        RemoteCrowdDirectoryTest.assertTrue((boolean)beers.contains("xxxx"));
        RemoteCrowdDirectoryTest.assertTrue((boolean)beers.contains("crown"));
    }

    public void testStoreUserAttributesEmptySet() throws Exception {
        this.intendToModifyData();
        UserWithAttributes userWithAttributes = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertEquals((String)"false", (String)userWithAttributes.getValue("requiresPasswordChange"));
        HashMap userAttributes = new HashMap();
        this.remoteDirectory.storeUserAttributes("eeeep", userAttributes);
        userWithAttributes = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertEquals((String)"false", (String)userWithAttributes.getValue("requiresPasswordChange"));
        RemoteCrowdDirectoryTest.assertNull((Object)userWithAttributes.getValue("colour"));
        RemoteCrowdDirectoryTest.assertNull((Object)userWithAttributes.getValue("phone-number"));
        RemoteCrowdDirectoryTest.assertNull((Object)userWithAttributes.getValues("preferred-beers"));
    }

    public void testStoreUserAttributesBadUser() throws OperationFailedException {
        HashMap<String, HashSet> userAttributes = new HashMap<String, HashSet>();
        userAttributes.put("colour", Sets.newHashSet((Object[])new String[]{"blue"}));
        userAttributes.put("phone-number", Sets.newHashSet((Object[])new String[]{"555-555-555"}));
        userAttributes.put("preferred-beers", Sets.newHashSet((Object[])new String[]{"vb", "xxxx", "crown"}));
        try {
            this.remoteDirectory.storeUserAttributes(NON_EXISTENT_USERNAME, userAttributes);
            RemoteCrowdDirectoryTest.fail((String)"User 'errorName' does not exist, but we found him anyway. That's bad");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUserAttributes() throws Exception {
        this.intendToModifyData();
        UserWithAttributes userWithAttributes = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertEquals((String)"false", (String)userWithAttributes.getValue("requiresPasswordChange"));
        this.remoteDirectory.removeUserAttributes("eeeep", "requiresPasswordChange");
        userWithAttributes = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertNull((Object)userWithAttributes.getValue("requiresPasswordChange"));
    }

    public void testRemoveUserAttributesBadUser() throws Exception {
        try {
            this.remoteDirectory.removeUserAttributes(NON_EXISTENT_USERNAME, "requiresPasswordChange");
            RemoteCrowdDirectoryTest.fail((String)"User 'errorName' does not exist, but we found him anyway. That's bad");
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        UserWithAttributes userWithAttributes = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)userWithAttributes);
    }

    public void testRemoveUserAttributesBadAttribute() throws Exception {
        this.remoteDirectory.removeUserAttributes("eeeep", "badattribute");
        UserWithAttributes userWithAttributes = this.remoteDirectory.findUserWithAttributesByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)userWithAttributes);
    }

    public void testFindGroupByName() throws Exception {
        Group group = this.remoteDirectory.findGroupByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)group.getName());
    }

    public void testFindGroupByNameNotFound() throws OperationFailedException {
        try {
            this.remoteDirectory.findGroupByName(NON_EXISTENT_GROUP);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we found him anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testFindGroupWithAttributesByName() throws Exception {
        GroupWithAttributes group = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)group.getName());
        RemoteCrowdDirectoryTest.assertNotNull((Object)group.getValue("secret-location"));
        RemoteCrowdDirectoryTest.assertEquals((String)"hollow", (String)group.getValue("secret-location"));
    }

    public void testFindGroupWithAttributesByNameNotFound() throws OperationFailedException {
        try {
            this.remoteDirectory.findGroupWithAttributesByName(NON_EXISTENT_GROUP);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we found him anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testAddGroup() throws Exception {
        this.intendToModifyData();
        GroupTemplate groupTemplate = new GroupTemplate(NEW_GROUP, 1L);
        groupTemplate.setActive(true);
        groupTemplate.setDescription(NEW_GROUP_DESCRIPTION);
        groupTemplate.setType(GroupType.GROUP);
        Group group = this.remoteDirectory.addGroup(groupTemplate);
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        RemoteCrowdDirectoryTest.assertEquals((String)NEW_GROUP, (String)group.getName());
        GroupWithAttributes addedGroup = this.remoteDirectory.findGroupWithAttributesByName(NEW_GROUP);
        RemoteCrowdDirectoryTest.assertNotNull((Object)addedGroup);
        RemoteCrowdDirectoryTest.assertEquals((String)NEW_GROUP, (String)addedGroup.getName());
        RemoteCrowdDirectoryTest.assertEquals((String)NEW_GROUP_DESCRIPTION, (String)addedGroup.getDescription());
        RemoteCrowdDirectoryTest.assertEquals((Object)GroupType.GROUP, (Object)addedGroup.getType());
    }

    public void testAddGroupDuplicate() throws Exception {
        GroupTemplate groupTemplate = new GroupTemplate(NEW_GROUP, 1L);
        groupTemplate.setActive(true);
        groupTemplate.setDescription(NEW_GROUP_DESCRIPTION);
        groupTemplate.setType(GroupType.GROUP);
        Group group = this.remoteDirectory.addGroup(groupTemplate);
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        RemoteCrowdDirectoryTest.assertEquals((String)NEW_GROUP, (String)group.getName());
        try {
            group = this.remoteDirectory.addGroup(groupTemplate);
            RemoteCrowdDirectoryTest.fail((String)"Should not be able to create a group with the same name as one that already exists");
        }
        catch (InvalidGroupException invalidGroupException) {
            // empty catch block
        }
    }

    public void testUpdateGroup() throws Exception {
        this.intendToModifyData();
        Group group = this.remoteDirectory.findGroupByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)group.getName());
        GroupTemplate groupTemplate = new GroupTemplate(group);
        groupTemplate.setDescription("Updated Group via REST");
        Group updatedGroup = this.remoteDirectory.updateGroup(groupTemplate);
        updatedGroup = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)updatedGroup.getName());
        RemoteCrowdDirectoryTest.assertEquals((String)"Updated Group via REST", (String)updatedGroup.getDescription());
    }

    public void testUpdateGroupNotFound() throws Exception {
        GroupTemplate groupTemplate = new GroupTemplate(NON_EXISTENT_GROUP, 1L);
        groupTemplate.setDescription("Updated Group via REST");
        try {
            this.remoteDirectory.updateGroup(groupTemplate);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we found him anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveGroup() throws Exception {
        this.intendToModifyData();
        Group group = this.remoteDirectory.findGroupByName("badgers");
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)group.getName());
        this.remoteDirectory.removeGroup("badgers");
        try {
            group = this.remoteDirectory.findGroupWithAttributesByName("badgers");
            RemoteCrowdDirectoryTest.fail((String)"Group 'badgers' was removed, but we found him anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveGroupBadGroup() throws Exception {
        try {
            this.remoteDirectory.removeGroup(NON_EXISTENT_GROUP);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we found him anyway. That's bad");
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        GroupWithAttributes groupWithAttributes = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)groupWithAttributes.getName());
    }

    public void testStoreGroupAttributes() throws Exception {
        this.intendToModifyData();
        Group group = this.remoteDirectory.findGroupByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)group.getName());
        HashMap<String, HashSet> groupAttributes = new HashMap<String, HashSet>();
        groupAttributes.put("colour", Sets.newHashSet((Object[])new String[]{"blue"}));
        groupAttributes.put("phone-number", Sets.newHashSet((Object[])new String[]{"555-555-555"}));
        groupAttributes.put("preferred-beers", Sets.newHashSet((Object[])new String[]{"vb", "xxxx", "crown"}));
        this.remoteDirectory.storeGroupAttributes(group.getName(), groupAttributes);
        GroupWithAttributes groupWithAttributes = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertEquals((String)"blue", (String)groupWithAttributes.getValue("colour"));
        RemoteCrowdDirectoryTest.assertEquals((String)"555-555-555", (String)groupWithAttributes.getValue("phone-number"));
        Set beers = groupWithAttributes.getValues("preferred-beers");
        RemoteCrowdDirectoryTest.assertEquals((int)3, (int)beers.size());
        RemoteCrowdDirectoryTest.assertTrue((boolean)beers.contains("vb"));
        RemoteCrowdDirectoryTest.assertTrue((boolean)beers.contains("xxxx"));
        RemoteCrowdDirectoryTest.assertTrue((boolean)beers.contains("crown"));
    }

    public void testStoreGroupAttributesEmptySet() throws Exception {
        this.intendToModifyData();
        GroupWithAttributes groupWithAttributes = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertEquals((String)"hollow", (String)groupWithAttributes.getValue("secret-location"));
        HashMap groupAttributes = new HashMap();
        this.remoteDirectory.storeGroupAttributes("badgers", groupAttributes);
        groupWithAttributes = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertEquals((String)"hollow", (String)groupWithAttributes.getValue("secret-location"));
        RemoteCrowdDirectoryTest.assertNull((Object)groupWithAttributes.getValue("colour"));
        RemoteCrowdDirectoryTest.assertNull((Object)groupWithAttributes.getValue("phone-number"));
        RemoteCrowdDirectoryTest.assertNull((Object)groupWithAttributes.getValues("preferred-beers"));
    }

    public void testStoreGroupAttributesBadGroup() throws OperationFailedException {
        HashMap<String, HashSet> groupAttributes = new HashMap<String, HashSet>();
        groupAttributes.put("colour", Sets.newHashSet((Object[])new String[]{"blue"}));
        groupAttributes.put("phone-number", Sets.newHashSet((Object[])new String[]{"555-555-555"}));
        groupAttributes.put("preferred-beers", Sets.newHashSet((Object[])new String[]{"vb", "xxxx", "crown"}));
        try {
            this.remoteDirectory.storeGroupAttributes(NON_EXISTENT_GROUP, groupAttributes);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we found him anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveGroupAttributes() throws Exception {
        this.intendToModifyData();
        GroupWithAttributes groupWithAttributes = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertEquals((String)"hollow", (String)groupWithAttributes.getValue("secret-location"));
        this.remoteDirectory.removeGroupAttributes("badgers", "secret-location");
        groupWithAttributes = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertNull((Object)groupWithAttributes.getValue("secret-location"));
    }

    public void testRemoveGroupAttributesBadGroup() throws Exception {
        try {
            this.remoteDirectory.removeGroupAttributes(NON_EXISTENT_GROUP, "secret-location");
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we found him anyway. That's bad");
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        GroupWithAttributes groupWithAttributes = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)groupWithAttributes.getName());
    }

    public void testRemoveGroupAttributesBadAttribute() throws Exception {
        this.remoteDirectory.removeGroupAttributes("badgers", "badattribute");
        GroupWithAttributes groupWithAttributes = this.remoteDirectory.findGroupWithAttributesByName("badgers");
        RemoteCrowdDirectoryTest.assertEquals((String)"badgers", (String)groupWithAttributes.getName());
    }

    public void testIsUserDirectMemberOfGroup() throws OperationFailedException {
        boolean found = this.remoteDirectory.isUserDirectGroupMember("eeeep", "badgers");
        RemoteCrowdDirectoryTest.assertTrue((boolean)found);
    }

    public void testAddUserToGroup() throws Exception {
        this.intendToModifyData();
        Group group = this.remoteDirectory.findGroupByName(GROUP2);
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        this.remoteDirectory.addUserToGroup(user.getName(), group.getName());
        RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.isUserDirectGroupMember("eeeep", GROUP2));
    }

    public void testAddUserToGroupDuplicate() throws Exception {
        this.intendToModifyData();
        Group group = this.remoteDirectory.findGroupByName(GROUP2);
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        this.remoteDirectory.addUserToGroup(user.getName(), group.getName());
        RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.isUserDirectGroupMember("eeeep", GROUP2));
        try {
            this.remoteDirectory.addUserToGroup(user.getName(), group.getName());
            RemoteCrowdDirectoryTest.fail((String)"MembershipAlreadyExistsException expected");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
        RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.isUserDirectGroupMember("eeeep", GROUP2));
    }

    public void testAddUserToGroupBadGroup() throws Exception {
        try {
            this.remoteDirectory.addUserToGroup("eeeep", NON_EXISTENT_GROUP);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we added the membership anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testAddUserToGroupBadUser() throws Exception {
        try {
            this.remoteDirectory.addUserToGroup(NON_EXISTENT_USERNAME, GROUP2);
            RemoteCrowdDirectoryTest.fail((String)"User 'errorName' does not exist, but we added the membership anyway. That's bad");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testIsGroupDirectMemberOfGroup() throws OperationFailedException {
        boolean found = this.remoteDirectory.isGroupDirectGroupMember("badgers", GROUP4);
        RemoteCrowdDirectoryTest.assertTrue((boolean)found);
    }

    public void testAddGroupToGroup() throws Exception {
        this.intendToModifyData();
        Group parent = this.remoteDirectory.findGroupByName(GROUP2);
        RemoteCrowdDirectoryTest.assertNotNull((Object)parent);
        Group child = this.remoteDirectory.findGroupByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)child);
        this.remoteDirectory.addGroupToGroup(child.getName(), parent.getName());
        RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.isGroupDirectGroupMember("badgers", GROUP2));
    }

    public void testAddGroupToGroupDuplicate() throws Exception {
        this.intendToModifyData();
        Group parent = this.remoteDirectory.findGroupByName(GROUP2);
        RemoteCrowdDirectoryTest.assertNotNull((Object)parent);
        Group child = this.remoteDirectory.findGroupByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)child);
        this.remoteDirectory.addGroupToGroup(child.getName(), parent.getName());
        RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.isGroupDirectGroupMember("badgers", GROUP2));
        try {
            this.remoteDirectory.addGroupToGroup(child.getName(), parent.getName());
            RemoteCrowdDirectoryTest.fail((String)"MembershipAlreadyExistsException expected");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
        RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.isGroupDirectGroupMember("badgers", GROUP2));
    }

    public void testAddGroupToGroupBadParent() throws Exception {
        try {
            this.remoteDirectory.addGroupToGroup(GROUP2, NON_EXISTENT_GROUP);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we added the membership anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testAddGroupToGroupBadChild() throws Exception {
        try {
            this.remoteDirectory.addGroupToGroup(NON_EXISTENT_GROUP, "badgers");
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we added the membership anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroup() throws Exception {
        this.intendToModifyData();
        RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.isUserDirectGroupMember("eeeep", "badgers"));
        Group group = this.remoteDirectory.findGroupByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)group);
        User user = this.remoteDirectory.findUserByName("eeeep");
        RemoteCrowdDirectoryTest.assertNotNull((Object)user);
        this.remoteDirectory.removeUserFromGroup(user.getName(), group.getName());
        RemoteCrowdDirectoryTest.assertFalse((boolean)this.remoteDirectory.isUserDirectGroupMember("eeeep", "badgers"));
    }

    public void testRemoveUserFromGroupBadUser() throws Exception {
        try {
            this.remoteDirectory.removeUserFromGroup(NON_EXISTENT_USERNAME, "badgers");
            RemoteCrowdDirectoryTest.fail((String)"User 'errorName' does not exist, but we added the membership anyway. That's bad");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroupBadGroup() throws Exception {
        try {
            this.remoteDirectory.removeUserFromGroup("eeeep", NON_EXISTENT_GROUP);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we added the membership anyway. That's bad");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveGroupFromGroup() throws Exception {
        this.intendToModifyData();
        RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.isGroupDirectGroupMember("badgers", GROUP4));
        Group child = this.remoteDirectory.findGroupByName("badgers");
        RemoteCrowdDirectoryTest.assertNotNull((Object)child);
        Group parent = this.remoteDirectory.findGroupByName(GROUP4);
        RemoteCrowdDirectoryTest.assertNotNull((Object)parent);
        this.remoteDirectory.removeGroupFromGroup(child.getName(), parent.getName());
        RemoteCrowdDirectoryTest.assertFalse((boolean)this.remoteDirectory.isGroupDirectGroupMember("badgers", GROUP4));
    }

    public void testRemoveGroupFromGroupBadParent() throws Exception {
        try {
            this.remoteDirectory.removeGroupFromGroup("badgers", NON_EXISTENT_GROUP);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we could successfully remove an existing group from it. That's bad");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveGroupFromGroupBadChild() throws Exception {
        try {
            this.remoteDirectory.removeGroupFromGroup(NON_EXISTENT_GROUP, GROUP4);
            RemoteCrowdDirectoryTest.fail((String)"Group 'errorGroup' does not exist, but we could successfully remove it from an existing group. That's bad");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
    }

    static Matcher<Iterable<? extends String>> isNames(Collection<String> names) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])names.toArray(new String[names.size()]));
    }

    public void testSearchAllUsers() throws OperationFailedException {
        List users = this.remoteDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(1000));
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(users), RemoteCrowdDirectoryTest.isNames(ALL_USER_NAMES));
    }

    public void testSearchAllUserNames() throws OperationFailedException {
        List userNames = this.remoteDirectory.searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(1000));
        Assert.assertThat((Object)userNames, RemoteCrowdDirectoryTest.isNames(ALL_USER_NAMES));
    }

    public void testSearchUsers_EmailRestriction() throws OperationFailedException {
        List users = this.remoteDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)"bob@example.net")).returningAtMost(1000));
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(users), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"admin", "regularuser"}));
    }

    public void testSearchUsers_ActiveRestriction() throws OperationFailedException {
        List users = this.remoteDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true)).returningAtMost(1000));
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(users), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"admin", "eeeep", "penny", "regularuser", "secondadmin", MR_TRAILING_SPACES}));
    }

    public void testSearchUsers_InactiveRestriction() throws OperationFailedException {
        List users = this.remoteDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)false)).returningAtMost(1000));
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(users), (Matcher)IsEmptyIterable.emptyIterable());
    }

    public void testSearchAllGroups() throws OperationFailedException {
        List groups = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(1000));
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(groups), RemoteCrowdDirectoryTest.isNames(ALL_GROUP_NAMES));
    }

    public void testSearchAllGroupNames() throws OperationFailedException {
        List groupNames = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(1000));
        Assert.assertThat((Object)groupNames, RemoteCrowdDirectoryTest.isNames(ALL_GROUP_NAMES));
    }

    public void testSearchGroups_NameRestriction() throws OperationFailedException {
        List groups = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)ALL_GROUP_NAMES.get(0))).returningAtMost(1000));
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(groups), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{ALL_GROUP_NAMES.get(0)}));
    }

    public void testGetUserMembersOfGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName("badgers").returningAtMost(-1);
        List users = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(users), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"admin", "eeeep"}));
        query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(GROUP4).returningAtMost(-1);
        users = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)users, (Matcher)IsEmptyCollection.empty());
    }

    public void testGetUserNameMembersOfGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName("badgers").returningAtMost(-1);
        List users = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)users, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"admin", "eeeep"}));
        query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(GROUP4).returningAtMost(-1);
        users = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)users, (Matcher)IsEmptyCollection.empty());
    }

    public void testGetGroupMembersOfGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(GROUP2).returningAtMost(-1);
        List groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(groups), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{GROUP3}));
        query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(GROUP4).returningAtMost(-1);
        groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(groups), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"badgers"}));
    }

    public void testGetGroupNameMembersOfGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(GROUP2).returningAtMost(-1);
        List groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)groups, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{GROUP3}));
        query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(GROUP4).returningAtMost(-1);
        groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)groups, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"badgers"}));
    }

    public void testGroupMembershipsForUser() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("admin").returningAtMost(-1);
        List groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(groups), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"badgers", GROUP2}));
        query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("eeeep").returningAtMost(-1);
        groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(groups), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"badgers"}));
    }

    public void testGroupNameMembershipsForUser() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("admin").returningAtMost(-1);
        List groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)groups, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"badgers", GROUP2}));
        query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("eeeep").returningAtMost(-1);
        groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)groups, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"badgers"}));
    }

    public void testGroupMembershipsForGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName("badgers").returningAtMost(-1);
        List groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(groups), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{GROUP3, GROUP4}));
        query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(GROUP3).returningAtMost(-1);
        groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat(RemoteCrowdDirectoryTest.namesOf(groups), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{GROUP2}));
    }

    public void testGroupNameMembershipsForGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName("badgers").returningAtMost(-1);
        List groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)groups, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{GROUP3, GROUP4}));
        query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(GROUP3).returningAtMost(-1);
        groups = this.remoteDirectory.searchGroupRelationships(query);
        Assert.assertThat((Object)groups, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{GROUP2}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedGroupSupport() {
        Map<String, String> originalMap = Collections.unmodifiableMap(RemoteCrowdDirectoryTest.getAttributeMap(this.remoteDirectory));
        try {
            HashMap<String, String> nonNestedGroupMap = new HashMap<String, String>(originalMap);
            nonNestedGroupMap.put("useNestedGroups", Boolean.FALSE.toString());
            this.remoteDirectory.setAttributes(nonNestedGroupMap);
            RemoteCrowdDirectoryTest.assertFalse((boolean)this.remoteDirectory.supportsNestedGroups());
            HashMap<String, String> nestedGroupMap = new HashMap<String, String>(originalMap);
            nestedGroupMap.put("useNestedGroups", Boolean.TRUE.toString());
            this.remoteDirectory.setAttributes(nestedGroupMap);
            RemoteCrowdDirectoryTest.assertTrue((boolean)this.remoteDirectory.supportsNestedGroups());
        }
        finally {
            this.remoteDirectory.setAttributes(originalMap);
        }
    }

    private static Map<String, String> getAttributeMap(RemoteCrowdDirectory directory) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : directory.getKeys()) {
            map.put(key, directory.getValue(key));
        }
        return map;
    }

    static Iterable<String> namesOf(Iterable<? extends DirectoryEntity> entities) {
        ArrayList<String> names = new ArrayList<String>();
        for (DirectoryEntity directoryEntity : entities) {
            names.add(directoryEntity.getName());
        }
        return names;
    }

    private static class FixedClientProperties
    extends AbstractClientProperties {
        private FixedClientProperties(String url, String username, String password, String httpTimeOut, String httpMaxConnections, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword) {
            this.baseURL = url;
            this.applicationName = username;
            this.applicationPassword = password;
            this.httpTimeout = httpTimeOut;
            this.httpMaxConnections = httpMaxConnections;
            this.httpProxyHost = proxyHost;
            this.httpProxyPort = proxyPort;
            this.httpProxyPassword = proxyUsername;
            this.httpProxyPassword = proxyPassword;
        }

        public void updateProperties(Properties properties) {
            throw new UnsupportedOperationException("not supported");
        }
    }
}

