/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.util.TimedProgressOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageAndRangeTest
extends BaseTest {
    private static final Logger logger = LoggerFactory.getLogger(PageAndRangeTest.class);
    private final String USERNAME_PREFIX = "page-user-";
    private final String GROUPNAME_PREFIX = "page-group-";
    private final String LARGE_GROUP_NAME = "PageAndRange-LargeGroup";
    private final int NUM_USERS = 2500;
    private final int NUM_GROUPS = 2500;

    protected String buildUserName(int i) {
        return "page-user-" + i;
    }

    protected String buildGroupName(int i) {
        return "page-group-" + i;
    }

    protected void addUserToGroup(int userIndex, String groupName) throws Exception {
        this.getRemoteDirectory().addUserToGroup(this.buildUserName(userIndex), groupName);
    }

    @Override
    protected void removeTestData() throws DirectoryInstantiationException {
        int i;
        TimedProgressOperation operation;
        try {
            if (this.getRemoteDirectory().findUserByName(this.buildUserName(0)) != null) {
                operation = new TimedProgressOperation("Deleting 2500 users", 2500, logger);
                for (i = 0; i < 2500; ++i) {
                    operation.incrementProgress();
                    DirectoryTestHelper.silentlyRemoveUser(this.buildUserName(i), this.getRemoteDirectory());
                }
                operation.complete("Users deleted");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getRemoteDirectory().findGroupByName(this.buildGroupName(0)) != null) {
                operation = new TimedProgressOperation("Deleting 2500 groups", 2500, logger);
                for (i = 0; i < 2500; ++i) {
                    operation.incrementProgress();
                    DirectoryTestHelper.silentlyRemoveGroup(this.buildGroupName(i), this.getRemoteDirectory());
                }
                operation.complete("Groups deleted");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DirectoryTestHelper.silentlyRemoveGroup("PageAndRange-LargeGroup", this.getRemoteDirectory());
    }

    @Override
    protected void loadTestData() {
    }

    public void testLargeUserSearchResult() throws Exception {
        logger.info(">> Running testLargeUserSearchResult");
        int numExistingUsers = 0;
        List users = this.getRemoteDirectory().searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        if (users != null) {
            numExistingUsers = users.size();
        }
        logger.info("Creating 2500 users");
        TimedProgressOperation operation = new TimedProgressOperation("Creating 2500 users", 2500, logger);
        for (int i = 0; i < 2500; ++i) {
            operation.incrementProgress();
            DirectoryTestHelper.addUser(this.buildUserName(i), this.directory.getId(), "secret-password", this.getRemoteDirectory());
        }
        operation.complete("Users created");
        users = this.getRemoteDirectory().searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        PageAndRangeTest.assertNotNull((Object)users);
        PageAndRangeTest.assertEquals((String)"Did not return all users added", (int)(numExistingUsers + 2500), (int)users.size());
        for (String user : users) {
            PageAndRangeTest.assertNotNull((Object)user);
        }
    }

    public void testLargeGroupSearchResult() throws Exception {
        logger.info(">> Running testLargeGroupSearchResult");
        int numExistingGroups = 0;
        List groups = this.getRemoteDirectory().searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
        if (groups != null) {
            numExistingGroups = groups.size();
        }
        logger.info("Creating 2500 groups");
        TimedProgressOperation operation = new TimedProgressOperation("Creating 2500 groups", 2500, logger);
        for (int i = 0; i < 2500; ++i) {
            operation.incrementProgress();
            DirectoryTestHelper.addGroup(this.buildGroupName(i), this.directory.getId(), this.getRemoteDirectory());
        }
        operation.complete("Groups created");
        groups = this.getRemoteDirectory().searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
        PageAndRangeTest.assertNotNull((Object)groups);
        PageAndRangeTest.assertEquals((String)"Did not return all groups added", (int)(numExistingGroups + 2500), (int)groups.size());
        for (String group : groups) {
            PageAndRangeTest.assertNotNull((Object)group);
        }
    }

    public void testLargeGroupMemberSearchResult() throws Exception {
        logger.info(">> Running testLargeGroupMemberSearchResult");
        DirectoryTestHelper.addGroup("PageAndRange-LargeGroup", this.directory.getId(), this.getRemoteDirectory());
        logger.info("Creating 2500 users, and adding each to group <PageAndRange-LargeGroup>");
        TimedProgressOperation operation = new TimedProgressOperation("Creating 2500 users, and adding each to group PageAndRange-LargeGroup", 2500, logger);
        for (int i = 0; i < 2500; ++i) {
            operation.incrementProgress();
            DirectoryTestHelper.addUser(this.buildUserName(i), this.directory.getId(), "secret-password", this.getRemoteDirectory());
            this.addUserToGroup(i, "PageAndRange-LargeGroup");
        }
        operation.complete("Users created and added to group");
        List users = this.getRemoteDirectory().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("PageAndRange-LargeGroup").returningAtMost(-1));
        PageAndRangeTest.assertNotNull((Object)users);
        PageAndRangeTest.assertEquals((String)"PageAndRange-LargeGroup should have 2500 members", (int)2500, (int)users.size());
        for (String user : users) {
            PageAndRangeTest.assertNotNull((Object)user);
        }
    }
}

