/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;

public abstract class NestedGroupsTest
extends BaseTest {
    protected final String groupName1 = "group-1";
    protected final String groupName2 = "group-2";
    protected final String groupName3 = "group-3";
    protected final String groupName4 = "group-4";
    protected final String groupName5 = "group-5";
    protected final String userNameA = "user-A";
    protected final String userNameB = "user-B";
    protected final String userNameC = "user-C";
    protected final String userNameD = "user-D";
    protected final String userNameE = "user-E";
    protected final String userNameF = "user-F";
    protected final String userNameG = "user-G";
    protected final String firstName = "First";
    protected final String surName = "Last";
    protected final String password = "secret-password";

    @Override
    protected void removeTestData() throws DirectoryInstantiationException {
        DirectoryTestHelper.silentlyRemoveGroup("group-1", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveGroup("group-2", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveGroup("group-3", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveGroup("group-4", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveGroup("group-5", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user-A", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user-B", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user-C", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user-D", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user-E", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user-F", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user-G", this.getRemoteDirectory());
    }

    @Override
    protected void loadTestData() throws Exception {
        GroupTemplate group1 = new GroupTemplate("group-1", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group1);
        GroupTemplate group2 = new GroupTemplate("group-2", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group2);
        GroupTemplate group3 = new GroupTemplate("group-3", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group3);
        GroupTemplate group4 = new GroupTemplate("group-4", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group4);
        GroupTemplate group5 = new GroupTemplate("group-5", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group5);
        DirectoryTestHelper.addUser("user-A", this.directory.getId(), "secret-password", this.getRemoteDirectory());
        DirectoryTestHelper.addUser("user-B", this.directory.getId(), "secret-password", this.getRemoteDirectory());
        DirectoryTestHelper.addUser("user-C", this.directory.getId(), "secret-password", this.getRemoteDirectory());
        DirectoryTestHelper.addUser("user-D", this.directory.getId(), "secret-password", this.getRemoteDirectory());
        DirectoryTestHelper.addUser("user-E", this.directory.getId(), "secret-password", this.getRemoteDirectory());
        DirectoryTestHelper.addUser("user-F", this.directory.getId(), "secret-password", this.getRemoteDirectory());
        DirectoryTestHelper.addUser("user-G", this.directory.getId(), "secret-password", this.getRemoteDirectory());
        this.getRemoteDirectory().addUserToGroup("user-A", "group-1");
        this.getRemoteDirectory().addUserToGroup("user-B", "group-2");
        this.getRemoteDirectory().addUserToGroup("user-C", "group-3");
        this.getRemoteDirectory().addUserToGroup("user-D", "group-3");
        this.getRemoteDirectory().addUserToGroup("user-E", "group-4");
        this.getRemoteDirectory().addGroupToGroup("group-2", "group-1");
        this.getRemoteDirectory().addGroupToGroup("group-3", "group-2");
        this.getRemoteDirectory().addGroupToGroup("group-1", "group-3");
        this.getRemoteDirectory().addGroupToGroup("group-4", "group-3");
        this.getRemoteDirectory().addGroupToGroup("group-5", "group-4");
    }

    public void testNestedGroups() throws Exception {
        this.logger.info((Object)"Running testNestedGroups");
        List users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(5 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-A", "user-B", "user-C", "user-D", "user-E"}));
        users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-4").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-E"}));
    }

    public void testAddUserToNestedGroups() throws Exception {
        this.logger.info((Object)"Running testAddUserToNestedGroups");
        this.directoryManager.addUserToGroup(this.directory.getId(), "user-F", "group-1");
        List users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(6 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-A", "user-B", "user-C", "user-D", "user-E", "user-F"}));
        users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-4").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-E"}));
    }

    public void testRemoveUserFromNestedGroupsFail() throws Exception {
        this.logger.info((Object)"Running testRemoveUserFromNestedGroupsFail");
        try {
            this.directoryManager.removeUserFromGroup(this.directory.getId(), "user-B", "group-1");
            NestedGroupsTest.fail((String)"Should have thrown exception");
        }
        catch (MembershipNotFoundException e) {
            // empty catch block
        }
        List users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(5 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-A", "user-B", "user-C", "user-D", "user-E"}));
        users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-4").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-E"}));
    }

    public void testRemoveUserFromNestedGroupsOk() throws Exception {
        this.logger.info((Object)"Running testRemoveUserFromNestedGroupsOk");
        this.directoryManager.removeUserFromGroup(this.directory.getId(), "user-A", "group-1");
        List users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(4 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-B", "user-C", "user-D", "user-E"}));
        users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-4").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-E"}));
    }

    public void testNestedGroupsDirectFetch() throws Exception {
        this.logger.info((Object)"Running testNestedGroupsDirectFetch");
        List groups = this.directoryManager.searchDirectGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertEquals((Object)ImmutableList.of((Object)"group-2"), groups);
        List users = this.directoryManager.searchDirectGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull(users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        Assert.assertThat(users, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"user-A"}));
    }

    public void testIsGroupMemberDirect() throws Exception {
        this.logger.info((Object)"Running testIsGroupMemberDirect");
        boolean isMember = this.directoryManager.isUserDirectGroupMember(this.directory.getId(), "user-A", "group-1");
        NestedGroupsTest.assertTrue((String)"user-A should be a member of group-1", (boolean)isMember);
    }

    public void testIsGroupMemberDirectNot() throws Exception {
        this.logger.info((Object)"Running testIsGroupMemberDirectNot");
        boolean isMember = this.directoryManager.isUserDirectGroupMember(this.directory.getId(), "user-G", "group-1");
        NestedGroupsTest.assertFalse((String)"user-G should NOT be a member of group-1", (boolean)isMember);
    }

    public void testIsGroupMemberDirectNonExistent() throws Exception {
        this.logger.info((Object)"Running testIsGroupMemberDirectNonExistent");
        String nonExistentUserName = "badgers-Ahoy!";
        boolean isMember = this.directoryManager.isUserDirectGroupMember(this.directory.getId(), nonExistentUserName, "group-1");
        NestedGroupsTest.assertFalse((String)(nonExistentUserName + " should NOT be a member of " + "group-1"), (boolean)isMember);
    }

    public void testIsGroupMemberNested() throws Exception {
        this.logger.info((Object)"Running testIsGroupMemberNested");
        boolean isMember = this.directoryManager.isUserNestedGroupMember(this.directory.getId(), "user-B", "group-1");
        NestedGroupsTest.assertTrue((String)"user-B should be a nested member of group-1", (boolean)isMember);
    }

    protected int getInitialGroupMemberCount() {
        return 0;
    }
}

