/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.ApacheDS15;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.ldap.core.DirContextAdapter;

public class LdapDirectoryMappersWithRequiredAttributesTest
extends BaseTest {
    public LdapDirectoryMappersWithRequiredAttributesTest() {
        this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
    }

    @Override
    protected void loadTestData() throws Exception {
    }

    @Override
    protected void removeTestData() {
    }

    RemoteDirectory getReconfiguredDirectory(String implementation) throws DirectoryInstantiationException {
        this.directory.setImplementationClass(implementation);
        this.directory.setAttribute("ldap.basedn", "ou=Users,dc=example,dc=com");
        this.directory.setAttribute("ldap.user.username", "uid");
        return this.getRemoteDirectory();
    }

    public void testCustomAttributeIsNotPresentByDefault() throws Exception {
        RemoteDirectory rd = this.getReconfiguredDirectory(ApacheDS15.class.getName());
        UserWithAttributes user = rd.findUserWithAttributesByName("aeinstein");
        LdapDirectoryMappersWithRequiredAttributesTest.assertNotNull((Object)user);
        LdapDirectoryMappersWithRequiredAttributesTest.assertNull((String)"Custom attributes are not returned with the default RemoteDirectory", (Object)user.getValue("test.phone"));
    }

    public void testRequiredAttributesArePresentForCustomAttributeMapper() throws Exception {
        RemoteDirectory rd = this.getReconfiguredDirectory(DirectoryWithCustomAttributeMapper.class.getName());
        UserWithAttributes user = rd.findUserWithAttributesByName("aeinstein");
        LdapDirectoryMappersWithRequiredAttributesTest.assertNotNull((Object)user);
        LdapDirectoryMappersWithRequiredAttributesTest.assertEquals((String)"Custom attributes are returned when a custom AttributeMapper requests them", (String)"+1 904 982 6882", (String)user.getValue("test.phone"));
    }

    public void testAttributesAreNotPresentWhenCustomAttributeMapperDoesNotDeclareThem() throws Exception {
        RemoteDirectory rd = this.getReconfiguredDirectory(DirectoryWithCustomAttributeMapperWithoutRequiredFields.class.getName());
        UserWithAttributes user = rd.findUserWithAttributesByName("aeinstein");
        LdapDirectoryMappersWithRequiredAttributesTest.assertNotNull((Object)user);
        LdapDirectoryMappersWithRequiredAttributesTest.assertEquals((String)"Custom attributes are not available when a custom AttributeMapper claims not to need them", (String)"(none specified)", (String)user.getValue("test.phone"));
    }

    public void testRequiredAttributesArePresentForCustomAttributeMapperWhenAllAttributesAreRequested() throws Exception {
        RemoteDirectory rd = this.getReconfiguredDirectory(DirectoryWithCustomAttributeMapperThatRequestsAllFields.class.getName());
        UserWithAttributes user = rd.findUserWithAttributesByName("aeinstein");
        LdapDirectoryMappersWithRequiredAttributesTest.assertNotNull((Object)user);
        LdapDirectoryMappersWithRequiredAttributesTest.assertEquals((String)"Custom attributes are available when a custom AttributeMapper claims to need all attributes", (String)"+1 904 982 6882", (String)user.getValue("test.phone"));
    }

    public static class DirectoryWithCustomAttributeMapperThatRequestsAllFields
    extends ApacheDS15 {
        public DirectoryWithCustomAttributeMapperThatRequestsAllFields(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory, PasswordEncoderFactory passwordEncoderFactory) {
            super(ldapQueryTranslater, eventPublisher, instanceFactory, passwordEncoderFactory);
        }

        protected List<AttributeMapper> getCustomUserAttributeMappers() {
            return Collections.singletonList(new PhoneNumberAttributeMapper(){

                public Set<String> getRequiredLdapAttributes() {
                    return null;
                }
            });
        }
    }

    public static class DirectoryWithCustomAttributeMapperWithoutRequiredFields
    extends ApacheDS15 {
        public DirectoryWithCustomAttributeMapperWithoutRequiredFields(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory, PasswordEncoderFactory passwordEncoderFactory) {
            super(ldapQueryTranslater, eventPublisher, instanceFactory, passwordEncoderFactory);
        }

        protected List<AttributeMapper> getCustomUserAttributeMappers() {
            return Collections.singletonList(new PhoneNumberAttributeMapper(){

                public Set<String> getRequiredLdapAttributes() {
                    return Collections.emptySet();
                }
            });
        }
    }

    public static class DirectoryWithCustomAttributeMapper
    extends ApacheDS15 {
        public DirectoryWithCustomAttributeMapper(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory, PasswordEncoderFactory passwordEncoderFactory) {
            super(ldapQueryTranslater, eventPublisher, instanceFactory, passwordEncoderFactory);
        }

        protected List<AttributeMapper> getCustomUserAttributeMappers() {
            return Collections.singletonList(new PhoneNumberAttributeMapper(){

                public Set<String> getRequiredLdapAttributes() {
                    return Collections.singleton("telephonenumber");
                }
            });
        }
    }

    static abstract class PhoneNumberAttributeMapper
    implements AttributeMapper {
        PhoneNumberAttributeMapper() {
        }

        public Set<String> getValues(DirContextAdapter ctx) throws Exception {
            String value = ctx.getStringAttribute("telephonenumber");
            if (value == null) {
                value = "(none specified)";
            }
            return Collections.singleton(value);
        }

        public String getKey() {
            return "test.phone";
        }
    }
}

