/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.BasicTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.List;
import java.util.Properties;

public abstract class GroupRoleTest
extends BaseTest {
    private static final String GROUP_NAME = "group-group";
    private static final String ROLE_NAME = "group-role";
    private static final String USER_NAME = "mysupercooluser";

    @Override
    protected void configureDirectory(Properties directorySettings) {
        super.configureDirectory(directorySettings);
        this.directory.setAttribute("ldap.roles.disabled", "false");
        this.directory.setAttribute("ldap.role.dn", "ou=roles");
        this.directory.setAttribute("ldap.group.dn", "ou=groups");
    }

    @Override
    protected void removeTestData() throws DirectoryInstantiationException {
        DirectoryTestHelper.silentlyRemoveGroup(GROUP_NAME, this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveGroup(ROLE_NAME, this.getRemoteDirectory());
    }

    @Override
    protected void loadTestData() throws Exception {
        GroupTemplate group = new GroupTemplate(GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
        Group addedGroup = BasicTest.getImplementation((Directory)this.directory).addGroup(group);
        GroupRoleTest.assertEquals((long)BasicTest.getImplementation((Directory)this.directory).getDirectoryId(), (long)addedGroup.getDirectoryId());
        GroupRoleTest.assertEquals((String)group.getName(), (String)addedGroup.getName());
        GroupRoleTest.assertEquals((Object)group.getType(), (Object)addedGroup.getType());
    }

    public void testFindGroupOfAnyTypeFindsGroup() throws Exception {
        Group group = BasicTest.getImplementation((Directory)this.directory).findGroupByName(GROUP_NAME);
        GroupRoleTest.assertEquals((long)BasicTest.getImplementation((Directory)this.directory).getDirectoryId(), (long)group.getDirectoryId());
        GroupRoleTest.assertEquals((String)GROUP_NAME, (String)group.getName());
        GroupRoleTest.assertEquals((Object)GroupType.GROUP, (Object)group.getType());
        List containers = BasicTest.getImplementation((Directory)this.directory).searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group(null)).returningAtMost(-1));
        GroupRoleTest.assertEquals((int)1, (int)containers.size());
    }

    public void testFindGroupOfAnyTypeDoesNotFindRole() throws Exception {
        try {
            BasicTest.getImplementation((Directory)this.directory).findGroupByName(ROLE_NAME);
            GroupRoleTest.fail();
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testFindGroupOfTypeRoleFindsNothing() throws OperationFailedException {
        List roles = BasicTest.getImplementation((Directory)this.directory).searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).returningAtMost(-1));
        GroupRoleTest.assertEquals((int)0, (int)roles.size());
    }

    public void testFindGroupOfTypeGroup() throws OperationFailedException {
        List groups = BasicTest.getImplementation((Directory)this.directory).searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
        GroupRoleTest.assertEquals((int)1, (int)groups.size());
        Group group = (Group)groups.get(0);
        GroupRoleTest.assertEquals((long)BasicTest.getImplementation((Directory)this.directory).getDirectoryId(), (long)group.getDirectoryId());
        GroupRoleTest.assertEquals((String)GROUP_NAME, (String)group.getName());
        GroupRoleTest.assertEquals((Object)GroupType.GROUP, (Object)group.getType());
    }

    public void testAddGroupWithNoTypeFail() throws Exception {
        GroupTemplate group = new GroupTemplate("new group", this.directory.getId().longValue(), GroupType.GROUP);
        group.setType(null);
        try {
            BasicTest.getImplementation((Directory)this.directory).addGroup(group);
            GroupRoleTest.fail((String)"InvalidGroupException expected");
        }
        catch (InvalidGroupException e) {
            GroupRoleTest.assertTrue((boolean)true);
        }
    }
}

