/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.MockDirectoryManager;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelperImpl;
import com.atlassian.crowd.directory.loader.CacheableDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.TimedProgressOperation;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/remoteDirectoryApplicationContext-config.xml", "classpath:/applicationContext-CrowdEncryption.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-config.xml"})
@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class DnRangeTest {
    private static final Logger logger = LoggerFactory.getLogger(DnRangeTest.class);
    private static final String LARGE_GROUP_NAME = "DnRangeTest-LargeGroup";
    private static final String SMALL_GROUP_NAME = "DnRangeTest-SmallGroup";
    private static final String PASSWORD = "Test-Password-123";
    private static final String USERNAME_PREFIX = "dnRange-user-";
    private static final int LARGE_GROUP_SIZE = 1600;
    private static final int SMALL_GROUP_SIZE = 30;
    private final String directoryConfigFile;
    private DirectoryImpl directory;
    private RemoteDirectory remoteDirectory;
    private Session session;
    @Inject
    DirectoryDao directoryDao;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private LDAPPropertiesHelperImpl ldapPropertiesHelperImpl;
    @Inject
    private MockDirectoryManager mockDirectoryManager;
    @Inject
    private DataSource dataSource;
    @Inject
    private CacheableDirectoryInstanceLoader directoryInstanceLoader;

    public DnRangeTest() {
        this(System.getProperty("directory.config.file"));
    }

    protected DnRangeTest(String directoryConfigFile) {
        Preconditions.checkNotNull((Object)directoryConfigFile, (Object)"Directory config file not specified. Have you set system property -Ddirectory.config.file?");
        this.directoryConfigFile = directoryConfigFile;
    }

    @Before
    public void setUp() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        DirectoryTestHelper.deleteFromTables(DirectoryTestHelper.TABLE_NAMES, jdbcTemplate);
        Properties properties = DirectoryTestHelper.getConfigProperties(this.directoryConfigFile);
        this.session = this.sessionFactory.openSession();
        this.session.setFlushMode(FlushMode.ALWAYS);
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.sessionFactory);
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(this.session));
        this.directory = this.configureDirectory(properties);
        Preconditions.checkNotNull((Object)"Overriders of configureDirectory() must initialise the directory Id", (Object)this.directory.getId());
        this.remoteDirectory = this.directoryInstanceLoader.getDirectory((Directory)this.directory);
        this.directoryInstanceLoader.getRawDirectory(this.directory.getId(), this.directory.getImplementationClass(), this.directory.getAttributes()).testConnection();
        this.removeTestData();
        this.loadTestData();
    }

    @After
    public void tearDown() throws Exception {
        this.removeTestData();
        TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        this.session.close();
    }

    protected DirectoryImpl configureDirectory(Properties directorySettings) {
        DirectoryImpl directoryTemplate = DirectoryTestHelper.createDirectoryTemplate(directorySettings, (LDAPPropertiesHelper)this.ldapPropertiesHelperImpl, false);
        DirectoryImpl addedDirectory = new DirectoryImpl(this.directoryDao.add((Directory)directoryTemplate));
        this.sessionFactory.getCurrentSession().flush();
        InternalEntityTemplate template = new InternalEntityTemplate(addedDirectory.getId(), addedDirectory.getName(), true, new Date(), new Date());
        DirectoryImpl templateForMockDirectoryManager = new DirectoryImpl(template);
        templateForMockDirectoryManager.updateDetailsFrom((Directory)addedDirectory);
        this.mockDirectoryManager.setDirectory((Directory)templateForMockDirectoryManager);
        return addedDirectory;
    }

    @Test
    public void testBrowseGroups() throws Exception {
        this._testBrowseLargeGroup();
        this._testBrowseSmallGroup();
    }

    public void _testBrowseLargeGroup() throws Exception {
        logger.info("Testing _testBrowseLargeGroup");
        MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(LARGE_GROUP_NAME).returningAtMost(-1);
        this.directory.setAttribute("ldap.usermembership.use", "false");
        this.syncIfCacheEnabled();
        List userMembersViaMemberDn = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        this.directory.setAttribute("ldap.usermembership.use", "true");
        this.syncIfCacheEnabled();
        List userMembersViaMemberOf = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        Assert.assertEquals((long)1600L, (long)userMembersViaMemberDn.size());
        Assert.assertEquals((long)1600L, (long)userMembersViaMemberOf.size());
    }

    public void _testBrowseSmallGroup() throws Exception {
        logger.info("Testing _testBrowseSmallGroup");
        MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(SMALL_GROUP_NAME).returningAtMost(-1);
        this.directory.setAttribute("ldap.usermembership.use", "false");
        this.syncIfCacheEnabled();
        List userMembersViaMemberDn = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        this.directory.setAttribute("ldap.usermembership.use", "true");
        this.syncIfCacheEnabled();
        List userMembersViaMemberOf = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        Assert.assertEquals((long)30L, (long)userMembersViaMemberDn.size());
        Assert.assertEquals((long)30L, (long)userMembersViaMemberOf.size());
    }

    private void syncIfCacheEnabled() throws OperationFailedException {
        if (this.remoteDirectory instanceof SynchronisableDirectory) {
            ((SynchronisableDirectory)this.remoteDirectory).synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
        }
    }

    private void removeTestData() {
        try {
            if (this.remoteDirectory.findGroupByName(LARGE_GROUP_NAME) != null) {
                logger.info("Removing {} users from group {}", (Object)1600, (Object)LARGE_GROUP_NAME);
                TimedProgressOperation operation = new TimedProgressOperation("Removing users from DnRangeTest-LargeGroup", 1600, logger);
                for (int i = 0; i < 1600; ++i) {
                    operation.incrementedProgress();
                    DirectoryTestHelper.silentlyRemoveUser(USERNAME_PREFIX + i, this.remoteDirectory);
                }
                operation.complete("Removed users from group DnRangeTest-LargeGroup");
                DirectoryTestHelper.silentlyRemoveGroup(LARGE_GROUP_NAME, this.remoteDirectory);
                DirectoryTestHelper.silentlyRemoveGroup(SMALL_GROUP_NAME, this.remoteDirectory);
                logger.info("Test data removed from the LDAP directory");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadTestData() throws Exception {
        int i;
        DirectoryTestHelper.addGroup(LARGE_GROUP_NAME, this.directory.getId(), this.remoteDirectory);
        DirectoryTestHelper.addGroup(SMALL_GROUP_NAME, this.directory.getId(), this.remoteDirectory);
        logger.info("Creating {} users", (Object)1600);
        TimedProgressOperation addUsersOperation = new TimedProgressOperation("Creating 1600 users", 1600, logger);
        for (int i2 = 0; i2 < 1600; ++i2) {
            addUsersOperation.incrementProgress();
            DirectoryTestHelper.addUser(USERNAME_PREFIX + i2, this.directory.getId(), PASSWORD, this.remoteDirectory);
        }
        addUsersOperation.complete("Users created");
        this.session.flush();
        logger.info("Adding {} users to group {}", (Object)1600, (Object)LARGE_GROUP_NAME);
        TimedProgressOperation addMembershipsOperation = new TimedProgressOperation("Adding users to group DnRangeTest-LargeGroup", 1600, logger);
        for (i = 0; i < 1600; ++i) {
            addMembershipsOperation.incrementProgress();
            this.remoteDirectory.addUserToGroup(USERNAME_PREFIX + i, LARGE_GROUP_NAME);
        }
        addMembershipsOperation.complete("Users added to group DnRangeTest-LargeGroup");
        logger.info("Adding {} users to group {}", (Object)30, (Object)SMALL_GROUP_NAME);
        for (i = 0; i < 30; ++i) {
            this.remoteDirectory.addUserToGroup(USERNAME_PREFIX + i, SMALL_GROUP_NAME);
        }
        this.session.flush();
        logger.info("Test data loaded to the LDAP directory");
    }
}

