/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BasicTest;
import com.atlassian.crowd.acceptance.tests.directory.MockDirectoryManager;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelperImpl;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.encoder.PlaintextPasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.SpringContainerContext;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.mockito.Mockito;
import org.quartz.Scheduler;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public abstract class BaseTest
extends AbstractTransactionalDataSourceSpringContextTests {
    protected DirectoryImpl directory;
    protected MockDirectoryManager directoryManager;
    private LDAPPropertiesHelperImpl ldapPropertiesHelperImpl;
    protected SessionFactory sessionFactory;
    private String directoryConfigFile;

    protected BaseTest() {
    }

    protected BaseTest(String name) {
        super(name);
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        beanFactory.registerSingleton("scheduler", Mockito.mock(Scheduler.class));
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/remoteDirectoryApplicationContext-config.xml", "classpath:/applicationContext-CrowdEncryption.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-config.xml"};
    }

    private void addPlainTextPasswordEncoder() {
        PasswordEncoderFactory passwordEncoderFactory = (PasswordEncoderFactory)ContainerManager.getComponent((String)"passwordEncoderFactory");
        passwordEncoderFactory.addEncoder((PasswordEncoder)new PlaintextPasswordEncoder());
    }

    private void addAtlassianSha1PasswordEncoder() {
        PasswordEncoderFactory passwordEncoderFactory = (PasswordEncoderFactory)ContainerManager.getComponent((String)"passwordEncoderFactory");
        passwordEncoderFactory.addEncoder((PasswordEncoder)new AtlassianSHA1PasswordEncoder());
    }

    private void setDirectoryInDirectoryManager(DirectoryImpl dir) {
        this.directoryManager = (MockDirectoryManager)ContainerManager.getComponent((String)"directoryManager");
        this.directoryManager.setDirectory((Directory)dir);
    }

    protected void configureDirectory(Properties directorySettings) {
        if (this.directory == null) {
            DirectoryImpl directoryTemplate = DirectoryTestHelper.createDirectoryTemplate(directorySettings, (LDAPPropertiesHelper)this.ldapPropertiesHelperImpl, false);
            DirectoryDao directoryDao = (DirectoryDao)ContainerManager.getComponent((String)"directoryDao");
            this.directory = new DirectoryImpl(directoryDao.add((Directory)directoryTemplate));
            this.sessionFactory.getCurrentSession().flush();
            InternalEntityTemplate template = new InternalEntityTemplate(this.directory.getId(), this.directory.getName(), true, new Date(), new Date());
            DirectoryImpl templateForMockDirectoryManager = new DirectoryImpl(template);
            templateForMockDirectoryManager.updateDetailsFrom((Directory)this.directory);
            this.setDirectoryInDirectoryManager(templateForMockDirectoryManager);
        }
    }

    public void setupSpring() {
        SpringContainerContext springContainerContext = new SpringContainerContext();
        springContainerContext.setApplicationContext((ApplicationContext)this.applicationContext);
        ContainerManager.getInstance().setContainerContext((ContainerContext)springContainerContext);
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        this.setupSpring();
        this.addPlainTextPasswordEncoder();
        this.addAtlassianSha1PasswordEncoder();
        this.deleteFromTables(DirectoryTestHelper.TABLE_NAMES);
    }

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        if (this.getDirectoryConfigFile() == null) {
            String configFileFromSystemProperty = System.getProperty("directory.config.file");
            if (configFileFromSystemProperty == null) {
                throw new FileNotFoundException("Directory config file not specified. Have you set system property -Ddirectory.config.file?");
            }
            this.setDirectoryConfigFile(configFileFromSystemProperty);
        }
        this.logger.info((Object)("Attempting to load " + this.getDirectoryConfigFile()));
        Properties properties = DirectoryTestHelper.getConfigProperties(this.getDirectoryConfigFile());
        this.configureDirectory(properties);
        BasicTest.getRawImplementation((Directory)this.directory).testConnection();
        this.removeTestData();
        this.loadTestData();
    }

    public void onTearDown() throws Exception {
        this.removeTestData();
        super.onTearDown();
    }

    protected abstract void removeTestData() throws DirectoryInstantiationException;

    protected abstract void loadTestData() throws Exception;

    public void setLdapPropertiesHelper(LDAPPropertiesHelperImpl ldapPropertiesHelperImpl) {
        this.ldapPropertiesHelperImpl = ldapPropertiesHelperImpl;
    }

    public void setDirectoryConfigFile(String directoryConfigFile) {
        this.directoryConfigFile = directoryConfigFile;
    }

    public String getDirectoryConfigFile() {
        return this.directoryConfigFile;
    }

    protected RemoteDirectory getRemoteDirectory() throws DirectoryInstantiationException {
        return BasicTest.getImplementation((Directory)this.directory);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected void deleteFromTables(String[] names) {
        DirectoryTestHelper.deleteFromTables(names, this.jdbcTemplate);
    }
}

