/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.concurrent;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.util.Properties;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class TokenStorageSwitchTest
extends CrowdAcceptanceTestCase {
    private final String APPLICATION_NAME = "tokentest";
    private final String USERNAME_PREFIX = "test-user-name";
    private final String PASSWORD_SUFFIX = "password";
    protected CyclicBarrier barrier = null;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private volatile boolean endOfPhase = false;
    private SecurityServerClient ssc = null;

    protected void setupSecurityServer() throws Exception {
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        this.ssc = new SecurityServerClientImpl((SoapClientProperties)cProperties);
    }

    protected SecurityServerClient getSSC() {
        return this.ssc;
    }

    protected int getNumberOfCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    protected String getUsername(int i) {
        return "test-user-name" + i;
    }

    protected String getPassword(String username) {
        return username + "password";
    }

    protected PasswordCredential getNewPasswordCredential(String username) {
        return new PasswordCredential(this.getPassword(username));
    }

    protected ValidationFactor[] getValidationFactors(String username) {
        return new ValidationFactor[0];
    }

    protected void addUser(String username) throws Exception {
        SOAPPrincipal soapPrincipal = new SOAPPrincipal();
        soapPrincipal.setActive(true);
        soapPrincipal.setName(username);
        this.getSSC().addPrincipal(soapPrincipal, this.getNewPasswordCredential(username));
    }

    protected boolean waitForBarrier() {
        boolean waitSuccess = false;
        try {
            this.barrier.await();
            waitSuccess = true;
        }
        catch (BrokenBarrierException e) {
            this.logAndFail("Broken barrier exception", e);
        }
        catch (InterruptedException e) {
            this.logAndFail("Thread interrupted exception", e);
        }
        return waitSuccess;
    }

    protected void logAndFail(String message, Exception e) {
        this.logger.error(message, (Throwable)e);
        TokenStorageSwitchTest.fail((String)message);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("tokenstorage.xml");
        this.setupSecurityServer();
        int numUsers = this.getNumberOfCores();
        for (int i = 0; i < numUsers; ++i) {
            this.addUser(this.getUsername(i));
        }
        int numThreads = numUsers * 2;
        this.barrier = new CyclicBarrier(numThreads + 1);
        for (int i = 0; i < numThreads; ++i) {
            pool.execute(new AuthenticateThread(i % numUsers));
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.barrier = null;
        pool.shutdownNow();
        super.tearDown();
    }

    protected void doSwitchToMemory() {
        this.gotoSessionConfig();
        this.setRadioButton("storageType", "memory");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
    }

    public void testTokenSwitchUnderLoad() {
        try {
            this.barrier.await();
            this.barrier.reset();
            this.doSwitchToMemory();
            this.endOfPhase = true;
            this.barrier.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logAndFail("Test failed due to interrupted exception", e);
        }
        catch (BrokenBarrierException e) {
            this.logAndFail("Test failed due to broken barrier exception", e);
        }
        catch (TimeoutException e) {
            this.logAndFail("Test failed due to timeout", e);
        }
    }

    public class AuthenticateThread
    implements Runnable {
        private final int userNumber;

        public AuthenticateThread(int userNumber) {
            this.userNumber = userNumber;
        }

        protected void assertTokenIsValid(String token) {
            try {
                boolean isValidToken = TokenStorageSwitchTest.this.getSSC().isValidToken(token, TokenStorageSwitchTest.this.getValidationFactors(TokenStorageSwitchTest.this.getUsername(this.userNumber)));
                TestCase.assertTrue((String)"Token was returned as invalid", (boolean)isValidToken);
            }
            catch (Exception e) {
                TokenStorageSwitchTest.this.logAndFail("Unable to check token validity", e);
            }
        }

        @Override
        public void run() {
            String token = null;
            if (TokenStorageSwitchTest.this.waitForBarrier()) {
                try {
                    UserAuthenticationContext authContext = new UserAuthenticationContext();
                    authContext.setApplication("tokentest");
                    authContext.setName(TokenStorageSwitchTest.this.getUsername(this.userNumber));
                    authContext.setCredential(TokenStorageSwitchTest.this.getNewPasswordCredential(TokenStorageSwitchTest.this.getUsername(this.userNumber)));
                    authContext.setValidationFactors(TokenStorageSwitchTest.this.getValidationFactors(TokenStorageSwitchTest.this.getUsername(this.userNumber)));
                    token = TokenStorageSwitchTest.this.getSSC().authenticatePrincipal(authContext);
                    TestCase.assertNotNull((String)"Principal token should not have been null", (Object)token);
                }
                catch (Exception e) {
                    TokenStorageSwitchTest.this.logAndFail("Unable to authenticate principal #" + this.userNumber + ": ", e);
                }
                while (!TokenStorageSwitchTest.this.endOfPhase) {
                    this.assertTokenIsValid(token);
                }
                this.assertTokenIsValid(token);
            }
            TokenStorageSwitchTest.this.waitForBarrier();
        }
    }
}

