/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client.load;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.Action;
import com.atlassian.crowd.acceptance.utils.ActionRunner;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.rmi.RemoteException;
import java.util.Properties;

public class TokenValidationLoadTest
extends CrowdAcceptanceTestCase {
    private static final int THREADS = 5;
    private static final int ITERATIONS_PER_THREAD = 30;
    private SecurityServerClientImpl securityServerClient;
    private UserAuthenticationContext userAuthenticationContext;
    private Properties sscProperties;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("tokenauthenticationtest.xml");
        this.sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)this.sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }

    public void testHammerTokenValidation() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, InterruptedException, ExpiredCredentialException {
        this.log("Running testHammerTokenValidation");
        ValidationFactor validationFactor = new ValidationFactor("remote_address", "127.0.0.1");
        final ValidationFactor[] validationFactors = new ValidationFactor[]{validationFactor};
        this.userAuthenticationContext.setName("user");
        this.userAuthenticationContext.setCredential(new PasswordCredential("user"));
        this.userAuthenticationContext.setValidationFactors(validationFactors);
        final String token = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        Action action = new Action(){

            @Override
            public void execute() throws Exception {
                TokenValidationLoadTest.this.securityServerClient.isValidToken(token, validationFactors);
            }
        };
        ActionRunner runner = new ActionRunner(5, 30, action);
        runner.execute();
        if (runner.getFailures() > 0) {
            TokenValidationLoadTest.fail((String)("" + runner.getFailures() + " of the " + 150 + " iterations failed"));
        }
    }
}

