/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client.load;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.BulkAddFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPPrincipalWithCredential;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

public class SecurityServerClientBulkAddTest
extends CrowdAcceptanceTestCase {
    private SecurityServerClientImpl securityServerClient;
    private UserAuthenticationContext userAuthenticationContext;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("tokenauthenticationtest.xml");
        this.intendToModifyData();
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }

    public static void setFullName(String fullname, SOAPPrincipal principal) {
        SecurityServerClientBulkAddTest.setProperty("displayName", fullname, principal);
    }

    public static void setEmail(String email, SOAPPrincipal principal) {
        SecurityServerClientBulkAddTest.setProperty("mail", email, principal);
    }

    public static void setProperty(String property, String value, SOAPPrincipal principal) {
        ArrayList<SOAPAttribute> newAttributes = new ArrayList<SOAPAttribute>();
        SOAPAttribute[] existingAttributes = principal.getAttributes();
        if (existingAttributes != null) {
            newAttributes.addAll(Arrays.asList(existingAttributes));
        }
        if ("displayName".equals(property)) {
            SecurityServerClientBulkAddTest.addOrReplaceAttribute(newAttributes, new SOAPAttribute("displayName", value));
            SecurityServerClientBulkAddTest.addOrReplaceAttribute(newAttributes, new SOAPAttribute("givenName", " "));
            SecurityServerClientBulkAddTest.addOrReplaceAttribute(newAttributes, new SOAPAttribute("sn", " "));
        } else {
            SecurityServerClientBulkAddTest.addOrReplaceAttribute(newAttributes, new SOAPAttribute(property, value));
        }
        principal.setAttributes(newAttributes.toArray(new SOAPAttribute[newAttributes.size()]));
    }

    private static void addOrReplaceAttribute(Collection<SOAPAttribute> attributes, SOAPAttribute newAttribute) {
        SecurityServerClientBulkAddTest.assertNotNull(attributes);
        SecurityServerClientBulkAddTest.assertNotNull((Object)newAttribute);
        SecurityServerClientBulkAddTest.assertNotNull((Object)newAttribute.getName());
        SecurityServerClientBulkAddTest.assertNotNull((Object)newAttribute.getValues());
        boolean replaced = false;
        for (SOAPAttribute existingAttribute : attributes) {
            if (!newAttribute.getName().equals(existingAttribute.getName())) continue;
            existingAttribute.setValues(new String[]{newAttribute.getValues()[0]});
        }
        if (!replaced) {
            attributes.add(newAttribute);
        }
    }

    public void testBulkAddToTwoDirectories() throws Exception {
        ArrayList<SOAPPrincipalWithCredential> principalWithCredentials = new ArrayList<SOAPPrincipalWithCredential>();
        for (int i = 0; i < 1000; ++i) {
            SOAPPrincipal sOAPPrincipal = new SOAPPrincipal("user" + i);
            SecurityServerClientBulkAddTest.setFullName("user" + i + "test", sOAPPrincipal);
            SecurityServerClientBulkAddTest.setEmail("user" + i + "@localhost", sOAPPrincipal);
            SOAPPrincipalWithCredential principalWithCredential = new SOAPPrincipalWithCredential(sOAPPrincipal, PasswordCredential.unencrypted((String)("user" + i)));
            principalWithCredentials.add(principalWithCredential);
        }
        this.setApplication("dir3_dir4_app ", "admin");
        this.securityServerClient.addAllPrincipals(principalWithCredentials);
        this.setApplication("dir3_app", "admin");
        for (SOAPPrincipalWithCredential sOAPPrincipalWithCredential : principalWithCredentials) {
            SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalByName(sOAPPrincipalWithCredential.getPrincipal().getName());
            SecurityServerClientBulkAddTest.assertEquals((String)sOAPPrincipalWithCredential.getPrincipal().getName(), (String)soapPrincipal.getName());
        }
        this.setApplication("dir4_app", "admin");
        for (SOAPPrincipalWithCredential sOAPPrincipalWithCredential : principalWithCredentials) {
            try {
                this.securityServerClient.findPrincipalByName(sOAPPrincipalWithCredential.getPrincipal().getName());
                SecurityServerClientBulkAddTest.fail((String)"UserNotFoundException expected");
            }
            catch (UserNotFoundException ex) {
                SecurityServerClientBulkAddTest.assertEquals((String)("User <" + sOAPPrincipalWithCredential.getPrincipal().getName() + "> does not exist"), (String)ex.getMessage());
            }
        }
    }

    public void testBulkUserCreation() throws Exception {
        SOAPPrincipalWithCredential principalWithCredential;
        SOAPPrincipal principal;
        int i;
        ArrayList<SOAPPrincipalWithCredential> principalWithCredentials = new ArrayList<SOAPPrincipalWithCredential>();
        for (i = 0; i < 1000; ++i) {
            principal = new SOAPPrincipal("usertest" + i);
            SecurityServerClientBulkAddTest.setFullName("user" + i + "test", principal);
            SecurityServerClientBulkAddTest.setEmail("user" + i + "@localhost", principal);
            principalWithCredential = new SOAPPrincipalWithCredential(principal, PasswordCredential.unencrypted((String)("user" + i)));
            principalWithCredentials.add(principalWithCredential);
        }
        this.securityServerClient.addAllPrincipals(principalWithCredentials);
        principalWithCredentials = new ArrayList();
        for (i = 1000; i < 2000; ++i) {
            principal = new SOAPPrincipal("usertest" + i);
            SecurityServerClientBulkAddTest.setFullName("user" + i + "test", principal);
            SecurityServerClientBulkAddTest.setEmail("user" + i + "@localhost", principal);
            principalWithCredential = new SOAPPrincipalWithCredential(principal, PasswordCredential.unencrypted((String)("user" + i)));
            principalWithCredentials.add(principalWithCredential);
        }
        this.securityServerClient.addAllPrincipals(principalWithCredentials);
    }

    public void testBulkUserCreationFailedUsersExist() throws Exception {
        SOAPPrincipalWithCredential principalWithCredential;
        SOAPPrincipal principal;
        int i;
        ArrayList<SOAPPrincipalWithCredential> principalWithCredentials = new ArrayList<SOAPPrincipalWithCredential>();
        for (i = 0; i < 900; ++i) {
            principal = new SOAPPrincipal("usertest" + i);
            SecurityServerClientBulkAddTest.setFullName("user" + i + "test", principal);
            SecurityServerClientBulkAddTest.setEmail("user" + i + "@localhost", principal);
            principalWithCredential = new SOAPPrincipalWithCredential(principal, PasswordCredential.unencrypted((String)("user" + i)));
            principalWithCredentials.add(principalWithCredential);
        }
        this.securityServerClient.addAllPrincipals(principalWithCredentials);
        principalWithCredentials = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            principal = new SOAPPrincipal("usertest" + i);
            SecurityServerClientBulkAddTest.setFullName("user" + i + "test", principal);
            SecurityServerClientBulkAddTest.setEmail("user" + i + "@localhost", principal);
            principalWithCredential = new SOAPPrincipalWithCredential(principal, PasswordCredential.unencrypted((String)("user" + i)));
            principalWithCredentials.add(principalWithCredential);
        }
        try {
            this.securityServerClient.addAllPrincipals(principalWithCredentials);
            SecurityServerClientBulkAddTest.fail((String)"BulkAddFailedException expected!");
        }
        catch (BulkAddFailedException ex) {
            SecurityServerClientBulkAddTest.assertEquals((int)900, (int)ex.getExistingUsers().size());
            SecurityServerClientBulkAddTest.assertEquals((int)0, (int)ex.getFailedUsers().size());
        }
        for (int i2 = 900; i2 < 1000; ++i2) {
            String username = "usertest" + i2;
            SOAPPrincipal principal2 = this.securityServerClient.findPrincipalByName(username);
            SecurityServerClientBulkAddTest.assertEquals((String)username, (String)principal2.getName());
        }
    }

    public void testBulkUserCreationFailedNoPermission() throws Exception {
        this.setApplication("bulk-create-app", "admin");
        ArrayList<SOAPPrincipalWithCredential> principalWithCredentials = new ArrayList<SOAPPrincipalWithCredential>();
        for (int i = 0; i < 1000; ++i) {
            SOAPPrincipal principal = new SOAPPrincipal("usertest" + i);
            SecurityServerClientBulkAddTest.setFullName("user" + i + "test", principal);
            SecurityServerClientBulkAddTest.setEmail("user" + i + "@localhost", principal);
            SOAPPrincipalWithCredential principalWithCredential = new SOAPPrincipalWithCredential(principal, PasswordCredential.unencrypted((String)("user" + i)));
            principalWithCredentials.add(principalWithCredential);
        }
        try {
            this.securityServerClient.addAllPrincipals(principalWithCredentials);
            SecurityServerClientBulkAddTest.fail((String)"ApplicationPermissionException expected!");
        }
        catch (ApplicationPermissionException e) {
            SecurityServerClientBulkAddTest.assertEquals((String)"Application 'bulk-create-app' has no directories that allow adding of users.", (String)e.getMessage());
        }
    }

    private void setApplication(String applicationName, String password) {
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        sscProperties.setProperty("application.password", password);
        sscProperties.setProperty("application.name", applicationName);
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }
}

