/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class XFireGzipTest
extends CrowdAcceptanceTestCase {
    private AuthenticateApplicationProxy startUpFakeCrowd() throws IOException {
        AuthenticateApplicationProxy socketListener = new AuthenticateApplicationProxy();
        Thread tSocketListener = new Thread((Runnable)socketListener, "CrowdSocketListener");
        tSocketListener.start();
        return socketListener;
    }

    private SecurityServerClient createCrowdClient(String serverURL) {
        Properties properties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        properties.remove("crowd.server.url");
        properties.setProperty("crowd.server.url", serverURL);
        SoapClientPropertiesImpl clientProperties = SoapClientPropertiesImpl.newInstanceFromPropertiesWithoutOverrides((Properties)properties);
        return new SecurityServerClientImpl((SoapClientProperties)clientProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClientHeaders() throws Exception {
        this.log("Running testClientHeaders");
        AuthenticateApplicationProxy socketListener = this.startUpFakeCrowd();
        String url = "http://localhost:" + socketListener.getListenerPort() + "/crowd/services/";
        SecurityServerClient crowdClient = this.createCrowdClient(url);
        try {
            crowdClient.authenticate();
        }
        catch (InvalidAuthorizationTokenException tokenEx) {
        }
        catch (Exception e) {
            throw new RuntimeException("Client can't authenticate to our socket server at:" + url, e);
        }
        List<String> headerList = socketListener.getHeaders();
        XFireGzipTest.assertFalse((String)"Request should have been recorded", (boolean)headerList.isEmpty());
        StringBuilder concatedHeadersBuffer = new StringBuilder();
        int countOfUserAgentString = 0;
        for (String headerline : headerList) {
            if (headerline.toLowerCase(Locale.ENGLISH).matches("^user-agent:.*")) {
                ++countOfUserAgentString;
            }
            if (headerline.toLowerCase(Locale.ENGLISH).matches("^expect:.*")) continue;
            concatedHeadersBuffer.append(headerline).append("\n");
        }
        String concatedHeaders = concatedHeadersBuffer.toString();
        XFireGzipTest.assertEquals((String)"User-Agent must appear once only in Headers", (int)1, (int)countOfUserAgentString);
        this.addRequestHeader("Accept-Encoding", "gzip");
        this.closeBrowser();
        this.beginAt(URL_HOME);
        this._loginAdminUser();
        this.gotoGeneral();
        this.checkCheckbox("gzip");
        this.submit();
        this.gotoGeneral();
        this.assertServerResponseContains("\nContent-Encoding: gzip\n");
        this.assertCheckboxSelected("gzip");
        Socket clientSocket = null;
        DataOutputStream out = null;
        DataInputStream in = null;
        BufferedReader serverResults = null;
        try {
            String serverResponse;
            URL baseURL = this.getTestContext().getBaseUrl();
            clientSocket = new Socket(baseURL.getHost(), baseURL.getPort());
            out = new DataOutputStream(clientSocket.getOutputStream());
            in = new DataInputStream(clientSocket.getInputStream());
            concatedHeaders = "GET /crowd/services/SecurityServer?wsdl HTTP/1.1\n" + concatedHeaders;
            this.log("Client headers generated (expect header stripped): \n" + concatedHeaders);
            out.writeBytes(concatedHeaders + "\n");
            serverResults = new BufferedReader(new InputStreamReader(in));
            boolean gzipEncodingOn = false;
            StringBuilder serverResponseBuffer = new StringBuilder();
            while ((serverResponse = serverResults.readLine()) != null) {
                serverResponseBuffer.append(serverResponse).append("\n");
                if (serverResponse.toLowerCase(Locale.ENGLISH).equals("content-encoding: gzip")) {
                    gzipEncodingOn = true;
                }
                if (!serverResponse.equals("")) continue;
            }
            this.log("Crowd server reponse to headers: \n" + serverResponseBuffer.toString());
            XFireGzipTest.assertEquals((String)"Content Encoding is GZIP enabled", (boolean)true, (boolean)gzipEncodingOn);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(serverResults);
            IOUtils.closeQuietly(clientSocket);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((Reader)serverResults);
        IOUtils.closeQuietly((Socket)clientSocket);
    }

    public class AuthenticateApplicationProxy
    implements Runnable {
        protected final ServerSocket connection;
        protected Socket clientSocket;
        protected final List<String> headers = Collections.synchronizedList(new ArrayList());
        protected final String authAppSOAPResponse = "HTTP/1.1 200 OK\nContent-Type: text/xml;charset=UTF-8\n\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><ns1:authenticateApplicationResponse xmlns:ns1=\"urn:SecurityServer\"><ns1:out><name xmlns=\"http://authentication.integration.crowd.atlassian.com\">bamboo-connect</name><token xmlns=\"http://authentication.integration.crowd.atlassian.com\">qkzPvczkQgyYdNwYSzk1jw00</token></ns1:out></ns1:authenticateApplicationResponse></soap:Body></soap:Envelope>";

        public AuthenticateApplicationProxy() throws IOException {
            this.clientSocket = new Socket();
            this.connection = new ServerSocket();
            this.connection.bind(null);
        }

        public int getListenerPort() {
            return this.connection.getLocalPort();
        }

        public List<String> getHeaders() {
            return ImmutableList.copyOf(this.headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block11: {
                DataInputStream in = null;
                PrintStream out = null;
                BufferedReader inputReader = null;
                this.clientSocket = this.connection.accept();
                in = new DataInputStream(this.clientSocket.getInputStream());
                out = new PrintStream(this.clientSocket.getOutputStream());
                inputReader = new BufferedReader(new InputStreamReader(in));
                String line = inputReader.readLine();
                while (StringUtils.isNotBlank((CharSequence)(line = inputReader.readLine()))) {
                    this.headers.add(line);
                }
                out.println("HTTP/1.1 200 OK\nContent-Type: text/xml;charset=UTF-8\n\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><ns1:authenticateApplicationResponse xmlns:ns1=\"urn:SecurityServer\"><ns1:out><name xmlns=\"http://authentication.integration.crowd.atlassian.com\">bamboo-connect</name><token xmlns=\"http://authentication.integration.crowd.atlassian.com\">qkzPvczkQgyYdNwYSzk1jw00</token></ns1:out></ns1:authenticateApplicationResponse></soap:Body></soap:Envelope>");
                IOUtils.closeQuietly((Reader)inputReader);
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((Socket)this.clientSocket);
                try {
                    this.connection.close();
                }
                catch (IOException e) {}
                break block11;
                catch (IOException ioEx) {
                    try {
                        ioEx.printStackTrace();
                        TestCase.fail((String)ioEx.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputReader);
                        IOUtils.closeQuietly(out);
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly((Socket)this.clientSocket);
                        try {
                            this.connection.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    IOUtils.closeQuietly(inputReader);
                    IOUtils.closeQuietly(out);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((Socket)this.clientSocket);
                    try {
                        this.connection.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

