/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthenticationWorker
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SecurityServerClient securityServerClient;
    private final UserAuthenticationContext userAuthenticationContext;
    private final int iterations;
    private int failures;

    AuthenticationWorker(SecurityServerClient securityServerClient, UserAuthenticationContext userAuthenticationContext, int iterations) {
        this.securityServerClient = securityServerClient;
        this.userAuthenticationContext = userAuthenticationContext;
        this.iterations = iterations;
        this.failures = 0;
    }

    @Override
    public void run() {
        for (int i = 0; i < this.iterations; ++i) {
            try {
                this.logger.info("Authenticating: " + i);
                String token = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
                if (token != null) continue;
                ++this.failures;
                continue;
            }
            catch (Exception e) {
                this.logger.warn("Failed to authenticate", (Throwable)e);
                ++this.failures;
            }
        }
    }

    public boolean hasFailures() {
        return this.failures > 0;
    }

    public int getFailures() {
        return this.failures;
    }
}

