/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.demo;

import com.atlassian.crowd.acceptance.tests.applications.demo.DemoAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import java.util.Properties;

public class AddGroupTest
extends DemoAcceptanceTestCase {
    private static final String TEST_GROUP_NAME = "test-group";
    private static final String TEST_GROUP_DESCRIPTION = "Test Description";
    LDAPLoader loader = new LDAPLoader();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loader.accessibleSetUp();
        this.restoreCrowdFromXML("viewgrouptest.xml");
        this._loginAdminUser();
    }

    @Override
    public void tearDown() throws Exception {
        this.loader.accessibleTearDown();
        super.tearDown();
    }

    protected void addGroup() {
        this.intendToModifyData();
        this.gotoPage("/secure/group/browsegroups.action");
        this.clickLink("add-group");
        this.setTextField("name", TEST_GROUP_NAME);
        this.setTextField("groupDescription", TEST_GROUP_DESCRIPTION);
        this.checkCheckbox("active");
        this.submit();
    }

    public void testAddGroup() {
        this.intendToModifyData();
        this.log("Running testAddGroup");
        this.addGroup();
        this.assertKeyPresent("menu.viewgroup.label", TEST_GROUP_NAME);
        this.assertTextFieldEquals("groupDescription", TEST_GROUP_DESCRIPTION);
        this.assertCheckboxSelected("active");
    }

    public void testUpdateGroup() {
        this.intendToModifyData();
        this.log("Running testUpdateGroup");
        this.gotoPage("/secure/group/browsegroups.action");
        this.clickLink("view-group-crowd-administrators");
        this.setTextField("groupDescription", TEST_GROUP_DESCRIPTION);
        this.submit();
        this.assertTextFieldEquals("groupDescription", TEST_GROUP_DESCRIPTION);
    }

    public void testRemoveGroup() {
        this.intendToModifyData();
        this.log("Running testRemoveGroup");
        this.addGroup();
        this.assertKeyPresent("menu.viewgroup.label", TEST_GROUP_NAME);
        this.assertTextPresent(TEST_GROUP_NAME);
        this.clickLink("remove-group");
        this.submit();
        this.assertKeyPresent("browser.group.title");
        this.assertTextNotPresent(TEST_GROUP_NAME);
    }

    class LDAPLoader
    extends BaseTest {
        LDAPLoader() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }

        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("ldap.basedn", directorySettings.getProperty("test.integration.basedn"));
        }

        @Override
        protected void loadTestData() throws Exception {
        }

        @Override
        protected void removeTestData() throws DirectoryInstantiationException {
            DirectoryTestHelper.silentlyRemoveGroup(AddGroupTest.TEST_GROUP_NAME, this.getRemoteDirectory());
        }

        public void accessibleSetUp() throws Exception {
            super.setUp();
        }

        public void accessibleTearDown() throws Exception {
            super.tearDown();
        }
    }
}

