/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowdid.server;

import com.atlassian.crowd.acceptance.tests.applications.crowdid.server.CrowdIDServerAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jwebunit.exception.TestingEngineResponseException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.junit.Assert;

public class OpenIDServerTest
extends CrowdIDServerAcceptanceTestCase {
    protected static String OPENIDSERVER_LOGIN_URL_ADMIN;
    protected static String OPENID_CLIENT_LOGIN;
    protected static String OPENID_SERVER_URL;
    protected static final String CLIENT_NAME = "crowdidclient";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.loginToCrowd();
        this.restoreCrowdFromXML("openidauthtest.xml");
        this.logoutFromCrowd();
        this.specProperties = AcceptanceTestHelper.loadProperties("localtest.properties");
        String client_port = this.getTestProperty("crowdidclient.port");
        String client_context = this.getTestProperty("crowdidclient.context");
        String client_rootUrl = "http://" + this.getTestProperty("host.location") + ":" + client_port;
        String server_port = this.getTestProperty(this.getApplicationName() + ".port");
        String server_context = this.getTestProperty(this.getApplicationName() + ".context");
        String server_rootUrl = "http://" + this.getTestProperty("host.location") + ":" + server_port;
        OPENID_CLIENT_LOGIN = client_rootUrl + client_context;
        OPENID_SERVER_URL = server_rootUrl + server_context;
        OPENIDSERVER_LOGIN_URL_ADMIN = OPENID_SERVER_URL + "/users/" + "admin";
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testProfile() {
        this.log("Running testProfile");
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLink("myprofiles");
        this.assertKeyPresent("profiles.select.title");
        this.selectOptionByValue("profileID", "-1");
        this.setTextField("profileName", "");
        this.submit();
        this.assertKeyPresent("profiles.nameempty.error");
        this.setTextField("profileName", "My Profile");
        this.submit();
        this.assertKeyPresent("exception.profile.already.exists");
        this.setTextField("profileName", "Test Profile");
        this.assertTextFieldEquals("nickname", "admin");
        this.setTextField("nickname", "tester");
        this.assertTextFieldEquals("fullName", "Super User");
        this.setTextField("fullName", "Test User");
        this.assertTextFieldEquals("email", "admin@example.com");
        this.setTextField("email", "test@example.com");
        this.selectOption("dobDay", "1");
        this.selectOption("dobMonth", "April");
        this.selectOption("dobYear", "1990");
        this.submit();
        this.assertKeyPresent("profiles.updated.message");
        this.clickLink("resumeauthentication");
        this.selectOption("profileID", "Test Profile");
        this.assertTextInTable("attributeTable", new String[]{"Nickname", "tester"});
        this.assertTextInTable("attributeTable", new String[]{"Full Name", "Test User"});
        this.assertTextInTable("attributeTable", new String[]{"Email", "test@example.com"});
        this.assertTextInTable("attributeTable", new String[]{"Birth Date", "1 April 1990"});
        this.gotoPage(OPENID_SERVER_URL);
        this.clickLink("myprofiles");
        this.selectOption("profileID", "Test Profile");
        this.clickButtonWithText("Delete");
        this.assertKeyPresent("profiles.deleted.message");
    }

    public void testApprovedSites() {
        this.log("Running testApprovedSites");
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLink("mysites");
        this.assertKeyPresent("allow.nosites.label");
        this.clickLink("resumeauthentication");
        this.clickLink("allowAlways");
        this.gotoPage(OPENID_SERVER_URL);
        this.clickLink("mysites");
        this.assertKeyPresent("allow.siteurl.label");
        this.assertTextPresent(OPENID_CLIENT_LOGIN);
        this.clickElementByXPath("//img[@id='removeSite-0']");
        this.assertTextNotPresent(OPENID_CLIENT_LOGIN);
        this.clickButtonWithText("Apply");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertKeyPresent("allow.nosites.label");
    }

    public void testLoginHistory() {
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLink("allow");
        this.clickLinkWithExactText("Log Out");
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.clickLink("deny");
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.clickLink("allowAlways");
        this.clickLinkWithExactText("Log Out");
        this.gotoPage(OPENID_SERVER_URL);
        this.clickLink("activity");
        this.assertKeyPresent("authaction.allow.label");
        this.assertKeyPresent("authaction.deny.label");
        this.assertKeyPresent("authaction.allowalways.label");
        this.clickLink("mysites");
        this.assertKeyPresent("allow.siteurl.label");
        this.assertTextPresent(OPENID_CLIENT_LOGIN);
        this.clickElementByXPath("//img[@id='removeSite-0']");
        this.assertTextNotPresent(OPENID_CLIENT_LOGIN);
        this.clickButtonWithText("Apply");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertKeyPresent("allow.nosites.label");
    }

    public void testAdminTrustRelationships() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLinkWithExactText("Administration");
        this.clickLink("loginrestrictions");
        this.assertKeyPresent("trusts.label");
        this.clickRadioOption("trustType", "2");
        this.assertKeyPresent("blacklisthost.label");
        String otherHostname = "127.0.0.2";
        this.setTextField("address", "localhost");
        this.submit();
        this.setTextField("address", otherHostname);
        this.submit();
        this.assertTextInTable("addressesTable", new String[]{"localhost", "Remove"});
        this.assertTextInTable("addressesTable", new String[]{otherHostname, "Remove"});
        this.clickLink("remove-1");
        this.assertTextInTable("addressesTable", new String[]{"localhost", "Remove"});
        this.assertTextNotInTable("addressesTable", otherHostname);
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.assertKeyPresent("allow.error.title");
        this.clickLinkWithExactText("Administration");
        this.clickLink("loginrestrictions");
        this.assertKeyPresent("trusts.label");
        this.clickRadioOption("trustType", "1");
        this.assertKeyPresent("whitelisthost.label");
        this.assertTextInTable("addressesTable", new String[]{"localhost", "Remove"});
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.assertKeyPresent("allow.auth.title");
        this.clickLinkWithExactText("Administration");
        this.clickLink("loginrestrictions");
        this.clickLink("remove-0");
        this.clickRadioOption("trustType", "0");
    }

    public void testInternalOpenIDProfilePageShowsURLInEncodedFormat() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "john.t\u00f8stin\u00f3g\u00e9");
        this.setTextField("password", "john");
        this.submit();
        this.clickLinkWithText("My OpenID");
        String expectedUri = OPENID_SERVER_URL + "/users/" + "john.t%C3%B8stin%C3%B3g%C3%A9";
        Assert.assertThat((Object)this.getElementTextByXPath("//div[@class='identity-bar']"), (org.hamcrest.Matcher)IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)expectedUri));
    }

    public void testViewPublicProfilePageWithEncodedCharactersShowsOpenIdUrlInEncodedFormat() {
        this.gotoPage(OPENID_SERVER_URL + "/users/" + "john.t%C3%B8stin%C3%B3g%C3%A9");
        String expectedUri = OPENID_SERVER_URL + "/users/" + "john.t%C3%B8stin%C3%B3g%C3%A9";
        Assert.assertThat((Object)this.getElementTextByXPath("//div[@class='identity-bar']"), (org.hamcrest.Matcher)IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)expectedUri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditProfilesXsrfProtectionRejectsActionWithNoXsrfToken() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.tester.setIgnoreFailingStatusCodes(true);
        try {
            this.gotoPage(OPENID_SERVER_URL + "/secure/profile/editprofiles!update.action");
            OpenIDServerTest.assertTrue((boolean)this.getPageSource().contains("warningBox"));
            OpenIDServerTest.assertTrue((boolean)this.getPageSource().contains(this.getMessage("atlassian.xwork.xsrf.notoken")));
        }
        finally {
            this.tester.setIgnoreFailingStatusCodes(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditProfilesSetDefaultProfileForUserIsCsrfProtected() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.tester.setIgnoreFailingStatusCodes(true);
        try {
            this.gotoPage(OPENID_SERVER_URL + "/secure/profile/editprofiles!makeDefault.action");
            OpenIDServerTest.assertTrue((boolean)this.getPageSource().contains("warningBox"));
            OpenIDServerTest.assertTrue((boolean)this.getPageSource().contains(this.getMessage("atlassian.xwork.xsrf.notoken")));
        }
        finally {
            this.tester.setIgnoreFailingStatusCodes(false);
        }
    }

    public void testEditProfilesCanSetNewDefaultProfileForUser() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.gotoPage(OPENID_SERVER_URL + "/secure/profile/editprofiles.action");
        this.selectOption("profileID", "-- Create New Profile --");
        this.setTextField("profileName", "Second Profile");
        this.submit();
        this.clickLinkWithExactText("Make Default");
        this.assertTextPresent("Second Profile (default)");
    }

    public void testRejectedAuthenticationRepeatsCorrectlyEncodedUsername() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "john.t\u00f8stin\u00f3g\u00e9");
        this.setTextField("password", "");
        this.submit();
        this.assertWarningPresent();
        this.assertTextFieldEquals("username", "john.t\u00f8stin\u00f3g\u00e9");
        this.assertTextFieldEquals("password", "");
    }

    public void testFooterShowsVersion() {
        this.gotoPage(OPENID_SERVER_URL);
        String poweredBy = this.getElementTextByXPath("id('footer')/p");
        Assert.assertThat((Object)poweredBy, (org.hamcrest.Matcher)Matchers.startsWith((String)"Powered by Atlassian CrowdID Version:"));
        String version = poweredBy.replaceFirst(".*?:\\s+", "");
        Assert.assertThat((Object)version, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.isEmptyString()));
    }

    public void testEditProfilesPageCorrectlyEscapesProfileNameToProtectAgainstPersistedXSS() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.gotoPage(OPENID_SERVER_URL + "/secure/profile/editprofiles.action");
        this.selectOption("profileID", "-- Create New Profile --");
        this.setTextField("profileName", "profileNameDoubleEscape&amp;XssTest<script>alert(1)</script>");
        this.submit();
        Assert.assertThat((Object)this.getPageSource(), (org.hamcrest.Matcher)Matchers.containsString((String)"profileNameDoubleEscape&amp;amp;XssTest&lt;script&gt;alert(1)&lt;/script&gt;"));
    }

    public void testEditProfilesPageIsNotVulnerableToReflectedXSS() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.gotoPage(OPENID_SERVER_URL + "/secure/profile/editprofiles.action" + "?warning=escapeWarning<script>alert(1);</script>" + "&description=escapeDescription<script>alert(2);</script>");
        String pageSource = this.getPageSource();
        Assert.assertThat((Object)pageSource, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"escapeWarning<script>alert(1);</script>")));
        Assert.assertThat((Object)pageSource, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"escapeDescription<script>alert(2);</script>")));
    }

    public void testIncludeFilesAreNotDirectlyAccessible() {
        try {
            this.gotoPage(OPENID_SERVER_URL + "/include/nonExistentFile.jsp");
            OpenIDServerTest.fail((String)"/include/* files should be inaccessible before login");
        }
        catch (TestingEngineResponseException e) {
            Assert.assertThat((Object)e.getMessage(), (org.hamcrest.Matcher)Matchers.containsString((String)"unexpected status code [403]"));
        }
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        try {
            this.gotoPage(OPENID_SERVER_URL + "/include/nonExistentFile.jsp");
            OpenIDServerTest.fail((String)"/include/* files should still be inaccessible after login");
        }
        catch (TestingEngineResponseException e) {
            Assert.assertThat((Object)e.getMessage(), (org.hamcrest.Matcher)Matchers.containsString((String)"unexpected status code [403]"));
        }
    }

    private long getProfileIdForAdmin() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLink("myprofiles");
        this.assertKeyPresent("profiles.select.title");
        Matcher m = Pattern.compile("\\?profileID=(\\d+)(?!\\d)").matcher(this.getPageSource());
        OpenIDServerTest.assertTrue((boolean)m.find());
        String profileIdStr = m.group(1);
        this.gotoPage(OPENID_SERVER_URL + "/logoff.action");
        this.assertKeyPresent("login.title");
        return Long.parseLong(profileIdStr);
    }

    public void testUnableToViewProfileForAnotherUser() {
        long profileId = this.getProfileIdForAdmin();
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "john.t\u00f8stin\u00f3g\u00e9");
        this.setTextField("password", "john");
        this.submit();
        this.gotoPage(OPENID_SERVER_URL + "/secure/profile/editprofiles.action?profileID=" + profileId);
        this.assertKeyPresent("exception.profile.access.violation.exception");
    }

    public void testUnableToEditProfileForAnotherUser() {
        long profileId = this.getProfileIdForAdmin();
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "john.t\u00f8stin\u00f3g\u00e9");
        this.setTextField("password", "john");
        this.submit();
        this.gotoPage(OPENID_SERVER_URL + "/secure/profile/editprofiles.action");
        Matcher m = Pattern.compile("atl_token=(.*)'").matcher(this.getPageSource());
        OpenIDServerTest.assertTrue((boolean)m.find());
        String token = m.group(1);
        this.gotoPage(OPENID_SERVER_URL + "/secure/profile/editprofiles!update.action?profileID=" + profileId + "&nickname=Modified" + "&atl_token=" + token);
        this.assertKeyPresent("exception.profile.access.violation.exception");
        this.assertKeyNotPresent("profiles.updated.message");
        this.gotoPage(OPENID_SERVER_URL + "/logoff.action");
        this.assertKeyPresent("login.title");
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLink("myprofiles");
        this.assertKeyPresent("profiles.select.title");
        this.assertTextInElement("nickname", "admin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoginPageHasCsrfProtection() throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(OPENID_SERVER_URL + "/login!update.action");
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (org.hamcrest.Matcher)Matchers.equalTo((Object)403));
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    public void testAboutPageAccessible() {
        this.gotoPage(OPENID_SERVER_URL + "/about.jsp");
        this.assertKeyPresent("about.title");
    }
}

