/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowdid;

import com.atlassian.crowd.acceptance.tests.applications.crowdid.CrowdIDAcceptanceTestCase;
import com.google.inject.internal.Function;
import com.google.inject.internal.Iterables;
import java.util.List;
import net.sourceforge.jwebunit.api.IElement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;

public class PublicIdentityTest
extends CrowdIDAcceptanceTestCase {
    private static final Function<IElement, String> elementToTextContent = new Function<IElement, String>(){

        public String apply(IElement from) {
            return from.getTextContent();
        }
    };

    private String getIdentity() {
        String identity = this.getElementTextByXPath("//div[@class='identity-bar']");
        PublicIdentityTest.assertNotNull((Object)identity);
        return identity;
    }

    public void testPublicIdentityPage() {
        this.log("Running testPublicIdentityPage");
        String username = "schmuck";
        this.gotoPage("/users/" + username);
        this.assertKeyPresent("identity.title");
        this.assertTextPresent(username);
        PublicIdentityTest.assertEquals((String)(this.getBaseUrl() + "/users/schmuck"), (String)this.getIdentity());
    }

    void assertDiscoveryLeadsToCorrectIdentifierShown(String relativePath, String expectedRelativePathInIdentifier) {
        this.gotoPage(relativePath);
        PublicIdentityTest.assertEquals((String)(this.getBaseUrl() + expectedRelativePathInIdentifier), (String)this.getIdentity());
    }

    void assertDiscoveryLeadsToExpectedIdentifier(String relativePath, String expectedRelativePathInIdentifier) throws DiscoveryException {
        this.assertDiscoveryLeadsToCorrectIdentifierShown(relativePath, expectedRelativePathInIdentifier);
        Discovery discovery = new Discovery();
        String userIdentifier = this.getBaseUrl() + relativePath;
        List discoveries = discovery.discover(userIdentifier);
        String expectedIdentifier = this.getBaseUrl() + expectedRelativePathInIdentifier;
        Assert.assertThat((Object)discoveries, (Matcher)CoreMatchers.hasItem(PublicIdentityTest.openIdWithVersionAndDelegateId("http://openid.net/signon/1.1", expectedIdentifier)));
        Assert.assertThat((Object)discoveries, (Matcher)CoreMatchers.hasItem(PublicIdentityTest.openIdWithVersionAndDelegateId("http://specs.openid.net/auth/2.0/signon", expectedIdentifier)));
    }

    public void testPublicIdentityEscapesAtSigns() throws Exception {
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/user@host", "/users/user@host");
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/user%40host", "/users/user@host");
    }

    public void testPublicIdentityAcceptsPlusSignsLiterally() throws Exception {
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/user+host", "/users/user+host");
    }

    public void testNonCanonicalUrlsShowToCanonicalForm() throws Exception {
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/user%40host", "/users/user@host");
    }

    public void testNonCanonicalUrlsWithUnnecessaryQueriesShowCanonicalFormWithout() throws Exception {
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/name?", "/users/name");
    }

    public void testUrlWithUnencodedSlashesHasCanonicalFormEncoded() throws Exception {
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/not/the/admin", "/users/not%2Fthe%2Fadmin");
    }

    public void testUrlWithHtmlCharactersDiscoveredAsCorrectIdentifier() throws Exception {
        this.assertDiscoveryLeadsToCorrectIdentifierShown("/users/<i>user", "/users/%3Ci%3Euser");
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/&amp;user", "/users/&amp%3Buser");
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/&amp", "/users/&amp");
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/'user", "/users/'user");
    }

    public void testUrlWithNoUserSpecifiedIsStillDiscoverable() throws Exception {
        this.assertDiscoveryLeadsToExpectedIdentifier("/users/", "/users/");
    }

    public static Matcher<DiscoveryInformation> openIdWithVersionAndDelegateId(final String version, final String delegateId) {
        return new TypeSafeMatcher<DiscoveryInformation>(DiscoveryInformation.class){

            public void describeTo(Description desc) {
                desc.appendText("A version '" + version + "' identifier with delegated ID '" + delegateId + "'");
            }

            protected boolean matchesSafely(DiscoveryInformation info) {
                return info.getVersion().equals(version) && info.getDelegateIdentifier().toString().equals(delegateId);
            }
        };
    }

    public void testEndpointUrlIsShown() {
        String opUrl = this.getBaseUrl() + "/op";
        this.gotoPage("/users/username");
        List identityInfo = this.getElementsByXPath("//div[@class='identity-info']");
        Iterable identityInfoText = Iterables.transform((Iterable)identityInfo, elementToTextContent);
        Assert.assertThat((Object)identityInfoText, (Matcher)Matchers.hasItem((Matcher)Matchers.endsWith((String)(": " + opUrl))));
    }
}

