/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.plugin.saml;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import junit.framework.AssertionFailedError;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class SAMLAuthTest
extends CrowdAcceptanceTestCase {
    private static final String SAMPLE_GOOGLE_REQUEST = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<samlp:AuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" ID=\"cliofbcolgkmklnaoeafjjcakpnkblpccdjkpcla\" Version=\"2.0\" IssueInstant=\"2008-07-21T06:22:10Z\" ProtocolBinding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\" ProviderName=\"google.com\" IsPassive=\"false\" AssertionConsumerServiceURL=\"https://www.google.com/a/thanksforcomingin.com/acs\"><saml:Issuer xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">google.com</saml:Issuer><samlp:NameIDPolicy AllowCreate=\"true\" Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\" /></samlp:AuthnRequest>";
    private static final String SAMPLE_GOOGLE_RELAY = "https%3A%2F%2Fwww.google.com%2Fa%2Fthanksforcomingin.com%2FServiceLogin%3Fservice%3Dmail%26passive%3Dtrue%26rm%3Dfalse%26continue%3Dhttp%253A%252F%252Fmail.google.com%252Fa%252Fthanksforcomingin.com%252F%26bsv%3D1k96igf4806cy%26ltmpl%3Ddefault%26ltmplcache%3D2";
    private static final boolean WITHOUT_ZLIB_HEADER = true;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("googletest.xml");
    }

    protected void forgeGoogleRequest() throws IOException {
        this.gotoPage("/console/plugin/secure/saml/samlauth.action?SAMLRequest=" + this.generateGoogleSAMLRequestParameter() + "&RelayState=" + SAMPLE_GOOGLE_RELAY);
    }

    protected void forgeInvalidGoogleRequest() {
        this.gotoPage("/console/plugin/secure/saml/samlauth.action?SAMLRequest=fVLJTsMKNd7FmhP1MDfkpfEBStNJlJ5G40mZnojjY5EePXNWfDqda7Nv8F%2Bs5Z5E4rosi6i4X5SDwEavwN0FdsZrxLqFWGG3sy8kkd4EuJItAWczInA%2BBLxAQ30HbgFuoxU8PtxkvPHekkiS7XYbf8skMvGNNGuq0IVjcNdmjyvi%2BTBkMfR0P6b7fwv5lYLn3z7T5IdU%2Fvl5u07zywJbrd7ZrG1xe%2BFA%2BlDIuz70uULXSf%2B32ygeDYheRdVAFb0hC0pXGlacJfne9feWhN35AA%3D%3D&RelayState=https%3A%2F%2Fwww.google.com%2Fa%2Fthanksforcomingin.com%2FServic%252Fmail.google.com%252Fa%252Fthanksforcomingin.com%252F%26bsv%3D1k96igf4806cy%26ltmpl%3Ddefault%26ltmplcache%3D2");
    }

    protected void ensureNoKeysPresent() {
        this.gotoSAMLConfig();
        try {
            this.assertButtonPresent("keydelButton");
            this.clickButton("keydelButton");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        this.assertButtonNotPresent("keydelButton");
        this.assertKeyPresent("saml.key.none");
    }

    protected void ensureKeysPresent() {
        this.gotoSAMLConfig();
        try {
            this.clickButton("keygenButton");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        this.assertKeyPresent("saml.key.gen.success");
        this.assertButtonPresent("keydelButton");
    }

    public void testAuthWithNoKeysSetup() throws IOException {
        this.log("Running testAuthWithNoKeysSetup");
        this.ensureNoKeysPresent();
        this.forgeGoogleRequest();
        this.assertTextPresent("SAML Error: SAML signature keys have not been set up.");
    }

    public void testAuthWithGarbageRequest() {
        this.log("Running testAuthWithGarbageRequest");
        this.ensureKeysPresent();
        this.forgeInvalidGoogleRequest();
        this.assertTextPresent("SAML Error: Error decoding SAML Authentication Request");
    }

    public void testAuthSuccessSSO() throws IOException {
        this.log("Running testAuthSuccessSSO");
        this.ensureKeysPresent();
        this.forgeGoogleRequest();
        this.verifySAMLResponse();
    }

    public void testAuthSuccessAfterLogin() throws IOException {
        this.log("Running testAuthSuccessAfterLogin");
        this.ensureKeysPresent();
        this._logout();
        this.forgeGoogleRequest();
        this.assertKeyPresent("login.title");
        this.setTextField("j_username", "admin");
        this.setTextField("j_password", "admin");
        this.submit();
        this.verifySAMLResponse();
    }

    protected void verifySAMLResponse() {
        this.assertTextPresent("Oops - an error has occurred");
        this.assertTextPresent("SAMLResponse : &lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;");
        this.assertTextPresent("&lt;samlp:Response xmlns:samlp=&quot;urn:oasis:names:tc:SAML:2.0:protocol&quot; xmlns=&quot;urn:oasis:names:tc:SAML:2.0:assertion&quot; xmlns:xenc=&quot;http://www.w3.org/2001/04/xmlenc#&quot; ID=&quot;");
        this.assertTextPresent("&lt;Signature xmlns=&quot;http://www.w3.org/2000/09/xmldsig#&quot;&gt;&lt;SignedInfo&gt;&lt;CanonicalizationMethod Algorithm=&quot;http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments&quot; /&gt;&lt;SignatureMethod Algorithm=&quot;http://www.w3.org/2000/09/xmldsig#dsa-sha1&quot; /&gt;&lt;Reference URI=&quot;&quot;&gt;&lt;Transforms&gt;&lt;Transform Algorithm=&quot;http://www.w3.org/2000/09/xmldsig#enveloped-signature&quot; /&gt;&lt;/Transforms&gt;&lt;DigestMethod Algorithm=&quot;http://www.w3.org/2000/09/xmldsig#sha1&quot; /&gt;&lt;DigestValue&gt;");
        this.assertTextPresent("&lt;samlp:StatusCode Value=&quot;urn:oasis:names:tc:SAML:2.0:status:Success&quot; /&gt;");
        this.assertTextPresent("&lt;samlp:StatusCode Value=&quot;urn:oasis:names:tc:SAML:2.0:status:Success&quot; /&gt;");
        this.assertTextPresent("&lt;NameID Format=&quot;urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress&quot;&gt;");
        this.assertTextPresent("admin");
    }

    public void assertTextPresent(String text) {
        try {
            if (!this.tester.getPageSource().contains(text)) {
                SAMLAuthTest.fail((String)("Expected text not found in current page: [" + text + "]"));
            }
        }
        catch (AssertionFailedError error) {
            System.err.println("Unable to find " + text + " in:");
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void testGeneratedRequestParameterDecodes() throws Exception {
        String base64 = URLDecoder.decode(this.generateGoogleSAMLRequestParameter(), "us-ascii");
        byte[] bytes = new Base64().decode(base64);
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(bytes), new Inflater(true));
        Assert.assertThat((Object)new String(IOUtils.toByteArray((InputStream)in), "utf-8"), (Matcher)CoreMatchers.containsString((String)"<?xml"));
    }

    private String generateGoogleSAMLRequestParameter() throws UnsupportedEncodingException, IOException {
        String acsURL = this.getBaseUrl() + "/console/500.jsp";
        String requestXML = SAMPLE_GOOGLE_REQUEST.replaceAll("https://www.google.com/a/thanksforcomingin.com/acs", acsURL);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)bout, new Deflater(9, true));
        ((OutputStream)out).write(requestXML.getBytes("utf-8"));
        ((OutputStream)out).close();
        String encodedXML = new Base64().encodeToString(bout.toByteArray());
        encodedXML = URLEncoder.encode(encodedXML, "us-ascii");
        return encodedXML;
    }
}

