/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.plugin;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class ViewApplicationPluginTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("googletest.xml");
    }

    public void testViewPluginApplication() {
        this.log("Running testViewPluginApplication");
        this.gotoViewApplication("google-apps");
        this.assertElementPresent("topnavBrowseApplication");
        this.assertElementPresent("browse-application");
        this.assertElementPresent("add-application");
        this.assertElementNotPresent("remove-application");
        this.assertElementPresent("application-directories");
        this.assertElementPresent("application-groups");
        this.assertElementPresent("application-users");
        this.assertElementPresent("application-permissions");
        this.assertElementNotPresent("application-remoteaddresses");
        this.assertElementPresent("application-authtest");
        this.assertElementPresent("application-options");
        this.assertElementPresent("samlConfigTab");
    }

    public void testViewPluginConfiguration() {
        this.log("Running testViewPluginConfiguration");
        this.gotoViewApplication("google-apps");
        this.clickLink("samlConfigTab");
        this.assertElementPresent("topnavBrowseApplication");
        this.assertElementPresent("browse-application");
        this.assertElementPresent("add-application");
        this.assertElementNotPresent("remove-application");
        this.assertElementPresent("application-details");
        this.assertElementPresent("application-directories");
        this.assertElementPresent("application-groups");
        this.assertElementPresent("application-users");
        this.assertElementPresent("application-permissions");
        this.assertElementNotPresent("application-remoteaddresses");
        this.assertElementPresent("application-authtest");
        this.assertElementPresent("application-options");
        this.assertKeyPresent("saml.description.text");
    }

    public void testUpdateApplicationPlugin() {
        this.log("Running testUpdateApplicationPlugin");
        this.gotoViewApplication("google-apps");
        String description = "bogus";
        this.setTextField("applicationDescription", description);
        this.uncheckCheckbox("active");
        this.submit();
        this.assertTextFieldEquals("applicationDescription", description);
        this.assertCheckboxNotSelected("active");
        this.assertTextInElement("application-name", "google-apps");
    }
}

